/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.apache.hc.core5.http2.impl.nio.bootstrap;

import java.util.ArrayList;
import java.util.List;
import keycloakjar.org.apache.hc.core5.function.Callback;
import keycloakjar.org.apache.hc.core5.function.Decorator;
import keycloakjar.org.apache.hc.core5.function.Supplier;
import keycloakjar.org.apache.hc.core5.http.config.CharCodingConfig;
import keycloakjar.org.apache.hc.core5.http.impl.DefaultAddressResolver;
import keycloakjar.org.apache.hc.core5.http.impl.routing.RequestRouter;
import keycloakjar.org.apache.hc.core5.http.nio.AsyncPushConsumer;
import keycloakjar.org.apache.hc.core5.http.nio.ssl.TlsStrategy;
import keycloakjar.org.apache.hc.core5.http.protocol.HttpProcessor;
import keycloakjar.org.apache.hc.core5.http.protocol.UriPatternType;
import keycloakjar.org.apache.hc.core5.http2.config.H2Config;
import keycloakjar.org.apache.hc.core5.http2.impl.H2Processors;
import keycloakjar.org.apache.hc.core5.http2.impl.nio.ClientH2PrefaceHandler;
import keycloakjar.org.apache.hc.core5.http2.impl.nio.ClientH2StreamMultiplexerFactory;
import keycloakjar.org.apache.hc.core5.http2.impl.nio.H2StreamListener;
import keycloakjar.org.apache.hc.core5.http2.impl.nio.bootstrap.H2MultiplexingRequester;
import keycloakjar.org.apache.hc.core5.http2.nio.support.DefaultAsyncPushConsumerFactory;
import keycloakjar.org.apache.hc.core5.http2.ssl.H2ClientTlsStrategy;
import keycloakjar.org.apache.hc.core5.reactor.IOReactorConfig;
import keycloakjar.org.apache.hc.core5.reactor.IOSession;
import keycloakjar.org.apache.hc.core5.reactor.IOSessionListener;
import keycloakjar.org.apache.hc.core5.util.Args;

public class H2MultiplexingRequesterBootstrap {
    private final List<RequestRouter.Entry<Supplier<AsyncPushConsumer>>> routeEntries = new ArrayList<RequestRouter.Entry<Supplier<AsyncPushConsumer>>>();
    private UriPatternType uriPatternType;
    private IOReactorConfig ioReactorConfig;
    private HttpProcessor httpProcessor;
    private CharCodingConfig charCodingConfig;
    private H2Config h2Config;
    private TlsStrategy tlsStrategy;
    private boolean strictALPNHandshake;
    private Decorator<IOSession> ioSessionDecorator;
    private Callback<Exception> exceptionCallback;
    private IOSessionListener sessionListener;
    private H2StreamListener streamListener;

    private H2MultiplexingRequesterBootstrap() {
    }

    public static H2MultiplexingRequesterBootstrap bootstrap() {
        return new H2MultiplexingRequesterBootstrap();
    }

    public final H2MultiplexingRequesterBootstrap setIOReactorConfig(IOReactorConfig ioReactorConfig) {
        this.ioReactorConfig = ioReactorConfig;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setHttpProcessor(HttpProcessor httpProcessor) {
        this.httpProcessor = httpProcessor;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setH2Config(H2Config h2Config) {
        this.h2Config = h2Config;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setCharCodingConfig(CharCodingConfig charCodingConfig) {
        this.charCodingConfig = charCodingConfig;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setTlsStrategy(TlsStrategy tlsStrategy) {
        this.tlsStrategy = tlsStrategy;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setStrictALPNHandshake(boolean strictALPNHandshake) {
        this.strictALPNHandshake = strictALPNHandshake;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setIOSessionDecorator(Decorator<IOSession> ioSessionDecorator) {
        this.ioSessionDecorator = ioSessionDecorator;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setExceptionCallback(Callback<Exception> exceptionCallback) {
        this.exceptionCallback = exceptionCallback;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setIOSessionListener(IOSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setStreamListener(H2StreamListener streamListener) {
        this.streamListener = streamListener;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap setUriPatternType(UriPatternType uriPatternType) {
        this.uriPatternType = uriPatternType;
        return this;
    }

    public final H2MultiplexingRequesterBootstrap register(String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Push consumer supplier");
        this.routeEntries.add(new RequestRouter.Entry<Supplier<AsyncPushConsumer>>(uriPattern, supplier));
        return this;
    }

    public final H2MultiplexingRequesterBootstrap register(String hostname, String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        Args.notBlank(hostname, "Hostname");
        Args.notBlank(uriPattern, "URI pattern");
        Args.notNull(supplier, "Push consumer supplier");
        this.routeEntries.add(new RequestRouter.Entry<Supplier<AsyncPushConsumer>>(hostname, uriPattern, supplier));
        return this;
    }

    @Deprecated
    public final H2MultiplexingRequesterBootstrap registerVirtual(String hostname, String uriPattern, Supplier<AsyncPushConsumer> supplier) {
        return this.register(hostname, uriPattern, supplier);
    }

    public H2MultiplexingRequester create() {
        RequestRouter<Supplier<AsyncPushConsumer>> requestRouter = RequestRouter.create(null, this.uriPatternType, this.routeEntries, RequestRouter.LOCAL_AUTHORITY_RESOLVER, null);
        ClientH2StreamMultiplexerFactory http2StreamHandlerFactory = new ClientH2StreamMultiplexerFactory(this.httpProcessor != null ? this.httpProcessor : H2Processors.client(), new DefaultAsyncPushConsumerFactory(requestRouter), this.h2Config != null ? this.h2Config : H2Config.DEFAULT, this.charCodingConfig != null ? this.charCodingConfig : CharCodingConfig.DEFAULT, this.streamListener);
        return new H2MultiplexingRequester(this.ioReactorConfig, (ioSession, attachment) -> new ClientH2PrefaceHandler(ioSession, http2StreamHandlerFactory, this.strictALPNHandshake, this.exceptionCallback), this.ioSessionDecorator, this.exceptionCallback, this.sessionListener, DefaultAddressResolver.INSTANCE, this.tlsStrategy != null ? this.tlsStrategy : new H2ClientTlsStrategy());
    }
}

