/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.hint.support;

import java.time.Instant;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import keycloakjar.org.springframework.aot.hint.ExecutableMode;
import keycloakjar.org.springframework.aot.hint.MemberCategory;
import keycloakjar.org.springframework.aot.hint.ReflectionHints;
import keycloakjar.org.springframework.aot.hint.RuntimeHints;
import keycloakjar.org.springframework.aot.hint.RuntimeHintsRegistrar;
import keycloakjar.org.springframework.aot.hint.TypeReference;
import keycloakjar.org.springframework.lang.Nullable;

class ObjectToObjectConverterRuntimeHints
implements RuntimeHintsRegistrar {
    ObjectToObjectConverterRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        ReflectionHints reflectionHints = hints.reflection();
        TypeReference sqlDateTypeReference = TypeReference.of("java.sql.Date");
        reflectionHints.registerTypeIfPresent(classLoader, sqlDateTypeReference.getName(), hint -> hint.withMethod("toLocalDate", Collections.emptyList(), ExecutableMode.INVOKE).onReachableType(sqlDateTypeReference).withMethod("valueOf", List.of(TypeReference.of(LocalDate.class)), ExecutableMode.INVOKE).onReachableType(sqlDateTypeReference));
        TypeReference sqlTimestampTypeReference = TypeReference.of("java.sql.Timestamp");
        reflectionHints.registerTypeIfPresent(classLoader, sqlTimestampTypeReference.getName(), hint -> hint.withMethod("from", List.of(TypeReference.of(Instant.class)), ExecutableMode.INVOKE).onReachableType(sqlTimestampTypeReference));
        reflectionHints.registerTypeIfPresent(classLoader, "keycloakjar.org.springframework.http.HttpMethod", builder -> builder.withMethod("valueOf", List.of(TypeReference.of(String.class)), ExecutableMode.INVOKE));
        reflectionHints.registerTypeIfPresent(classLoader, "java.net.URI", MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
    }
}

