/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.aot.nativex;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import keycloakjar.org.springframework.aot.hint.TypeReference;

class BasicJsonWriter {
    private final IndentingWriter writer;

    public BasicJsonWriter(Writer writer, String singleIndent) {
        this.writer = new IndentingWriter(writer, singleIndent);
    }

    public BasicJsonWriter(Writer writer) {
        this(writer, "  ");
    }

    public void writeObject(Map<String, Object> attributes) {
        this.writeObject(attributes, true);
    }

    public void writeArray(List<?> items) {
        this.writeArray(items, true);
    }

    private void writeObject(Map<String, Object> attributes, boolean newLine) {
        if (attributes.isEmpty()) {
            this.writer.print("{ }");
        } else {
            this.writer.println("{").indented(this.writeAll(attributes.entrySet().iterator(), entry -> this.writeAttribute((String)entry.getKey(), entry.getValue()))).print("}");
        }
        if (newLine) {
            this.writer.println();
        }
    }

    private void writeArray(List<?> items, boolean newLine) {
        if (items.isEmpty()) {
            this.writer.print("[ ]");
        } else {
            this.writer.println("[").indented(this.writeAll(items.iterator(), this::writeValue)).print("]");
        }
        if (newLine) {
            this.writer.println();
        }
    }

    private <T> Runnable writeAll(Iterator<T> it, Consumer<T> writer) {
        return () -> {
            while (it.hasNext()) {
                writer.accept(it.next());
                if (it.hasNext()) {
                    this.writer.println(",");
                    continue;
                }
                this.writer.println();
            }
        };
    }

    private void writeAttribute(String name, Object value) {
        this.writer.print(this.quote(name) + ": ");
        this.writeValue(value);
    }

    private void writeValue(Object value) {
        if (value instanceof Map) {
            Map map = (Map)value;
            this.writeObject(map, false);
        } else if (value instanceof List) {
            List list = (List)value;
            this.writeArray(list, false);
        } else if (value instanceof TypeReference) {
            TypeReference typeReference = (TypeReference)value;
            this.writer.print(this.quote(typeReference.getName()));
        } else if (value instanceof CharSequence) {
            CharSequence string = (CharSequence)value;
            this.writer.print(this.quote(BasicJsonWriter.escape(string)));
        } else if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            this.writer.print(Boolean.toString(flag));
        } else {
            throw new IllegalStateException("unsupported type: " + String.valueOf(value.getClass()));
        }
    }

    private String quote(String name) {
        return "\"" + name + "\"";
    }

    private static String escape(CharSequence input) {
        StringBuilder builder = new StringBuilder();
        input.chars().forEach(c -> builder.append(switch (c) {
            case 34 -> "\\\"";
            case 92 -> "\\\\";
            case 47 -> "\\/";
            case 8 -> "\\b";
            case 12 -> "\\f";
            case 10 -> "\\n";
            case 13 -> "\\r";
            case 9 -> "\\t";
            default -> c <= 31 ? String.format("\\u%04x", c) : Character.valueOf((char)c);
        }));
        return builder.toString();
    }

    static class IndentingWriter
    extends Writer {
        private final Writer out;
        private final String singleIndent;
        private int level = 0;
        private String currentIndent = "";
        private boolean prependIndent = false;

        IndentingWriter(Writer out, String singleIndent) {
            this.out = out;
            this.singleIndent = singleIndent;
        }

        public IndentingWriter print(String string) {
            this.write(string.toCharArray(), 0, string.length());
            return this;
        }

        public IndentingWriter println(String string) {
            this.write(string.toCharArray(), 0, string.length());
            return this.println();
        }

        public IndentingWriter println() {
            String separator = System.lineSeparator();
            try {
                this.out.write(separator.toCharArray(), 0, separator.length());
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
            this.prependIndent = true;
            return this;
        }

        public IndentingWriter indented(Runnable runnable) {
            this.indent();
            runnable.run();
            return this.outdent();
        }

        private IndentingWriter indent() {
            ++this.level;
            return this.refreshIndent();
        }

        private IndentingWriter outdent() {
            --this.level;
            return this.refreshIndent();
        }

        private IndentingWriter refreshIndent() {
            this.currentIndent = this.singleIndent.repeat(Math.max(0, this.level));
            return this;
        }

        @Override
        public void write(char[] chars, int offset, int length) {
            try {
                if (this.prependIndent) {
                    this.out.write(this.currentIndent.toCharArray(), 0, this.currentIndent.length());
                    this.prependIndent = false;
                }
                this.out.write(chars, offset, length);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }
    }
}

