/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import keycloakjar.org.springframework.beans.BeansException;
import keycloakjar.org.springframework.beans.factory.BeanCreationException;
import keycloakjar.org.springframework.beans.factory.BeanCurrentlyInCreationException;
import keycloakjar.org.springframework.beans.factory.FactoryBean;
import keycloakjar.org.springframework.beans.factory.FactoryBeanNotInitializedException;
import keycloakjar.org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import keycloakjar.org.springframework.beans.factory.support.NullBean;
import keycloakjar.org.springframework.core.AttributeAccessor;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.lang.Nullable;

public abstract class FactoryBeanRegistrySupport
extends DefaultSingletonBeanRegistry {
    private final Map<String, Object> factoryBeanObjectCache = new ConcurrentHashMap<String, Object>(16);

    @Nullable
    protected Class<?> getTypeForFactoryBean(FactoryBean<?> factoryBean) {
        try {
            return factoryBean.getObjectType();
        }
        catch (Throwable ex) {
            this.logger.info("FactoryBean threw exception from getObjectType, despite the contract saying that it should return null if the type of its object cannot be determined yet", ex);
            return null;
        }
    }

    ResolvableType getTypeForFactoryBeanFromAttributes(AttributeAccessor attributes) {
        Object attribute = attributes.getAttribute("factoryBeanObjectType");
        if (attribute == null) {
            return ResolvableType.NONE;
        }
        if (attribute instanceof ResolvableType) {
            ResolvableType resolvableType = (ResolvableType)attribute;
            return resolvableType;
        }
        if (attribute instanceof Class) {
            Class clazz = (Class)attribute;
            return ResolvableType.forClass(clazz);
        }
        throw new IllegalArgumentException("Invalid value type for attribute 'factoryBeanObjectType': " + attribute.getClass().getName());
    }

    ResolvableType getFactoryBeanGeneric(@Nullable ResolvableType type) {
        return type != null ? type.as(FactoryBean.class).getGeneric(new int[0]) : ResolvableType.NONE;
    }

    @Nullable
    protected Object getCachedObjectForFactoryBean(String beanName) {
        return this.factoryBeanObjectCache.get(beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object getObjectFromFactoryBean(FactoryBean<?> factory, String beanName, boolean shouldPostProcess) {
        if (factory.isSingleton() && this.containsSingleton(beanName)) {
            Object object;
            Object object2;
            boolean locked;
            Boolean lockFlag = this.isCurrentThreadAllowedToHoldSingletonLock();
            if (lockFlag == null) {
                this.singletonLock.lock();
                locked = true;
            } else {
                locked = lockFlag != false && this.singletonLock.tryLock();
            }
            try {
                FactoryBean<?> factoryBean = factory;
                synchronized (factoryBean) {
                    object2 = this.factoryBeanObjectCache.get(beanName);
                    if (object2 != null) break block20;
                    object2 = this.doGetObjectFromFactoryBean(factory, beanName);
                    Object alreadyThere = this.factoryBeanObjectCache.get(beanName);
                    if (alreadyThere != null) {
                        object2 = alreadyThere;
                        break block20;
                    }
                    if (!shouldPostProcess) break block21;
                    if (!locked) break block22;
                    if (this.isSingletonCurrentlyInCreation(beanName)) {
                        Object object3 = object2;
                        // MONITOREXIT @DISABLED, blocks:[0, 17, 19, 7] lbl22 : MonitorExitStatement: MONITOREXIT : var6_8
                        if (!locked) return object3;
                        this.singletonLock.unlock();
                        return object3;
                    }
                }
            }
            catch (Throwable throwable) {
                if (!locked) throw throwable;
                this.singletonLock.unlock();
                throw throwable;
            }
            {
                block20: {
                    block21: {
                        block22: {
                            this.beforeSingletonCreation(beanName);
                        }
                        try {
                            object2 = this.postProcessObjectFromFactoryBean(object2, beanName);
                        }
                        catch (Throwable ex) {
                            throw new BeanCreationException(beanName, "Post-processing of FactoryBean's singleton object failed", ex);
                        }
                        finally {
                            if (locked) {
                                this.afterSingletonCreation(beanName);
                            }
                        }
                    }
                    if (this.containsSingleton(beanName)) {
                        this.factoryBeanObjectCache.put(beanName, object2);
                    }
                }
                object = object2;
            }
            if (!locked) return object;
            this.singletonLock.unlock();
            return object;
        }
        Object object = this.doGetObjectFromFactoryBean(factory, beanName);
        if (!shouldPostProcess) return object;
        try {
            return this.postProcessObjectFromFactoryBean(object, beanName);
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "Post-processing of FactoryBean's object failed", ex);
        }
    }

    private Object doGetObjectFromFactoryBean(FactoryBean<?> factory, String beanName) throws BeanCreationException {
        Object object;
        try {
            object = factory.getObject();
        }
        catch (FactoryBeanNotInitializedException ex) {
            throw new BeanCurrentlyInCreationException(beanName, ex.toString());
        }
        catch (Throwable ex) {
            throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
        }
        if (object == null) {
            if (this.isSingletonCurrentlyInCreation(beanName)) {
                throw new BeanCurrentlyInCreationException(beanName, "FactoryBean which is currently in creation returned null from getObject");
            }
            object = new NullBean();
        }
        return object;
    }

    protected Object postProcessObjectFromFactoryBean(Object object, String beanName) throws BeansException {
        return object;
    }

    protected FactoryBean<?> getFactoryBean(String beanName, Object beanInstance) throws BeansException {
        if (!(beanInstance instanceof FactoryBean)) {
            throw new BeanCreationException(beanName, "Bean instance of type [" + String.valueOf(beanInstance.getClass()) + "] is not a FactoryBean");
        }
        FactoryBean factoryBean = (FactoryBean)beanInstance;
        return factoryBean;
    }

    @Override
    protected void removeSingleton(String beanName) {
        super.removeSingleton(beanName);
        this.factoryBeanObjectCache.remove(beanName);
    }

    @Override
    protected void clearSingletonCache() {
        super.clearSingletonCache();
        this.factoryBeanObjectCache.clear();
    }
}

