/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.beans.factory.support;

import java.util.LinkedHashMap;
import java.util.Map;
import keycloakjar.org.springframework.beans.factory.BeanFactoryUtils;
import keycloakjar.org.springframework.beans.factory.ListableBeanFactory;
import keycloakjar.org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import keycloakjar.org.springframework.beans.factory.support.AutowireCandidateResolver;
import keycloakjar.org.springframework.beans.factory.support.AutowireUtils;
import keycloakjar.org.springframework.beans.factory.support.NullBean;

public class SimpleAutowireCandidateResolver
implements AutowireCandidateResolver {
    public static final SimpleAutowireCandidateResolver INSTANCE = new SimpleAutowireCandidateResolver();

    @Override
    public AutowireCandidateResolver cloneIfNecessary() {
        return this;
    }

    public static <T> Map<String, T> resolveAutowireCandidates(ConfigurableListableBeanFactory lbf, Class<T> type) {
        return SimpleAutowireCandidateResolver.resolveAutowireCandidates(lbf, type, true, true);
    }

    public static <T> Map<String, T> resolveAutowireCandidates(ConfigurableListableBeanFactory lbf, Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) {
        LinkedHashMap<String, Object> candidates = new LinkedHashMap<String, Object>();
        for (String beanName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)lbf, type, includeNonSingletons, allowEagerInit)) {
            Object beanInstance;
            if (!AutowireUtils.isAutowireCandidate(lbf, beanName) || (beanInstance = lbf.getBean(beanName)) instanceof NullBean) continue;
            candidates.put(beanName, beanInstance);
        }
        return candidates;
    }
}

