/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.core.task;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import keycloakjar.org.springframework.core.task.AsyncListenableTaskExecutor;
import keycloakjar.org.springframework.core.task.TaskDecorator;
import keycloakjar.org.springframework.core.task.TaskRejectedException;
import keycloakjar.org.springframework.core.task.VirtualThreadDelegate;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ConcurrencyThrottleSupport;
import keycloakjar.org.springframework.util.CustomizableThreadCreator;
import keycloakjar.org.springframework.util.concurrent.ListenableFuture;
import keycloakjar.org.springframework.util.concurrent.ListenableFutureTask;

public class SimpleAsyncTaskExecutor
extends CustomizableThreadCreator
implements AsyncListenableTaskExecutor,
Serializable,
AutoCloseable {
    public static final int UNBOUNDED_CONCURRENCY = -1;
    public static final int NO_CONCURRENCY = 0;
    private final ConcurrencyThrottleAdapter concurrencyThrottle = new ConcurrencyThrottleAdapter();
    @Nullable
    private VirtualThreadDelegate virtualThreadDelegate;
    @Nullable
    private ThreadFactory threadFactory;
    @Nullable
    private TaskDecorator taskDecorator;
    private long taskTerminationTimeout;
    @Nullable
    private Set<Thread> activeThreads;
    private boolean cancelRemainingTasksOnClose = false;
    private boolean rejectTasksWhenLimitReached = false;
    private volatile boolean active = true;

    public SimpleAsyncTaskExecutor() {
    }

    public SimpleAsyncTaskExecutor(String threadNamePrefix) {
        super(threadNamePrefix);
    }

    public SimpleAsyncTaskExecutor(ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    public void setVirtualThreads(boolean virtual) {
        this.virtualThreadDelegate = virtual ? new VirtualThreadDelegate() : null;
    }

    public void setThreadFactory(@Nullable ThreadFactory threadFactory) {
        this.threadFactory = threadFactory;
    }

    @Nullable
    public final ThreadFactory getThreadFactory() {
        return this.threadFactory;
    }

    public void setTaskDecorator(TaskDecorator taskDecorator) {
        this.taskDecorator = taskDecorator;
    }

    public void setTaskTerminationTimeout(long timeout) {
        Assert.isTrue(timeout >= 0L, "Timeout value must be >=0");
        this.taskTerminationTimeout = timeout;
        this.trackActiveThreadsIfNecessary();
    }

    public void setCancelRemainingTasksOnClose(boolean cancelRemainingTasksOnClose) {
        this.cancelRemainingTasksOnClose = cancelRemainingTasksOnClose;
        this.trackActiveThreadsIfNecessary();
    }

    public void setRejectTasksWhenLimitReached(boolean rejectTasksWhenLimitReached) {
        this.rejectTasksWhenLimitReached = rejectTasksWhenLimitReached;
    }

    public void setConcurrencyLimit(int concurrencyLimit) {
        this.concurrencyThrottle.setConcurrencyLimit(concurrencyLimit);
    }

    public final int getConcurrencyLimit() {
        return this.concurrencyThrottle.getConcurrencyLimit();
    }

    public final boolean isThrottleActive() {
        return this.concurrencyThrottle.isThrottleActive();
    }

    public boolean isActive() {
        return this.active;
    }

    private void trackActiveThreadsIfNecessary() {
        this.activeThreads = this.taskTerminationTimeout > 0L || this.cancelRemainingTasksOnClose ? ConcurrentHashMap.newKeySet() : null;
    }

    @Override
    public void execute(Runnable task) {
        this.execute(task, Long.MAX_VALUE);
    }

    @Override
    @Deprecated
    public void execute(Runnable task, long startTimeout) {
        Runnable taskToUse;
        Assert.notNull((Object)task, "Runnable must not be null");
        if (!this.isActive()) {
            throw new TaskRejectedException(this.getClass().getSimpleName() + " has been closed already");
        }
        Runnable runnable = taskToUse = this.taskDecorator != null ? this.taskDecorator.decorate(task) : task;
        if (this.isThrottleActive() && startTimeout > 0L) {
            this.concurrencyThrottle.beforeAccess();
            this.doExecute(new TaskTrackingRunnable(taskToUse));
        } else if (this.activeThreads != null) {
            this.doExecute(new TaskTrackingRunnable(taskToUse));
        } else {
            this.doExecute(taskToUse);
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        FutureTask<Object> future = new FutureTask<Object>(task, null);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        FutureTask<T> future = new FutureTask<T>(task);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    @Override
    public ListenableFuture<?> submitListenable(Runnable task) {
        ListenableFutureTask<Object> future = new ListenableFutureTask<Object>(task, null);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    @Override
    public <T> ListenableFuture<T> submitListenable(Callable<T> task) {
        ListenableFutureTask<T> future = new ListenableFutureTask<T>(task);
        this.execute(future, Long.MAX_VALUE);
        return future;
    }

    protected void doExecute(Runnable task) {
        this.newThread(task).start();
    }

    protected Thread newThread(Runnable task) {
        if (this.virtualThreadDelegate != null) {
            return this.virtualThreadDelegate.newVirtualThread(this.nextThreadName(), task);
        }
        return this.threadFactory != null ? this.threadFactory.newThread(task) : this.createThread(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.active) {
            this.active = false;
            Set<Thread> threads = this.activeThreads;
            if (threads != null) {
                if (this.cancelRemainingTasksOnClose) {
                    threads.forEach(Thread::interrupt);
                }
                if (this.taskTerminationTimeout > 0L) {
                    Set<Thread> set = threads;
                    synchronized (set) {
                        try {
                            if (!threads.isEmpty()) {
                                threads.wait(this.taskTerminationTimeout);
                            }
                        }
                        catch (InterruptedException ex) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    if (!this.cancelRemainingTasksOnClose) {
                        threads.forEach(Thread::interrupt);
                    }
                }
            }
        }
    }

    private class ConcurrencyThrottleAdapter
    extends ConcurrencyThrottleSupport {
        private ConcurrencyThrottleAdapter() {
        }

        @Override
        protected void beforeAccess() {
            super.beforeAccess();
        }

        @Override
        protected void onLimitReached() {
            if (SimpleAsyncTaskExecutor.this.rejectTasksWhenLimitReached) {
                throw new TaskRejectedException("Concurrency limit reached: " + this.getConcurrencyLimit());
            }
            super.onLimitReached();
        }

        @Override
        protected void afterAccess() {
            super.afterAccess();
        }
    }

    private class TaskTrackingRunnable
    implements Runnable {
        private final Runnable task;

        public TaskTrackingRunnable(Runnable task) {
            Assert.notNull((Object)task, "Task must not be null");
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Set<Thread> threads = SimpleAsyncTaskExecutor.this.activeThreads;
            Thread thread = null;
            if (threads != null) {
                thread = Thread.currentThread();
                threads.add(thread);
            }
            try {
                this.task.run();
            }
            finally {
                if (threads != null) {
                    threads.remove(thread);
                    if (!SimpleAsyncTaskExecutor.this.isActive()) {
                        Set<Thread> set = threads;
                        synchronized (set) {
                            if (threads.isEmpty()) {
                                threads.notify();
                            }
                        }
                    }
                }
                SimpleAsyncTaskExecutor.this.concurrencyThrottle.afterAccess();
            }
        }
    }
}

