/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.CharSequenceEncoder;
import keycloakjar.org.springframework.core.codec.Encoder;
import keycloakjar.org.springframework.core.codec.EncodingException;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.codec.KotlinSerializationSupport;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.MimeType;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.StringFormat;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class KotlinSerializationStringEncoder<T extends StringFormat>
extends KotlinSerializationSupport<T>
implements Encoder<Object> {
    private static final byte[] NEWLINE_SEPARATOR = new byte[]{10};
    protected static final byte[] EMPTY_BYTES = new byte[0];
    private final CharSequenceEncoder charSequenceEncoder = CharSequenceEncoder.allMimeTypes();
    private final Set<MimeType> streamingMediaTypes = new HashSet<MimeType>();

    protected KotlinSerializationStringEncoder(T format, MimeType ... supportedMimeTypes) {
        super(format, supportedMimeTypes);
    }

    public void setStreamingMediaTypes(Collection<MediaType> streamingMediaTypes) {
        this.streamingMediaTypes.clear();
        this.streamingMediaTypes.addAll(streamingMediaTypes);
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        return this.canSerialize(elementType, mimeType);
    }

    @Override
    public List<MimeType> getEncodableMimeTypes() {
        return this.supportedMimeTypes();
    }

    @Override
    public List<MimeType> getEncodableMimeTypes(ResolvableType elementType) {
        return this.supportedMimeTypes();
    }

    @Override
    public Flux<DataBuffer> encode(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (inputStream instanceof Mono) {
            Mono mono = (Mono)inputStream;
            return mono.map(value -> this.encodeValue(value, bufferFactory, elementType, mimeType, hints)).flux();
        }
        if (mimeType != null && this.streamingMediaTypes.contains(mimeType)) {
            return Flux.from(inputStream).map(value -> this.encodeStreamingValue(value, bufferFactory, elementType, mimeType, hints, EMPTY_BYTES, NEWLINE_SEPARATOR));
        }
        return this.encodeNonStream(inputStream, bufferFactory, elementType, mimeType, hints);
    }

    protected DataBuffer encodeStreamingValue(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints, byte[] prefix, byte[] suffix) {
        ArrayList<DataBuffer> buffers = new ArrayList<DataBuffer>(3);
        if (prefix.length > 0) {
            buffers.add(bufferFactory.allocateBuffer(prefix.length).write(prefix));
        }
        buffers.add(this.encodeValue(value, bufferFactory, valueType, mimeType, hints));
        if (suffix.length > 0) {
            buffers.add(bufferFactory.allocateBuffer(suffix.length).write(suffix));
        }
        return bufferFactory.join(buffers);
    }

    protected Flux<DataBuffer> encodeNonStream(Publisher<?> inputStream, DataBufferFactory bufferFactory, ResolvableType elementType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        ResolvableType listType = ResolvableType.forClassWithGenerics(List.class, elementType);
        return Flux.from(inputStream).collectList().map(list -> this.encodeValue(list, bufferFactory, listType, mimeType, hints)).flux();
    }

    @Override
    public DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        KSerializer<Object> serializer = this.serializer(valueType);
        if (serializer == null) {
            throw new EncodingException("Could not find KSerializer for " + String.valueOf(valueType));
        }
        String string = ((StringFormat)this.format()).encodeToString(serializer, value);
        return this.charSequenceEncoder.encodeValue(string, bufferFactory, valueType, mimeType, (Map<String, Object>)null);
    }
}

