/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.codec.xml;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.MarshalException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.core.codec.AbstractSingleValueEncoder;
import keycloakjar.org.springframework.core.codec.CodecException;
import keycloakjar.org.springframework.core.codec.EncodingException;
import keycloakjar.org.springframework.core.codec.Hints;
import keycloakjar.org.springframework.core.io.buffer.DataBuffer;
import keycloakjar.org.springframework.core.io.buffer.DataBufferFactory;
import keycloakjar.org.springframework.core.io.buffer.DataBufferUtils;
import keycloakjar.org.springframework.core.log.LogFormatUtils;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.codec.xml.JaxbContextContainer;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.ClassUtils;
import keycloakjar.org.springframework.util.MimeType;
import keycloakjar.org.springframework.util.MimeTypeUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class Jaxb2XmlEncoder
extends AbstractSingleValueEncoder<Object> {
    private final JaxbContextContainer jaxbContexts = new JaxbContextContainer();
    private Function<Marshaller, Marshaller> marshallerProcessor = Function.identity();

    public Jaxb2XmlEncoder() {
        super(MimeTypeUtils.APPLICATION_XML, MimeTypeUtils.TEXT_XML, new MediaType("application", "*+xml"));
    }

    public void setMarshallerProcessor(Function<Marshaller, Marshaller> processor) {
        this.marshallerProcessor = this.marshallerProcessor.andThen(processor);
    }

    public Function<Marshaller, Marshaller> getMarshallerProcessor() {
        return this.marshallerProcessor;
    }

    @Override
    public boolean canEncode(ResolvableType elementType, @Nullable MimeType mimeType) {
        if (super.canEncode(elementType, mimeType)) {
            Class<?> outputClass = elementType.toClass();
            return outputClass.isAnnotationPresent(XmlRootElement.class) || outputClass.isAnnotationPresent(XmlType.class) || JAXBElement.class.isAssignableFrom(outputClass);
        }
        return false;
    }

    @Override
    protected Flux<DataBuffer> encode(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        return Mono.fromCallable(() -> this.encodeValue(value, bufferFactory, valueType, mimeType, hints)).flux();
    }

    @Override
    public DataBuffer encodeValue(Object value, DataBufferFactory bufferFactory, ResolvableType valueType, @Nullable MimeType mimeType, @Nullable Map<String, Object> hints) {
        if (!Hints.isLoggingSuppressed(hints)) {
            LogFormatUtils.traceDebug(this.logger, traceOn -> {
                String formatted = LogFormatUtils.formatValue(value, traceOn == false);
                return Hints.getLogPrefix(hints) + "Encoding [" + formatted + "]";
            });
        }
        boolean release = true;
        DataBuffer buffer = bufferFactory.allocateBuffer(1024);
        try {
            OutputStream outputStream = buffer.asOutputStream();
            Class<?> clazz = Jaxb2XmlEncoder.getMarshallerType(value);
            Marshaller marshaller = this.initMarshaller(clazz);
            marshaller.marshal(value, outputStream);
            release = false;
            DataBuffer dataBuffer = buffer;
            return dataBuffer;
        }
        catch (MarshalException ex) {
            throw new EncodingException("Could not marshal " + String.valueOf(value.getClass()) + " to XML", ex);
        }
        catch (JAXBException ex) {
            throw new CodecException("Invalid JAXB configuration", ex);
        }
        finally {
            if (release) {
                DataBufferUtils.release(buffer);
            }
        }
    }

    private static Class<?> getMarshallerType(Object value) {
        if (value instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)value;
            return jaxbElement.getDeclaredType();
        }
        return ClassUtils.getUserClass(value);
    }

    private Marshaller initMarshaller(Class<?> clazz) throws CodecException, JAXBException {
        Marshaller marshaller = this.jaxbContexts.createMarshaller(clazz);
        marshaller.setProperty("jaxb.encoding", (Object)StandardCharsets.UTF_8.name());
        marshaller = this.marshallerProcessor.apply(marshaller);
        return marshaller;
    }
}

