/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.converter;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import keycloakjar.org.springframework.core.KotlinDetector;
import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.core.ResolvableType;
import keycloakjar.org.springframework.http.HttpInputMessage;
import keycloakjar.org.springframework.http.HttpOutputMessage;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.converter.AbstractSmartHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.HttpMessageNotReadableException;
import keycloakjar.org.springframework.http.converter.HttpMessageNotWritableException;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ConcurrentReferenceHashMap;
import kotlin.reflect.KCallable;
import kotlin.reflect.KFunction;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.jvm.ReflectJvmMapping;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.modules.SerializersModule;

public abstract class AbstractKotlinSerializationHttpMessageConverter<T extends SerialFormat>
extends AbstractSmartHttpMessageConverter<Object> {
    private final Map<KType, KSerializer<Object>> kTypeSerializerCache = new ConcurrentReferenceHashMap<KType, KSerializer<Object>>();
    private final Map<Type, KSerializer<Object>> typeSerializerCache = new ConcurrentReferenceHashMap<Type, KSerializer<Object>>();
    private final T format;

    protected AbstractKotlinSerializationHttpMessageConverter(T format, MediaType ... supportedMediaTypes) {
        super(supportedMediaTypes);
        this.format = format;
    }

    @Override
    public List<MediaType> getSupportedMediaTypes(Class<?> clazz) {
        return this.getSupportedMediaTypes();
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        return this.serializer(ResolvableType.forClass(clazz)) != null;
    }

    @Override
    public boolean canRead(ResolvableType type, @Nullable MediaType mediaType) {
        if (!ResolvableType.NONE.equals(type) && this.serializer(type) != null) {
            return this.canRead(mediaType);
        }
        return false;
    }

    @Override
    public boolean canWrite(ResolvableType type, Class<?> clazz, @Nullable MediaType mediaType) {
        if (!ResolvableType.NONE.equals(type) && this.serializer(type) != null) {
            return this.canWrite(mediaType);
        }
        return false;
    }

    @Override
    public final Object read(ResolvableType type, HttpInputMessage inputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotReadableException {
        KSerializer<Object> serializer = this.serializer(type);
        if (serializer == null) {
            throw new HttpMessageNotReadableException("Could not find KSerializer for " + String.valueOf(type), inputMessage);
        }
        return this.readInternal(serializer, this.format, inputMessage);
    }

    protected abstract Object readInternal(KSerializer<Object> var1, T var2, HttpInputMessage var3) throws IOException, HttpMessageNotReadableException;

    @Override
    protected final void writeInternal(Object object, ResolvableType type, HttpOutputMessage outputMessage, @Nullable Map<String, Object> hints) throws IOException, HttpMessageNotWritableException {
        ResolvableType resolvableType = ResolvableType.NONE.equals(type) ? ResolvableType.forInstance(object) : type;
        KSerializer<Object> serializer = this.serializer(resolvableType);
        if (serializer == null) {
            throw new HttpMessageNotWritableException("Could not find KSerializer for " + String.valueOf(resolvableType));
        }
        this.writeInternal(object, serializer, this.format, outputMessage);
    }

    protected abstract void writeInternal(Object var1, KSerializer<Object> var2, T var3, HttpOutputMessage var4) throws IOException, HttpMessageNotWritableException;

    @Nullable
    private KSerializer<Object> serializer(ResolvableType resolvableType) {
        Type type;
        KSerializer serializer;
        Object object = resolvableType.getSource();
        if (object instanceof MethodParameter) {
            KFunction function;
            MethodParameter parameter = (MethodParameter)object;
            Method method = parameter.getMethod();
            Assert.notNull((Object)method, "Method must not be null");
            if (KotlinDetector.isKotlinType(method.getDeclaringClass()) && (function = ReflectJvmMapping.getKotlinFunction((Method)method)) != null) {
                KType type2 = parameter.getParameterIndex() == -1 ? function.getReturnType() : ((KParameter)KCallables.getValueParameters((KCallable)function).get(parameter.getParameterIndex())).getType();
                KSerializer serializer2 = this.kTypeSerializerCache.get(type2);
                if (serializer2 == null) {
                    try {
                        serializer2 = SerializersKt.serializerOrNull((SerializersModule)this.format.getSerializersModule(), (KType)type2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    if (serializer2 != null) {
                        if (this.hasPolymorphism(serializer2.getDescriptor(), new HashSet<String>())) {
                            return null;
                        }
                        this.kTypeSerializerCache.put(type2, (KSerializer<Object>)serializer2);
                    }
                }
                return serializer2;
            }
        }
        if ((serializer = this.typeSerializerCache.get(type = resolvableType.getType())) == null) {
            try {
                serializer = SerializersKt.serializerOrNull((SerializersModule)this.format.getSerializersModule(), (Type)type);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (serializer != null) {
                if (this.hasPolymorphism(serializer.getDescriptor(), new HashSet<String>())) {
                    return null;
                }
                this.typeSerializerCache.put(type, (KSerializer<Object>)serializer);
            }
        }
        return serializer;
    }

    private boolean hasPolymorphism(SerialDescriptor descriptor, Set<String> alreadyProcessed) {
        alreadyProcessed.add(descriptor.getSerialName());
        if (descriptor.getKind().equals(PolymorphicKind.OPEN.INSTANCE)) {
            return true;
        }
        for (int i = 0; i < descriptor.getElementsCount(); ++i) {
            SerialDescriptor elementDescriptor = descriptor.getElementDescriptor(i);
            if (alreadyProcessed.contains(elementDescriptor.getSerialName()) || !this.hasPolymorphism(elementDescriptor, alreadyProcessed)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean supportsRepeatableWrites(Object object) {
        return true;
    }
}

