/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.converter;

import java.io.IOException;
import java.nio.charset.Charset;
import keycloakjar.org.springframework.core.convert.ConversionService;
import keycloakjar.org.springframework.http.HttpInputMessage;
import keycloakjar.org.springframework.http.HttpOutputMessage;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.http.converter.AbstractHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.HttpMessageNotReadableException;
import keycloakjar.org.springframework.http.converter.StringHttpMessageConverter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;

public class ObjectToStringHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    private final ConversionService conversionService;
    private final StringHttpMessageConverter stringHttpMessageConverter;

    public ObjectToStringHttpMessageConverter(ConversionService conversionService) {
        this(conversionService, StringHttpMessageConverter.DEFAULT_CHARSET);
    }

    public ObjectToStringHttpMessageConverter(ConversionService conversionService, Charset defaultCharset) {
        super(defaultCharset, MediaType.TEXT_PLAIN);
        Assert.notNull((Object)conversionService, "ConversionService is required");
        this.conversionService = conversionService;
        this.stringHttpMessageConverter = new StringHttpMessageConverter(defaultCharset);
    }

    public void setWriteAcceptCharset(boolean writeAcceptCharset) {
        this.stringHttpMessageConverter.setWriteAcceptCharset(writeAcceptCharset);
    }

    @Override
    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.canRead(mediaType) && this.conversionService.canConvert(String.class, clazz);
    }

    @Override
    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.canWrite(mediaType) && this.conversionService.canConvert(clazz, String.class);
    }

    @Override
    protected boolean supports(Class<?> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object readInternal(Class<?> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        Object value = this.stringHttpMessageConverter.readInternal(String.class, inputMessage);
        Object result = this.conversionService.convert(value, clazz);
        if (result == null) {
            throw new HttpMessageNotReadableException("Unexpected null conversion result for '" + (String)value + "' to " + String.valueOf(clazz), inputMessage);
        }
        return result;
    }

    @Override
    protected void writeInternal(Object obj, HttpOutputMessage outputMessage) throws IOException {
        String value = this.conversionService.convert(obj, String.class);
        if (value != null) {
            this.stringHttpMessageConverter.writeInternal(value, outputMessage);
        }
    }

    @Override
    protected Long getContentLength(Object obj, @Nullable MediaType contentType) {
        String value = this.conversionService.convert(obj, String.class);
        if (value == null) {
            return 0L;
        }
        return this.stringHttpMessageConverter.getContentLength(value, contentType);
    }

    @Override
    protected boolean supportsRepeatableWrites(Object o) {
        return true;
    }
}

