/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.server.reactive;

import keycloakjar.org.springframework.core.io.buffer.JettyDataBufferFactory;
import keycloakjar.org.springframework.http.server.reactive.HttpHandler;
import keycloakjar.org.springframework.http.server.reactive.JettyCoreServerHttpRequest;
import keycloakjar.org.springframework.http.server.reactive.JettyCoreServerHttpResponse;
import keycloakjar.org.springframework.util.Assert;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class JettyCoreHttpHandlerAdapter
extends Handler.Abstract.NonBlocking {
    private final HttpHandler httpHandler;
    private JettyDataBufferFactory dataBufferFactory = new JettyDataBufferFactory();

    public JettyCoreHttpHandlerAdapter(HttpHandler httpHandler) {
        this.httpHandler = httpHandler;
    }

    public void setDataBufferFactory(JettyDataBufferFactory dataBufferFactory) {
        Assert.notNull((Object)dataBufferFactory, "DataBufferFactory must not be null");
        this.dataBufferFactory = dataBufferFactory;
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        this.httpHandler.handle(new JettyCoreServerHttpRequest(request, this.dataBufferFactory), new JettyCoreServerHttpResponse(response, this.dataBufferFactory)).subscribe(unused -> {}, arg_0 -> ((Callback)callback).failed(arg_0), () -> ((Callback)callback).succeeded());
        return true;
    }
}

