/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.http.support;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import keycloakjar.org.apache.hc.core5.http.Header;
import keycloakjar.org.apache.hc.core5.http.HttpMessage;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.LinkedCaseInsensitiveMap;
import keycloakjar.org.springframework.util.MultiValueMap;

public final class HttpComponentsHeadersAdapter
implements MultiValueMap<String, String> {
    private final HttpMessage message;
    private final Set<String> headerNames;

    public HttpComponentsHeadersAdapter(HttpMessage message) {
        Assert.notNull((Object)message, "Message must not be null");
        this.message = message;
        this.headerNames = Collections.newSetFromMap(new LinkedCaseInsensitiveMap<Boolean>(message.getHeaders().length, Locale.ROOT));
        for (Header header : message.getHeaders()) {
            this.headerNames.add(header.getName());
        }
    }

    @Override
    @Nullable
    public String getFirst(String key) {
        Header header = this.message.getFirstHeader(key);
        return header != null ? header.getValue() : null;
    }

    @Override
    public void add(String key, @Nullable String value) {
        this.headerNames.add(key);
        this.message.addHeader(key, value);
    }

    @Override
    public void addAll(String key, List<? extends String> values) {
        values.forEach((? super T value) -> this.add(key, (String)value));
    }

    @Override
    public void addAll(MultiValueMap<String, String> values) {
        values.forEach(this::addAll);
    }

    @Override
    public void set(String key, @Nullable String value) {
        this.headerNames.add(key);
        this.message.setHeader(key, value);
    }

    @Override
    public void setAll(Map<String, String> values) {
        values.forEach(this::set);
    }

    @Override
    public Map<String, String> toSingleValueMap() {
        LinkedCaseInsensitiveMap<String> map = new LinkedCaseInsensitiveMap<String>(this.message.getHeaders().length, Locale.ROOT);
        this.message.headerIterator().forEachRemaining(h -> map.putIfAbsent(h.getName(), h.getValue()));
        return map;
    }

    @Override
    public int size() {
        return this.headerNames.size();
    }

    @Override
    public boolean isEmpty() {
        return this.message.getHeaders().length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        String headerName;
        return key instanceof String && this.message.containsHeader(headerName = (String)key);
    }

    @Override
    public boolean containsValue(Object value) {
        return value instanceof String && Arrays.stream(this.message.getHeaders()).anyMatch(h -> h.getValue().equals(value));
    }

    @Override
    @Nullable
    public List<String> get(Object key) {
        ArrayList<String> values = null;
        if (this.containsKey(key)) {
            Header[] headers = this.message.getHeaders((String)key);
            values = new ArrayList<String>(headers.length);
            for (Header header : headers) {
                values.add(header.getValue());
            }
        }
        return values;
    }

    @Override
    @Nullable
    public List<String> put(String key, List<String> values) {
        Object oldValues = this.remove(key);
        values.forEach((? super T value) -> this.add(key, (String)value));
        return oldValues;
    }

    @Override
    @Nullable
    public List<String> remove(Object key) {
        if (key instanceof String) {
            String headerName = (String)key;
            Object oldValues = this.get(key);
            this.headerNames.remove(headerName);
            this.message.removeHeaders(headerName);
            return oldValues;
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends List<String>> map) {
        map.forEach(this::put);
    }

    @Override
    public void clear() {
        this.headerNames.clear();
        this.message.setHeaders(new Header[0]);
    }

    @Override
    public Set<String> keySet() {
        return new HeaderNames();
    }

    @Override
    public Collection<List<String>> values() {
        ArrayList<List<String>> values = new ArrayList<List<String>>(this.message.getHeaders().length);
        for (String headerName : this.keySet()) {
            values.add((List<String>)this.get(headerName));
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, List<String>>> entrySet() {
        return new AbstractSet<Map.Entry<String, List<String>>>(){

            @Override
            public Iterator<Map.Entry<String, List<String>>> iterator() {
                return new EntryIterator();
            }

            @Override
            public int size() {
                return HttpComponentsHeadersAdapter.this.size();
            }
        };
    }

    public String toString() {
        return HttpHeaders.formatHeaders(this);
    }

    private class HeaderNames
    extends AbstractSet<String> {
        private HeaderNames() {
        }

        @Override
        public Iterator<String> iterator() {
            return new HeaderNamesIterator(HttpComponentsHeadersAdapter.this.headerNames.iterator());
        }

        @Override
        public int size() {
            return HttpComponentsHeadersAdapter.this.headerNames.size();
        }
    }

    private final class HeaderNamesIterator
    implements Iterator<String> {
        private final Iterator<String> iterator;
        @Nullable
        private String currentName;

        private HeaderNamesIterator(Iterator<String> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public String next() {
            this.currentName = this.iterator.next();
            return this.currentName;
        }

        @Override
        public void remove() {
            if (this.currentName == null) {
                throw new IllegalStateException("No current Header in iterator");
            }
            if (!HttpComponentsHeadersAdapter.this.message.containsHeader(this.currentName)) {
                throw new IllegalStateException("Header not present: " + this.currentName);
            }
            HttpComponentsHeadersAdapter.this.headerNames.remove(this.currentName);
            HttpComponentsHeadersAdapter.this.message.removeHeaders(this.currentName);
        }
    }

    private class HeaderEntry
    implements Map.Entry<String, List<String>> {
        private final String key;

        HeaderEntry(String key) {
            this.key = key;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public List<String> getValue() {
            List<String> values = HttpComponentsHeadersAdapter.this.get(this.key);
            return values != null ? values : Collections.emptyList();
        }

        @Override
        public List<String> setValue(List<String> value) {
            Object previousValues = this.getValue();
            HttpComponentsHeadersAdapter.this.put(this.key, value);
            return previousValues;
        }
    }

    private class EntryIterator
    implements Iterator<Map.Entry<String, List<String>>> {
        private final Iterator<String> iterator;

        private EntryIterator() {
            this.iterator = HttpComponentsHeadersAdapter.this.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Map.Entry<String, List<String>> next() {
            return new HeaderEntry(this.iterator.next());
        }
    }
}

