/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.objenesis.strategy;

import keycloakjar.org.springframework.objenesis.instantiator.ObjectInstantiator;
import keycloakjar.org.springframework.objenesis.instantiator.android.Android10Instantiator;
import keycloakjar.org.springframework.objenesis.instantiator.android.Android17Instantiator;
import keycloakjar.org.springframework.objenesis.instantiator.android.Android18Instantiator;
import keycloakjar.org.springframework.objenesis.instantiator.gcj.GCJInstantiator;
import keycloakjar.org.springframework.objenesis.instantiator.perc.PercInstantiator;
import keycloakjar.org.springframework.objenesis.instantiator.sun.SunReflectionFactoryInstantiator;
import keycloakjar.org.springframework.objenesis.instantiator.sun.UnsafeFactoryInstantiator;
import keycloakjar.org.springframework.objenesis.strategy.BaseInstantiatorStrategy;
import keycloakjar.org.springframework.objenesis.strategy.PlatformDescription;

public class StdInstantiatorStrategy
extends BaseInstantiatorStrategy {
    @Override
    public <T> ObjectInstantiator<T> newInstantiatorOf(Class<T> type) {
        if (PlatformDescription.isThisJVM("Java HotSpot") || PlatformDescription.isThisJVM("OpenJDK")) {
            return new SunReflectionFactoryInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("Dalvik")) {
            if (PlatformDescription.isAndroidOpenJDK()) {
                return new UnsafeFactoryInstantiator<T>(type);
            }
            if (PlatformDescription.ANDROID_VERSION <= 10) {
                return new Android10Instantiator<T>(type);
            }
            if (PlatformDescription.ANDROID_VERSION <= 17) {
                return new Android17Instantiator<T>(type);
            }
            return new Android18Instantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("GNU libgcj")) {
            return new GCJInstantiator<T>(type);
        }
        if (PlatformDescription.isThisJVM("PERC")) {
            return new PercInstantiator<T>(type);
        }
        return new UnsafeFactoryInstantiator<T>(type);
    }
}

