/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.util;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.FilteredSet;

final class FilteredMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> delegate;
    private final Predicate<K> filter;

    public FilteredMap(Map<K, V> delegate, Predicate<K> filter2) {
        Assert.notNull(delegate, "Delegate must not be null");
        Assert.notNull(filter2, "Filter must not be null");
        this.delegate = delegate;
        this.filter = filter2;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new FilteredSet<Map.Entry<K, V>>(this.delegate.entrySet(), entry -> this.filter.test(entry.getKey()));
    }

    @Override
    public int size() {
        int size = 0;
        for (K k : this.keySet()) {
            if (!this.filter.test(k)) continue;
            ++size;
        }
        return size;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.delegate.containsKey(key)) {
            return this.filter.test(key);
        }
        return false;
    }

    @Override
    @Nullable
    public V get(Object key) {
        V value = this.delegate.get(key);
        if (value != null && this.filter.test(key)) {
            return value;
        }
        return null;
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        V oldValue = this.delegate.put(key, value);
        if (oldValue != null && this.filter.test(key)) {
            return oldValue;
        }
        return null;
    }

    @Override
    @Nullable
    public V remove(Object key) {
        V oldValue = this.delegate.remove(key);
        if (oldValue != null && this.filter.test(key)) {
            return oldValue;
        }
        return null;
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public Set<K> keySet() {
        return new FilteredSet<K>(this.delegate.keySet(), this.filter);
    }
}

