/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.PlaceholderResolutionException;
import keycloakjar.org.springframework.util.PropertyPlaceholderHelper;
import keycloakjar.org.springframework.util.StringUtils;

final class PlaceholderParser {
    private static final Log logger = LogFactory.getLog(PlaceholderParser.class);
    private static final Map<String, String> wellKnownSimplePrefixes = Map.of("}", "{", "]", "[", ")", "(");
    private final String prefix;
    private final String suffix;
    private final String simplePrefix;
    @Nullable
    private final String separator;
    private final boolean ignoreUnresolvablePlaceholders;
    @Nullable
    private final Character escape;

    PlaceholderParser(String prefix, String suffix, @Nullable String separator, @Nullable Character escape, boolean ignoreUnresolvablePlaceholders) {
        this.prefix = prefix;
        this.suffix = suffix;
        String simplePrefixForSuffix = wellKnownSimplePrefixes.get(this.suffix);
        this.simplePrefix = simplePrefixForSuffix != null && this.prefix.endsWith(simplePrefixForSuffix) ? simplePrefixForSuffix : this.prefix;
        this.separator = separator;
        this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
        this.escape = escape;
    }

    public String replacePlaceholders(String value, PropertyPlaceholderHelper.PlaceholderResolver placeholderResolver) {
        List<Part> parts = this.parse(value, false);
        if (parts == null) {
            return value;
        }
        ParsedValue parsedValue = new ParsedValue(value, parts);
        PartResolutionContext resolutionContext = new PartResolutionContext(placeholderResolver, this.prefix, this.suffix, this.ignoreUnresolvablePlaceholders, candidate -> this.parse((String)candidate, false));
        return parsedValue.resolve(resolutionContext);
    }

    @Nullable
    private List<Part> parse(String value, boolean inPlaceholder) {
        int startIndex = this.nextStartPrefix(value, 0);
        if (startIndex == -1) {
            return null;
        }
        ArrayList<Part> parts = new ArrayList<Part>(4);
        int position = 0;
        while (startIndex != -1) {
            int endIndex = this.nextValidEndPrefix(value, startIndex);
            if (endIndex == -1) {
                PlaceholderParser.addText(value, position, startIndex + this.prefix.length(), parts);
                position = startIndex + this.prefix.length();
                startIndex = this.nextStartPrefix(value, position);
                continue;
            }
            if (this.isEscaped(value, startIndex)) {
                PlaceholderParser.addText(value, position, startIndex - 1, parts);
                PlaceholderParser.addText(value, startIndex, startIndex + this.prefix.length(), parts);
                position = startIndex + this.prefix.length();
                startIndex = this.nextStartPrefix(value, position);
                continue;
            }
            PlaceholderParser.addText(value, position, startIndex, parts);
            String placeholder = value.substring(startIndex + this.prefix.length(), endIndex);
            List<Part> placeholderParts = this.parse(placeholder, true);
            if (placeholderParts == null) {
                parts.add(this.createSimplePlaceholderPart(placeholder));
            } else {
                parts.addAll(placeholderParts);
            }
            startIndex = this.nextStartPrefix(value, endIndex + this.suffix.length());
            position = endIndex + this.suffix.length();
        }
        PlaceholderParser.addText(value, position, value.length(), parts);
        return inPlaceholder ? List.of(this.createNestedPlaceholderPart(value, parts)) : parts;
    }

    private SimplePlaceholderPart createSimplePlaceholderPart(String text) {
        ParsedSection section = this.parseSection(text);
        return new SimplePlaceholderPart(text, section.key(), section.fallback());
    }

    private NestedPlaceholderPart createNestedPlaceholderPart(String text, List<Part> parts) {
        if (this.separator == null) {
            return new NestedPlaceholderPart(text, parts, null);
        }
        ArrayList<Part> keyParts = new ArrayList<Part>();
        ArrayList<Part> defaultParts = new ArrayList<Part>();
        for (int i = 0; i < parts.size(); ++i) {
            Part part = parts.get(i);
            if (!(part instanceof TextPart)) {
                keyParts.add(part);
                continue;
            }
            String candidate = part.text();
            ParsedSection section = this.parseSection(candidate);
            keyParts.add(new TextPart(section.key()));
            if (section.fallback() == null) continue;
            defaultParts.add(new TextPart(section.fallback()));
            defaultParts.addAll(parts.subList(i + 1, parts.size()));
            return new NestedPlaceholderPart(text, keyParts, defaultParts);
        }
        return new NestedPlaceholderPart(text, keyParts, null);
    }

    private ParsedSection parseSection(String value) {
        if (this.separator == null || !value.contains(this.separator)) {
            return new ParsedSection(value, null);
        }
        int position = 0;
        int index = value.indexOf(this.separator, position);
        StringBuilder buffer = new StringBuilder();
        while (index != -1) {
            if (this.isEscaped(value, index)) {
                buffer.append(value, position, index - 1);
                buffer.append(value, index, index + this.separator.length());
                position = index + this.separator.length();
                index = value.indexOf(this.separator, position);
                continue;
            }
            buffer.append(value, position, index);
            String key = buffer.toString();
            String fallback = value.substring(index + this.separator.length());
            return new ParsedSection(key, fallback);
        }
        buffer.append(value, position, value.length());
        return new ParsedSection(buffer.toString(), null);
    }

    private int nextStartPrefix(String value, int index) {
        return value.indexOf(this.prefix, index);
    }

    private int nextValidEndPrefix(String value, int startIndex) {
        int index = startIndex + this.prefix.length();
        int withinNestedPlaceholder = 0;
        while (index < value.length()) {
            if (StringUtils.substringMatch(value, index, this.suffix)) {
                if (withinNestedPlaceholder > 0) {
                    --withinNestedPlaceholder;
                    index += this.suffix.length();
                    continue;
                }
                return index;
            }
            if (StringUtils.substringMatch(value, index, this.simplePrefix)) {
                ++withinNestedPlaceholder;
                index += this.simplePrefix.length();
                continue;
            }
            ++index;
        }
        return -1;
    }

    private boolean isEscaped(String value, int index) {
        return this.escape != null && index > 0 && value.charAt(index - 1) == this.escape.charValue();
    }

    private static void addText(String value, int start, int end, List<Part> parts) {
        Part part;
        if (start >= end) {
            return;
        }
        String text = value.substring(start, end);
        if (!parts.isEmpty() && (part = parts.get(parts.size() - 1)) instanceof TextPart) {
            TextPart textPart = (TextPart)part;
            parts.set(parts.size() - 1, new TextPart(textPart.text() + text));
        } else {
            parts.add(new TextPart(text));
        }
    }

    private record ParsedValue(String text, List<Part> parts) {
        public String resolve(PartResolutionContext resolutionContext) {
            try {
                return Part.resolveAll(this.parts, resolutionContext);
            }
            catch (PlaceholderResolutionException ex) {
                throw ex.withValue(this.text);
            }
        }
    }

    private static class PartResolutionContext
    implements PropertyPlaceholderHelper.PlaceholderResolver {
        private final String prefix;
        private final String suffix;
        private final boolean ignoreUnresolvablePlaceholders;
        private final Function<String, List<Part>> parser;
        private final PropertyPlaceholderHelper.PlaceholderResolver resolver;
        @Nullable
        private Set<String> visitedPlaceholders;

        PartResolutionContext(PropertyPlaceholderHelper.PlaceholderResolver resolver, String prefix, String suffix, boolean ignoreUnresolvablePlaceholders, Function<String, List<Part>> parser) {
            this.prefix = prefix;
            this.suffix = suffix;
            this.ignoreUnresolvablePlaceholders = ignoreUnresolvablePlaceholders;
            this.parser = parser;
            this.resolver = resolver;
        }

        @Override
        @Nullable
        public String resolvePlaceholder(String placeholderName) {
            String value = this.resolver.resolvePlaceholder(placeholderName);
            if (value != null && logger.isTraceEnabled()) {
                logger.trace("Resolved placeholder '" + placeholderName + "'");
            }
            return value;
        }

        public String handleUnresolvablePlaceholder(String key, String text) {
            if (this.ignoreUnresolvablePlaceholders) {
                return this.toPlaceholderText(key);
            }
            String originalValue = !key.equals(text) ? this.toPlaceholderText(text) : null;
            throw new PlaceholderResolutionException("Could not resolve placeholder '%s'".formatted(key), key, originalValue);
        }

        private String toPlaceholderText(String text) {
            return this.prefix + text + this.suffix;
        }

        @Nullable
        public List<Part> parse(String text) {
            return this.parser.apply(text);
        }

        public void flagPlaceholderAsVisited(String placeholder) {
            if (this.visitedPlaceholders == null) {
                this.visitedPlaceholders = new HashSet<String>(4);
            }
            if (!this.visitedPlaceholders.add(placeholder)) {
                throw new PlaceholderResolutionException("Circular placeholder reference '%s'".formatted(placeholder), placeholder, null);
            }
        }

        public void removePlaceholder(String placeholder) {
            if (this.visitedPlaceholders != null) {
                this.visitedPlaceholders.remove(placeholder);
            }
        }
    }

    private static class SimplePlaceholderPart
    extends AbstractPart {
        private final String key;
        @Nullable
        private final String fallback;

        public SimplePlaceholderPart(String text, String key, @Nullable String fallback) {
            super(text);
            this.key = key;
            this.fallback = fallback;
        }

        @Override
        public String resolve(PartResolutionContext resolutionContext) {
            String value = this.resolveRecursively(resolutionContext);
            if (value != null) {
                return value;
            }
            if (this.fallback != null) {
                return this.fallback;
            }
            return resolutionContext.handleUnresolvablePlaceholder(this.key, this.text);
        }

        @Nullable
        private String resolveRecursively(PartResolutionContext resolutionContext) {
            String value;
            if (!this.text.equals(this.key) && (value = this.resolveRecursively(resolutionContext, this.text)) != null) {
                return value;
            }
            return this.resolveRecursively(resolutionContext, this.key);
        }
    }

    private static class NestedPlaceholderPart
    extends AbstractPart {
        private final List<Part> keyParts;
        @Nullable
        private final List<Part> defaultParts;

        NestedPlaceholderPart(String text, List<Part> keyParts, @Nullable List<Part> defaultParts) {
            super(text);
            this.keyParts = keyParts;
            this.defaultParts = defaultParts;
        }

        @Override
        public String resolve(PartResolutionContext resolutionContext) {
            String resolvedKey = Part.resolveAll(this.keyParts, resolutionContext);
            String value = this.resolveRecursively(resolutionContext, resolvedKey);
            if (value != null) {
                return value;
            }
            if (this.defaultParts != null) {
                return Part.resolveAll(this.defaultParts, resolutionContext);
            }
            return resolutionContext.handleUnresolvablePlaceholder(resolvedKey, this.text);
        }
    }

    private record ParsedSection(String key, @Nullable String fallback) {
    }

    private static interface Part {
        public String resolve(PartResolutionContext var1);

        public String text();

        public static String resolveAll(Iterable<Part> parts, PartResolutionContext resolutionContext) {
            StringBuilder sb = new StringBuilder();
            for (Part part : parts) {
                sb.append(part.resolve(resolutionContext));
            }
            return sb.toString();
        }
    }

    private static class TextPart
    extends AbstractPart {
        public TextPart(String text) {
            super(text);
        }

        @Override
        public String resolve(PartResolutionContext resolutionContext) {
            return this.text;
        }
    }

    private static abstract class AbstractPart
    implements Part {
        final String text;

        protected AbstractPart(String text) {
            this.text = text;
        }

        @Override
        public String text() {
            return this.text;
        }

        @Nullable
        protected String resolveRecursively(PartResolutionContext resolutionContext, String key) {
            String resolvedValue = resolutionContext.resolvePlaceholder(key);
            if (resolvedValue == null) {
                return null;
            }
            List<Part> nestedParts = resolutionContext.parse(resolvedValue);
            if (nestedParts == null) {
                return resolvedValue;
            }
            resolutionContext.flagPlaceholderAsVisited(key);
            String value = new ParsedValue(resolvedValue, nestedParts).resolve(resolutionContext);
            resolutionContext.removePlaceholder(key);
            return value;
        }
    }
}

