/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.util.function;

import java.util.function.BiFunction;
import java.util.function.Consumer;

@FunctionalInterface
public interface ThrowingConsumer<T>
extends Consumer<T> {
    public void acceptWithException(T var1) throws Exception;

    @Override
    default public void accept(T t) {
        this.accept(t, RuntimeException::new);
    }

    default public void accept(T t, BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        try {
            this.acceptWithException(t);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw exceptionWrapper.apply(ex.getMessage(), ex);
        }
    }

    default public ThrowingConsumer<T> throwing(final BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        return new ThrowingConsumer<T>(){

            @Override
            public void acceptWithException(T t) throws Exception {
                ThrowingConsumer.this.acceptWithException(t);
            }

            @Override
            public void accept(T t) {
                this.accept(t, exceptionWrapper);
            }
        };
    }

    public static <T> ThrowingConsumer<T> of(ThrowingConsumer<T> consumer) {
        return consumer;
    }

    public static <T> ThrowingConsumer<T> of(ThrowingConsumer<T> consumer, BiFunction<String, Exception, RuntimeException> exceptionWrapper) {
        return consumer.throwing(exceptionWrapper);
    }
}

