/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web;

import java.net.URI;
import java.util.Locale;
import java.util.function.Consumer;
import keycloakjar.org.springframework.context.MessageSource;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.ProblemDetail;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.web.DefaultErrorResponseBuilder;

public interface ErrorResponse {
    public HttpStatusCode getStatusCode();

    default public HttpHeaders getHeaders() {
        return HttpHeaders.EMPTY;
    }

    public ProblemDetail getBody();

    default public String getTypeMessageCode() {
        return ErrorResponse.getDefaultTypeMessageCode(this.getClass());
    }

    default public String getTitleMessageCode() {
        return ErrorResponse.getDefaultTitleMessageCode(this.getClass());
    }

    default public String getDetailMessageCode() {
        return ErrorResponse.getDefaultDetailMessageCode(this.getClass(), null);
    }

    @Nullable
    default public Object[] getDetailMessageArguments() {
        return null;
    }

    @Nullable
    default public Object[] getDetailMessageArguments(MessageSource messageSource, Locale locale) {
        return this.getDetailMessageArguments();
    }

    default public ProblemDetail updateAndGetBody(@Nullable MessageSource messageSource, Locale locale) {
        if (messageSource != null) {
            String title;
            String type = messageSource.getMessage(this.getTypeMessageCode(), null, null, locale);
            if (type != null) {
                this.getBody().setType(URI.create(type));
            }
            Object[] arguments = this.getDetailMessageArguments(messageSource, locale);
            String detail = messageSource.getMessage(this.getDetailMessageCode(), arguments, null, locale);
            if (detail != null) {
                this.getBody().setDetail(detail);
            }
            if ((title = messageSource.getMessage(this.getTitleMessageCode(), null, null, locale)) != null) {
                this.getBody().setTitle(title);
            }
        }
        return this.getBody();
    }

    public static String getDefaultTypeMessageCode(Class<?> exceptionType) {
        return "problemDetail.type." + exceptionType.getName();
    }

    public static String getDefaultTitleMessageCode(Class<?> exceptionType) {
        return "problemDetail.title." + exceptionType.getName();
    }

    public static String getDefaultDetailMessageCode(Class<?> exceptionType, @Nullable String suffix) {
        return "problemDetail." + exceptionType.getName() + (String)(suffix != null ? "." + suffix : "");
    }

    public static ErrorResponse create(Throwable ex, HttpStatusCode statusCode, String detail) {
        return ErrorResponse.builder(ex, statusCode, detail).build();
    }

    public static Builder builder(Throwable ex, HttpStatusCode statusCode, String detail) {
        return ErrorResponse.builder(ex, ProblemDetail.forStatusAndDetail(statusCode, detail));
    }

    public static Builder builder(Throwable ex, ProblemDetail problemDetail) {
        return new DefaultErrorResponseBuilder(ex, problemDetail);
    }

    public static interface Builder {
        public Builder header(String var1, String ... var2);

        public Builder headers(Consumer<HttpHeaders> var1);

        public Builder type(URI var1);

        public Builder typeMessageCode(String var1);

        public Builder title(@Nullable String var1);

        public Builder titleMessageCode(String var1);

        public Builder instance(@Nullable URI var1);

        public Builder detail(String var1);

        public Builder detailMessageCode(String var1);

        public Builder detailMessageArguments(Object ... var1);

        public Builder property(String var1, @Nullable Object var2);

        public ErrorResponse build();

        default public ErrorResponse build(@Nullable MessageSource messageSource, Locale locale) {
            ErrorResponse response = this.build();
            response.updateAndGetBody(messageSource, locale);
            return response;
        }
    }

    public static interface Interceptor {
        public void handleError(ProblemDetail var1, @Nullable ErrorResponse var2);
    }
}

