/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web;

import java.util.Collections;
import java.util.List;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.web.ErrorResponse;
import keycloakjar.org.springframework.web.HttpMediaTypeException;

public class HttpMediaTypeNotAcceptableException
extends HttpMediaTypeException {
    private static final String PARSE_ERROR_DETAIL_CODE = ErrorResponse.getDefaultDetailMessageCode(HttpMediaTypeNotAcceptableException.class, "parseError");

    public HttpMediaTypeNotAcceptableException(String message) {
        super(message, Collections.emptyList(), PARSE_ERROR_DETAIL_CODE, null);
        this.getBody().setDetail("Could not parse Accept header.");
    }

    public HttpMediaTypeNotAcceptableException(List<MediaType> mediaTypes) {
        super("No acceptable representation", mediaTypes, null, new Object[]{mediaTypes});
        this.getBody().setDetail("Acceptable representations: " + String.valueOf(mediaTypes) + ".");
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatus.NOT_ACCEPTABLE;
    }

    @Override
    public HttpHeaders getHeaders() {
        if (CollectionUtils.isEmpty(this.getSupportedMediaTypes())) {
            return HttpHeaders.EMPTY;
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(this.getSupportedMediaTypes());
        return headers;
    }
}

