/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import keycloakjar.io.micrometer.observation.ObservationRegistry;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.client.ClientHttpRequestFactory;
import keycloakjar.org.springframework.http.client.ClientHttpRequestInitializer;
import keycloakjar.org.springframework.http.client.ClientHttpRequestInterceptor;
import keycloakjar.org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import keycloakjar.org.springframework.http.client.InterceptingClientHttpRequestFactory;
import keycloakjar.org.springframework.http.client.JdkClientHttpRequestFactory;
import keycloakjar.org.springframework.http.client.JettyClientHttpRequestFactory;
import keycloakjar.org.springframework.http.client.ReactorClientHttpRequestFactory;
import keycloakjar.org.springframework.http.client.SimpleClientHttpRequestFactory;
import keycloakjar.org.springframework.http.client.observation.ClientRequestObservationConvention;
import keycloakjar.org.springframework.http.converter.ByteArrayHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.HttpMessageConverter;
import keycloakjar.org.springframework.http.converter.ResourceHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.StringHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.cbor.KotlinSerializationCborHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.cbor.MappingJackson2CborHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.feed.AtomFeedHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.feed.RssChannelHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.json.GsonHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.json.JsonbHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.json.KotlinSerializationJsonHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import keycloakjar.org.springframework.http.converter.protobuf.KotlinSerializationProtobufHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.smile.MappingJackson2SmileHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.support.AllEncompassingFormHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.xml.MappingJackson2XmlHttpMessageConverter;
import keycloakjar.org.springframework.http.converter.yaml.MappingJackson2YamlHttpMessageConverter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ClassUtils;
import keycloakjar.org.springframework.util.CollectionUtils;
import keycloakjar.org.springframework.util.LinkedMultiValueMap;
import keycloakjar.org.springframework.util.MultiValueMap;
import keycloakjar.org.springframework.web.client.DefaultRestClient;
import keycloakjar.org.springframework.web.client.ResponseErrorHandler;
import keycloakjar.org.springframework.web.client.RestClient;
import keycloakjar.org.springframework.web.client.RestTemplate;
import keycloakjar.org.springframework.web.client.StatusHandler;
import keycloakjar.org.springframework.web.util.DefaultUriBuilderFactory;
import keycloakjar.org.springframework.web.util.UriBuilderFactory;
import keycloakjar.org.springframework.web.util.UriTemplateHandler;

final class DefaultRestClientBuilder
implements RestClient.Builder {
    private static final boolean httpComponentsClientPresent;
    private static final boolean jettyClientPresent;
    private static final boolean reactorNettyClientPresent;
    private static final boolean jdkClientPresent;
    private static final boolean romePresent;
    private static final boolean jaxb2Present;
    private static final boolean jackson2Present;
    private static final boolean jackson2XmlPresent;
    private static final boolean jackson2SmilePresent;
    private static final boolean jackson2CborPresent;
    private static final boolean jackson2YamlPresent;
    private static final boolean gsonPresent;
    private static final boolean jsonbPresent;
    private static final boolean kotlinSerializationCborPresent;
    private static final boolean kotlinSerializationJsonPresent;
    private static final boolean kotlinSerializationProtobufPresent;
    @Nullable
    private String baseUrl;
    @Nullable
    private Map<String, ?> defaultUriVariables;
    @Nullable
    private UriBuilderFactory uriBuilderFactory;
    @Nullable
    private HttpHeaders defaultHeaders;
    @Nullable
    private MultiValueMap<String, String> defaultCookies;
    @Nullable
    private Consumer<RestClient.RequestHeadersSpec<?>> defaultRequest;
    @Nullable
    private List<StatusHandler> statusHandlers;
    @Nullable
    private ClientHttpRequestFactory requestFactory;
    @Nullable
    private List<HttpMessageConverter<?>> messageConverters;
    @Nullable
    private List<ClientHttpRequestInterceptor> interceptors;
    @Nullable
    private List<ClientHttpRequestInitializer> initializers;
    private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
    @Nullable
    private ClientRequestObservationConvention observationConvention;

    public DefaultRestClientBuilder() {
    }

    public DefaultRestClientBuilder(DefaultRestClientBuilder other) {
        Assert.notNull((Object)other, "Other must not be null");
        this.baseUrl = other.baseUrl;
        this.defaultUriVariables = other.defaultUriVariables != null ? new LinkedHashMap(other.defaultUriVariables) : null;
        this.uriBuilderFactory = other.uriBuilderFactory;
        if (other.defaultHeaders != null) {
            this.defaultHeaders = new HttpHeaders();
            this.defaultHeaders.putAll(other.defaultHeaders);
        } else {
            this.defaultHeaders = null;
        }
        this.defaultCookies = other.defaultCookies != null ? new LinkedMultiValueMap(other.defaultCookies) : null;
        this.defaultRequest = other.defaultRequest;
        this.statusHandlers = other.statusHandlers != null ? new ArrayList<StatusHandler>(other.statusHandlers) : null;
        this.requestFactory = other.requestFactory;
        this.messageConverters = other.messageConverters != null ? new ArrayList(other.messageConverters) : null;
        this.interceptors = other.interceptors != null ? new ArrayList<ClientHttpRequestInterceptor>(other.interceptors) : null;
        this.initializers = other.initializers != null ? new ArrayList<ClientHttpRequestInitializer>(other.initializers) : null;
        this.observationRegistry = other.observationRegistry;
        this.observationConvention = other.observationConvention;
    }

    public DefaultRestClientBuilder(RestTemplate restTemplate) {
        Assert.notNull((Object)restTemplate, "RestTemplate must not be null");
        this.uriBuilderFactory = DefaultRestClientBuilder.getUriBuilderFactory(restTemplate);
        this.statusHandlers = new ArrayList<StatusHandler>();
        this.statusHandlers.add(StatusHandler.fromErrorHandler(restTemplate.getErrorHandler()));
        this.requestFactory = DefaultRestClientBuilder.getRequestFactory(restTemplate);
        this.messageConverters = new ArrayList(restTemplate.getMessageConverters());
        if (!CollectionUtils.isEmpty(restTemplate.getInterceptors())) {
            this.interceptors = new ArrayList<ClientHttpRequestInterceptor>(restTemplate.getInterceptors());
        }
        if (!CollectionUtils.isEmpty(restTemplate.getClientHttpRequestInitializers())) {
            this.initializers = new ArrayList<ClientHttpRequestInitializer>(restTemplate.getClientHttpRequestInitializers());
        }
        this.observationRegistry = restTemplate.getObservationRegistry();
        this.observationConvention = restTemplate.getObservationConvention();
    }

    @Nullable
    private static UriBuilderFactory getUriBuilderFactory(RestTemplate restTemplate) {
        UriTemplateHandler uriTemplateHandler = restTemplate.getUriTemplateHandler();
        if (uriTemplateHandler instanceof DefaultUriBuilderFactory) {
            DefaultUriBuilderFactory builderFactory = (DefaultUriBuilderFactory)uriTemplateHandler;
            if (DefaultRestClientBuilder.hasRestTemplateDefaults(builderFactory)) {
                return null;
            }
            return builderFactory;
        }
        if (uriTemplateHandler instanceof UriBuilderFactory) {
            UriBuilderFactory builderFactory = (UriBuilderFactory)uriTemplateHandler;
            return builderFactory;
        }
        return null;
    }

    private static boolean hasRestTemplateDefaults(DefaultUriBuilderFactory factory) {
        return !factory.hasBaseUri() && factory.getEncodingMode() == DefaultUriBuilderFactory.EncodingMode.URI_COMPONENT && CollectionUtils.isEmpty(factory.getDefaultUriVariables()) && factory.shouldParsePath();
    }

    private static ClientHttpRequestFactory getRequestFactory(RestTemplate restTemplate) {
        ClientHttpRequestFactory requestFactory = restTemplate.getRequestFactory();
        if (requestFactory instanceof InterceptingClientHttpRequestFactory) {
            InterceptingClientHttpRequestFactory interceptingClientHttpRequestFactory = (InterceptingClientHttpRequestFactory)requestFactory;
            return interceptingClientHttpRequestFactory.getDelegate();
        }
        return requestFactory;
    }

    @Override
    public RestClient.Builder baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public RestClient.Builder baseUrl(URI baseUrl) {
        this.baseUrl = baseUrl.toString();
        return this;
    }

    @Override
    public RestClient.Builder defaultUriVariables(Map<String, ?> defaultUriVariables) {
        this.defaultUriVariables = defaultUriVariables;
        return this;
    }

    @Override
    public RestClient.Builder uriBuilderFactory(UriBuilderFactory uriBuilderFactory) {
        this.uriBuilderFactory = uriBuilderFactory;
        return this;
    }

    @Override
    public RestClient.Builder defaultHeader(String header, String ... values) {
        this.initHeaders().put(header, Arrays.asList(values));
        return this;
    }

    @Override
    public RestClient.Builder defaultHeaders(Consumer<HttpHeaders> headersConsumer) {
        headersConsumer.accept(this.initHeaders());
        return this;
    }

    private HttpHeaders initHeaders() {
        if (this.defaultHeaders == null) {
            this.defaultHeaders = new HttpHeaders();
        }
        return this.defaultHeaders;
    }

    @Override
    public RestClient.Builder defaultCookie(String cookie, String ... values) {
        this.initCookies().addAll(cookie, Arrays.asList(values));
        return this;
    }

    @Override
    public RestClient.Builder defaultCookies(Consumer<MultiValueMap<String, String>> cookiesConsumer) {
        cookiesConsumer.accept(this.initCookies());
        return this;
    }

    private MultiValueMap<String, String> initCookies() {
        if (this.defaultCookies == null) {
            this.defaultCookies = new LinkedMultiValueMap<String, String>(3);
        }
        return this.defaultCookies;
    }

    @Override
    public RestClient.Builder defaultRequest(Consumer<RestClient.RequestHeadersSpec<?>> defaultRequest) {
        this.defaultRequest = this.defaultRequest != null ? this.defaultRequest.andThen(defaultRequest) : defaultRequest;
        return this;
    }

    @Override
    public RestClient.Builder defaultStatusHandler(Predicate<HttpStatusCode> statusPredicate, RestClient.ResponseSpec.ErrorHandler errorHandler) {
        return this.defaultStatusHandlerInternal(StatusHandler.of(statusPredicate, errorHandler));
    }

    @Override
    public RestClient.Builder defaultStatusHandler(ResponseErrorHandler errorHandler) {
        return this.defaultStatusHandlerInternal(StatusHandler.fromErrorHandler(errorHandler));
    }

    private RestClient.Builder defaultStatusHandlerInternal(StatusHandler statusHandler) {
        if (this.statusHandlers == null) {
            this.statusHandlers = new ArrayList<StatusHandler>();
        }
        this.statusHandlers.add(statusHandler);
        return this;
    }

    @Override
    public RestClient.Builder requestInterceptor(ClientHttpRequestInterceptor interceptor) {
        Assert.notNull((Object)interceptor, "Interceptor must not be null");
        this.initInterceptors().add(interceptor);
        return this;
    }

    @Override
    public RestClient.Builder requestInterceptors(Consumer<List<ClientHttpRequestInterceptor>> interceptorsConsumer) {
        interceptorsConsumer.accept(this.initInterceptors());
        return this;
    }

    private List<ClientHttpRequestInterceptor> initInterceptors() {
        if (this.interceptors == null) {
            this.interceptors = new ArrayList<ClientHttpRequestInterceptor>();
        }
        return this.interceptors;
    }

    @Override
    public RestClient.Builder requestInitializer(ClientHttpRequestInitializer initializer) {
        Assert.notNull((Object)initializer, "Initializer must not be null");
        this.initInitializers().add(initializer);
        return this;
    }

    @Override
    public RestClient.Builder requestInitializers(Consumer<List<ClientHttpRequestInitializer>> initializersConsumer) {
        initializersConsumer.accept(this.initInitializers());
        return this;
    }

    private List<ClientHttpRequestInitializer> initInitializers() {
        if (this.initializers == null) {
            this.initializers = new ArrayList<ClientHttpRequestInitializer>();
        }
        return this.initializers;
    }

    @Override
    public RestClient.Builder requestFactory(ClientHttpRequestFactory requestFactory) {
        this.requestFactory = requestFactory;
        return this;
    }

    @Override
    public RestClient.Builder messageConverters(Consumer<List<HttpMessageConverter<?>>> configurer) {
        configurer.accept(this.initMessageConverters());
        this.validateConverters(this.messageConverters);
        return this;
    }

    @Override
    public RestClient.Builder messageConverters(List<HttpMessageConverter<?>> messageConverters) {
        this.validateConverters(messageConverters);
        this.messageConverters = Collections.unmodifiableList(messageConverters);
        return this;
    }

    @Override
    public RestClient.Builder observationRegistry(ObservationRegistry observationRegistry) {
        Assert.notNull((Object)observationRegistry, "observationRegistry must not be null");
        this.observationRegistry = observationRegistry;
        return this;
    }

    @Override
    public RestClient.Builder observationConvention(ClientRequestObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
        return this;
    }

    @Override
    public RestClient.Builder apply(Consumer<RestClient.Builder> builderConsumer) {
        builderConsumer.accept(this);
        return this;
    }

    private List<HttpMessageConverter<?>> initMessageConverters() {
        if (this.messageConverters == null) {
            this.messageConverters = new ArrayList();
            this.messageConverters.add(new ByteArrayHttpMessageConverter());
            this.messageConverters.add(new StringHttpMessageConverter());
            this.messageConverters.add(new ResourceHttpMessageConverter(false));
            this.messageConverters.add(new AllEncompassingFormHttpMessageConverter());
            if (romePresent) {
                this.messageConverters.add(new AtomFeedHttpMessageConverter());
                this.messageConverters.add(new RssChannelHttpMessageConverter());
            }
            if (jackson2XmlPresent) {
                this.messageConverters.add(new MappingJackson2XmlHttpMessageConverter());
            } else if (jaxb2Present) {
                this.messageConverters.add(new Jaxb2RootElementHttpMessageConverter());
            }
            if (kotlinSerializationProtobufPresent) {
                this.messageConverters.add(new KotlinSerializationProtobufHttpMessageConverter());
            }
            if (kotlinSerializationJsonPresent) {
                this.messageConverters.add(new KotlinSerializationJsonHttpMessageConverter());
            }
            if (jackson2Present) {
                this.messageConverters.add(new MappingJackson2HttpMessageConverter());
            } else if (gsonPresent) {
                this.messageConverters.add(new GsonHttpMessageConverter());
            } else if (jsonbPresent) {
                this.messageConverters.add(new JsonbHttpMessageConverter());
            }
            if (jackson2SmilePresent) {
                this.messageConverters.add(new MappingJackson2SmileHttpMessageConverter());
            }
            if (jackson2CborPresent) {
                this.messageConverters.add(new MappingJackson2CborHttpMessageConverter());
            } else if (kotlinSerializationCborPresent) {
                this.messageConverters.add(new KotlinSerializationCborHttpMessageConverter());
            }
            if (jackson2YamlPresent) {
                this.messageConverters.add(new MappingJackson2YamlHttpMessageConverter());
            }
        }
        return this.messageConverters;
    }

    private void validateConverters(@Nullable List<HttpMessageConverter<?>> messageConverters) {
        Assert.notEmpty(messageConverters, "At least one HttpMessageConverter is required");
        Assert.noNullElements(messageConverters, "The HttpMessageConverter list must not contain null elements");
    }

    @Override
    public RestClient.Builder clone() {
        return new DefaultRestClientBuilder(this);
    }

    @Override
    public RestClient build() {
        ClientHttpRequestFactory requestFactory = this.initRequestFactory();
        UriBuilderFactory uriBuilderFactory = this.initUriBuilderFactory();
        HttpHeaders defaultHeaders = this.copyDefaultHeaders();
        MultiValueMap<String, String> defaultCookies = this.copyDefaultCookies();
        List<HttpMessageConverter<?>> converters = this.messageConverters != null ? this.messageConverters : this.initMessageConverters();
        return new DefaultRestClient(requestFactory, this.interceptors, this.initializers, uriBuilderFactory, defaultHeaders, defaultCookies, this.defaultRequest, this.statusHandlers, converters, this.observationRegistry, this.observationConvention, new DefaultRestClientBuilder(this));
    }

    private ClientHttpRequestFactory initRequestFactory() {
        if (this.requestFactory != null) {
            return this.requestFactory;
        }
        if (httpComponentsClientPresent) {
            return new HttpComponentsClientHttpRequestFactory();
        }
        if (jettyClientPresent) {
            return new JettyClientHttpRequestFactory();
        }
        if (reactorNettyClientPresent) {
            return new ReactorClientHttpRequestFactory();
        }
        if (jdkClientPresent) {
            return new JdkClientHttpRequestFactory();
        }
        return new SimpleClientHttpRequestFactory();
    }

    private UriBuilderFactory initUriBuilderFactory() {
        if (this.uriBuilderFactory != null) {
            return this.uriBuilderFactory;
        }
        DefaultUriBuilderFactory factory = this.baseUrl != null ? new DefaultUriBuilderFactory(this.baseUrl) : new DefaultUriBuilderFactory();
        factory.setDefaultUriVariables(this.defaultUriVariables);
        return factory;
    }

    @Nullable
    private HttpHeaders copyDefaultHeaders() {
        if (this.defaultHeaders == null) {
            return null;
        }
        HttpHeaders copy = new HttpHeaders();
        this.defaultHeaders.forEach((BiConsumer<? super String, ? super List<String>>)((BiConsumer<String, List>)(key, values) -> copy.put((String)key, (List<String>)new ArrayList<String>((Collection<String>)values))));
        return HttpHeaders.readOnlyHttpHeaders(copy);
    }

    @Nullable
    private MultiValueMap<String, String> copyDefaultCookies() {
        if (this.defaultCookies == null) {
            return null;
        }
        LinkedMultiValueMap copy = new LinkedMultiValueMap(this.defaultCookies.size());
        this.defaultCookies.forEach((key, values) -> copy.put(key, new ArrayList(values)));
        return CollectionUtils.unmodifiableMultiValueMap(copy);
    }

    static {
        ClassLoader loader = DefaultRestClientBuilder.class.getClassLoader();
        httpComponentsClientPresent = ClassUtils.isPresent("keycloakjar.org.apache.hc.client5.http.classic.HttpClient", loader);
        jettyClientPresent = ClassUtils.isPresent("org.eclipse.jetty.client.HttpClient", loader);
        reactorNettyClientPresent = ClassUtils.isPresent("reactor.netty.http.client.HttpClient", loader);
        jdkClientPresent = ClassUtils.isPresent("java.net.http.HttpClient", loader);
        romePresent = ClassUtils.isPresent("com.rometools.rome.feed.WireFeed", loader);
        jaxb2Present = ClassUtils.isPresent("jakarta.xml.bind.Binder", loader);
        jackson2Present = ClassUtils.isPresent("com.fasterxml.jackson.databind.ObjectMapper", loader) && ClassUtils.isPresent("com.fasterxml.jackson.core.JsonGenerator", loader);
        jackson2XmlPresent = ClassUtils.isPresent("com.fasterxml.jackson.dataformat.xml.XmlMapper", loader);
        jackson2SmilePresent = ClassUtils.isPresent("com.fasterxml.jackson.dataformat.smile.SmileFactory", loader);
        jackson2CborPresent = ClassUtils.isPresent("com.fasterxml.jackson.dataformat.cbor.CBORFactory", loader);
        jackson2YamlPresent = ClassUtils.isPresent("com.fasterxml.jackson.dataformat.yaml.YAMLFactory", loader);
        gsonPresent = ClassUtils.isPresent("keycloakjar.com.google.gson.Gson", loader);
        jsonbPresent = ClassUtils.isPresent("jakarta.json.bind.Jsonb", loader);
        kotlinSerializationCborPresent = ClassUtils.isPresent("kotlinx.serialization.cbor.Cbor", loader);
        kotlinSerializationJsonPresent = ClassUtils.isPresent("kotlinx.serialization.json.Json", loader);
        kotlinSerializationProtobufPresent = ClassUtils.isPresent("kotlinx.serialization.protobuf.ProtoBuf", loader);
    }
}

