/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.context.request;

import jakarta.faces.context.ExternalContext;
import jakarta.faces.context.FacesContext;
import java.lang.reflect.Method;
import java.util.Map;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ReflectionUtils;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.context.request.RequestAttributes;
import keycloakjar.org.springframework.web.util.WebUtils;

public class FacesRequestAttributes
implements RequestAttributes {
    private static final Log logger = LogFactory.getLog(FacesRequestAttributes.class);
    private final FacesContext facesContext;

    public FacesRequestAttributes(FacesContext facesContext) {
        Assert.notNull((Object)facesContext, "FacesContext must not be null");
        this.facesContext = facesContext;
    }

    protected final FacesContext getFacesContext() {
        return this.facesContext;
    }

    protected final ExternalContext getExternalContext() {
        return this.getFacesContext().getExternalContext();
    }

    protected Map<String, Object> getAttributeMap(int scope) {
        if (scope == 0) {
            return this.getExternalContext().getRequestMap();
        }
        return this.getExternalContext().getSessionMap();
    }

    @Override
    @Nullable
    public Object getAttribute(String name, int scope) {
        return this.getAttributeMap(scope).get(name);
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        this.getAttributeMap(scope).put(name, value);
    }

    @Override
    public void removeAttribute(String name, int scope) {
        this.getAttributeMap(scope).remove(name);
    }

    @Override
    public String[] getAttributeNames(int scope) {
        return StringUtils.toStringArray(this.getAttributeMap(scope).keySet());
    }

    @Override
    public void registerDestructionCallback(String name, Runnable callback, int scope) {
        if (logger.isWarnEnabled()) {
            logger.warn("Could not register destruction callback [" + String.valueOf(callback) + "] for attribute '" + name + "' because FacesRequestAttributes does not support such callbacks");
        }
    }

    @Override
    @Nullable
    public Object resolveReference(String key) {
        return switch (key) {
            case "request" -> this.getExternalContext().getRequest();
            case "session" -> this.getExternalContext().getSession(true);
            case "application" -> this.getExternalContext().getContext();
            case "requestScope" -> this.getExternalContext().getRequestMap();
            case "sessionScope" -> this.getExternalContext().getSessionMap();
            case "applicationScope" -> this.getExternalContext().getApplicationMap();
            case "facesContext" -> this.getFacesContext();
            case "cookie" -> this.getExternalContext().getRequestCookieMap();
            case "header" -> this.getExternalContext().getRequestHeaderMap();
            case "headerValues" -> this.getExternalContext().getRequestHeaderValuesMap();
            case "param" -> this.getExternalContext().getRequestParameterMap();
            case "paramValues" -> this.getExternalContext().getRequestParameterValuesMap();
            case "initParam" -> this.getExternalContext().getInitParameterMap();
            case "view" -> this.getFacesContext().getViewRoot();
            case "viewScope" -> this.getFacesContext().getViewRoot().getViewMap();
            case "flash" -> this.getExternalContext().getFlash();
            case "resource" -> this.getFacesContext().getApplication().getResourceHandler();
            default -> null;
        };
    }

    @Override
    public String getSessionId() {
        Object session = this.getExternalContext().getSession(true);
        try {
            Method getIdMethod = session.getClass().getMethod("getId", new Class[0]);
            return String.valueOf(ReflectionUtils.invokeMethod(getIdMethod, session));
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Session object [" + String.valueOf(session) + "] does not have a getId() method");
        }
    }

    @Override
    public Object getSessionMutex() {
        ExternalContext externalContext = this.getExternalContext();
        Object session = externalContext.getSession(true);
        Object mutex = externalContext.getSessionMap().get(WebUtils.SESSION_MUTEX_ATTRIBUTE);
        if (mutex == null) {
            mutex = session != null ? session : externalContext;
        }
        return mutex;
    }
}

