/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.context.request.async;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.web.context.request.ServletWebRequest;
import keycloakjar.org.springframework.web.context.request.async.AsyncRequestNotUsableException;
import keycloakjar.org.springframework.web.context.request.async.AsyncWebRequest;

public class StandardServletAsyncWebRequest
extends ServletWebRequest
implements AsyncWebRequest,
AsyncListener {
    private final List<Runnable> timeoutHandlers = new ArrayList<Runnable>();
    private final List<Consumer<Throwable>> exceptionHandlers = new ArrayList<Consumer<Throwable>>();
    private final List<Runnable> completionHandlers = new ArrayList<Runnable>();
    @Nullable
    private Long timeout;
    @Nullable
    private AsyncContext asyncContext;
    private State state;
    private final ReentrantLock stateLock = new ReentrantLock();

    public StandardServletAsyncWebRequest(HttpServletRequest request, HttpServletResponse response) {
        this(request, response, null);
    }

    StandardServletAsyncWebRequest(HttpServletRequest request, HttpServletResponse response, @Nullable StandardServletAsyncWebRequest previousRequest) {
        super(request, (HttpServletResponse)new LifecycleHttpServletResponse(response));
        this.state = previousRequest != null ? previousRequest.state : State.NEW;
        ((LifecycleHttpServletResponse)this.getResponse()).setAsyncWebRequest(this);
    }

    @Override
    public void setTimeout(@Nullable Long timeout) {
        Assert.state(!this.isAsyncStarted(), "Cannot change the timeout with concurrent handling in progress");
        this.timeout = timeout;
    }

    @Override
    public void addTimeoutHandler(Runnable timeoutHandler) {
        this.timeoutHandlers.add(timeoutHandler);
    }

    @Override
    public void addErrorHandler(Consumer<Throwable> exceptionHandler) {
        this.exceptionHandlers.add(exceptionHandler);
    }

    @Override
    public void addCompletionHandler(Runnable runnable) {
        this.completionHandlers.add(runnable);
    }

    @Override
    public boolean isAsyncStarted() {
        return this.asyncContext != null && this.getRequest().isAsyncStarted();
    }

    @Override
    public boolean isAsyncComplete() {
        return this.state == State.COMPLETED;
    }

    @Override
    public void startAsync() {
        Assert.state(this.getRequest().isAsyncSupported(), "Async support must be enabled on a servlet and for all filters involved in async request processing. This is done in Java code using the Servlet API or by adding \"<async-supported>true</async-supported>\" to servlet and filter declarations in web.xml.");
        if (this.isAsyncStarted()) {
            return;
        }
        if (this.state == State.NEW) {
            this.state = State.ASYNC;
        } else {
            Assert.state(this.state == State.ASYNC, "Cannot start async: [" + String.valueOf((Object)this.state) + "]");
        }
        this.asyncContext = this.getRequest().startAsync((ServletRequest)this.getRequest(), (ServletResponse)this.getResponse());
        this.asyncContext.addListener((AsyncListener)this);
        if (this.timeout != null) {
            this.asyncContext.setTimeout(this.timeout.longValue());
        }
    }

    @Override
    public void dispatch() {
        Assert.state(this.asyncContext != null, "AsyncContext not yet initialized");
        if (!this.isAsyncComplete()) {
            this.asyncContext.dispatch();
        }
    }

    public void onStartAsync(AsyncEvent event) throws IOException {
    }

    public void onTimeout(AsyncEvent event) throws IOException {
        this.timeoutHandlers.forEach(Runnable::run);
    }

    public void onError(AsyncEvent event) throws IOException {
        this.stateLock.lock();
        try {
            this.state = State.ERROR;
            Throwable ex = event.getThrowable();
            this.exceptionHandlers.forEach(consumer -> consumer.accept(ex));
        }
        finally {
            this.stateLock.unlock();
        }
    }

    public void onComplete(AsyncEvent event) throws IOException {
        this.stateLock.lock();
        try {
            this.completionHandlers.forEach(Runnable::run);
            this.asyncContext = null;
            this.state = State.COMPLETED;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    private int tryObtainLock() {
        if (this.state == State.NEW) {
            return 0;
        }
        while (this.state == State.ASYNC) {
            try {
                if (!this.stateLock.tryLock(500L, TimeUnit.MILLISECONDS)) continue;
                if (this.state == State.ASYNC) {
                    return 1;
                }
                this.stateLock.unlock();
                break;
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return -1;
    }

    ReentrantLock stateLock() {
        return this.stateLock;
    }

    private static final class LifecycleHttpServletResponse
    extends HttpServletResponseWrapper {
        @Nullable
        private StandardServletAsyncWebRequest asyncWebRequest;
        @Nullable
        private ServletOutputStream outputStream;
        @Nullable
        private PrintWriter writer;

        public LifecycleHttpServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void setAsyncWebRequest(StandardServletAsyncWebRequest asyncWebRequest) {
            this.asyncWebRequest = asyncWebRequest;
        }

        public ServletOutputStream getOutputStream() throws IOException {
            int level = this.obtainLockOrRaiseException();
            try {
                if (this.outputStream == null) {
                    Assert.notNull((Object)this.asyncWebRequest, "Not initialized");
                    ServletOutputStream delegate = this.getResponse().getOutputStream();
                    this.outputStream = new LifecycleServletOutputStream(delegate, this);
                }
            }
            catch (IOException ex) {
                this.handleIOException(ex, "Failed to get ServletResponseOutput");
            }
            finally {
                this.releaseLock(level);
            }
            return this.outputStream;
        }

        public PrintWriter getWriter() throws IOException {
            int level = this.obtainLockOrRaiseException();
            try {
                if (this.writer == null) {
                    Assert.notNull((Object)this.asyncWebRequest, "Not initialized");
                    this.writer = new LifecyclePrintWriter(this.getResponse().getWriter(), this.asyncWebRequest);
                }
            }
            catch (IOException ex) {
                this.handleIOException(ex, "Failed to get PrintWriter");
            }
            finally {
                this.releaseLock(level);
            }
            return this.writer;
        }

        public void flushBuffer() throws IOException {
            int level = this.obtainLockOrRaiseException();
            try {
                this.getResponse().flushBuffer();
            }
            catch (IOException ex) {
                this.handleIOException(ex, "ServletResponse failed to flushBuffer");
            }
            finally {
                this.releaseLock(level);
            }
        }

        private int obtainLockOrRaiseException() throws AsyncRequestNotUsableException {
            Assert.notNull((Object)this.asyncWebRequest, "Not initialized");
            int result = this.asyncWebRequest.tryObtainLock();
            if (result == -1) {
                throw new AsyncRequestNotUsableException("Response not usable after " + (this.asyncWebRequest.state == State.COMPLETED ? "async request completion" : "response errors") + ".");
            }
            return result;
        }

        void handleIOException(IOException ex, String msg) throws AsyncRequestNotUsableException {
            Assert.notNull((Object)this.asyncWebRequest, "Not initialized");
            this.asyncWebRequest.state = State.ERROR;
            throw new AsyncRequestNotUsableException(msg + ": " + ex.getMessage(), ex);
        }

        void releaseLock(int level) {
            Assert.notNull((Object)this.asyncWebRequest, "Not initialized");
            if (level > 0) {
                this.asyncWebRequest.stateLock.unlock();
            }
        }
    }

    private static enum State {
        NEW,
        ASYNC,
        ERROR,
        COMPLETED;

    }

    private static final class LifecyclePrintWriter
    extends PrintWriter {
        private final PrintWriter delegate;
        private final StandardServletAsyncWebRequest asyncWebRequest;

        private LifecyclePrintWriter(PrintWriter delegate, StandardServletAsyncWebRequest asyncWebRequest) {
            super(delegate);
            this.delegate = delegate;
            this.asyncWebRequest = asyncWebRequest;
        }

        @Override
        public void flush() {
            int level = this.asyncWebRequest.tryObtainLock();
            if (level > -1) {
                try {
                    this.delegate.flush();
                }
                finally {
                    this.releaseLock(level);
                }
            }
        }

        @Override
        public void close() {
            int level = this.asyncWebRequest.tryObtainLock();
            if (level > -1) {
                try {
                    this.delegate.close();
                }
                finally {
                    this.releaseLock(level);
                }
            }
        }

        @Override
        public boolean checkError() {
            return this.delegate.checkError();
        }

        @Override
        public void write(int c) {
            int level = this.asyncWebRequest.tryObtainLock();
            if (level > -1) {
                try {
                    this.delegate.write(c);
                }
                finally {
                    this.releaseLock(level);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] buf, int off, int len) {
            int level = this.asyncWebRequest.tryObtainLock();
            if (level > -1) {
                try {
                    this.delegate.write(buf, off, len);
                }
                finally {
                    this.releaseLock(level);
                }
            }
        }

        @Override
        public void write(char[] buf) {
            this.delegate.write(buf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(String s, int off, int len) {
            int level = this.asyncWebRequest.tryObtainLock();
            if (level > -1) {
                try {
                    this.delegate.write(s, off, len);
                }
                finally {
                    this.releaseLock(level);
                }
            }
        }

        @Override
        public void write(String s) {
            this.delegate.write(s);
        }

        private void releaseLock(int level) {
            if (level > 0) {
                this.asyncWebRequest.stateLock.unlock();
            }
        }

        @Override
        public void print(boolean b) {
            this.delegate.print(b);
        }

        @Override
        public void print(char c) {
            this.delegate.print(c);
        }

        @Override
        public void print(int i) {
            this.delegate.print(i);
        }

        @Override
        public void print(long l) {
            this.delegate.print(l);
        }

        @Override
        public void print(float f) {
            this.delegate.print(f);
        }

        @Override
        public void print(double d) {
            this.delegate.print(d);
        }

        @Override
        public void print(char[] s) {
            this.delegate.print(s);
        }

        @Override
        public void print(String s) {
            this.delegate.print(s);
        }

        @Override
        public void print(Object obj) {
            this.delegate.print(obj);
        }

        @Override
        public void println() {
            this.delegate.println();
        }

        @Override
        public void println(boolean x) {
            this.delegate.println(x);
        }

        @Override
        public void println(char x) {
            this.delegate.println(x);
        }

        @Override
        public void println(int x) {
            this.delegate.println(x);
        }

        @Override
        public void println(long x) {
            this.delegate.println(x);
        }

        @Override
        public void println(float x) {
            this.delegate.println(x);
        }

        @Override
        public void println(double x) {
            this.delegate.println(x);
        }

        @Override
        public void println(char[] x) {
            this.delegate.println(x);
        }

        @Override
        public void println(String x) {
            this.delegate.println(x);
        }

        @Override
        public void println(Object x) {
            this.delegate.println(x);
        }

        @Override
        public PrintWriter printf(String format, Object ... args) {
            return this.delegate.printf(format, args);
        }

        @Override
        public PrintWriter printf(Locale l, String format, Object ... args) {
            return this.delegate.printf(l, format, args);
        }

        @Override
        public PrintWriter format(String format, Object ... args) {
            return this.delegate.format(format, args);
        }

        @Override
        public PrintWriter format(Locale l, String format, Object ... args) {
            return this.delegate.format(l, format, args);
        }

        @Override
        public PrintWriter append(CharSequence csq) {
            return this.delegate.append(csq);
        }

        @Override
        public PrintWriter append(CharSequence csq, int start, int end) {
            return this.delegate.append(csq, start, end);
        }

        @Override
        public PrintWriter append(char c) {
            return this.delegate.append(c);
        }
    }

    private static final class LifecycleServletOutputStream
    extends ServletOutputStream {
        private final ServletOutputStream delegate;
        private final LifecycleHttpServletResponse response;

        private LifecycleServletOutputStream(ServletOutputStream delegate, LifecycleHttpServletResponse response) {
            this.delegate = delegate;
            this.response = response;
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }

        public void setWriteListener(WriteListener writeListener) {
            this.delegate.setWriteListener(writeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            int level = this.response.obtainLockOrRaiseException();
            try {
                this.delegate.write(b);
            }
            catch (IOException ex) {
                this.response.handleIOException(ex, "ServletOutputStream failed to write");
            }
            finally {
                this.response.releaseLock(level);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] buf, int offset, int len) throws IOException {
            int level = this.response.obtainLockOrRaiseException();
            try {
                this.delegate.write(buf, offset, len);
            }
            catch (IOException ex) {
                this.response.handleIOException(ex, "ServletOutputStream failed to write");
            }
            finally {
                this.response.releaseLock(level);
            }
        }

        public void flush() throws IOException {
            int level = this.response.obtainLockOrRaiseException();
            try {
                this.delegate.flush();
            }
            catch (IOException ex) {
                this.response.handleIOException(ex, "ServletOutputStream failed to flush");
            }
            finally {
                this.response.releaseLock(level);
            }
        }

        public void close() throws IOException {
            int level = this.response.obtainLockOrRaiseException();
            try {
                this.delegate.close();
            }
            catch (IOException ex) {
                this.response.handleIOException(ex, "ServletOutputStream failed to close");
            }
            finally {
                this.response.releaseLock(level);
            }
        }
    }
}

