/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.method.annotation;

import java.util.Map;
import keycloakjar.org.springframework.beans.factory.config.ConfigurableBeanFactory;
import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.web.bind.MissingRequestHeaderException;
import keycloakjar.org.springframework.web.bind.ServletRequestBindingException;
import keycloakjar.org.springframework.web.bind.annotation.RequestHeader;
import keycloakjar.org.springframework.web.context.request.NativeWebRequest;
import keycloakjar.org.springframework.web.method.annotation.AbstractNamedValueMethodArgumentResolver;

public class RequestHeaderMethodArgumentResolver
extends AbstractNamedValueMethodArgumentResolver {
    public RequestHeaderMethodArgumentResolver(@Nullable ConfigurableBeanFactory beanFactory) {
        super(beanFactory);
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestHeader.class) && !Map.class.isAssignableFrom(parameter.nestedIfOptional().getNestedParameterType());
    }

    @Override
    protected AbstractNamedValueMethodArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        RequestHeader ann = parameter.getParameterAnnotation(RequestHeader.class);
        Assert.state(ann != null, "No RequestHeader annotation");
        return new RequestHeaderNamedValueInfo(ann);
    }

    @Override
    @Nullable
    protected Object resolveName(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        String[] headerValues = request.getHeaderValues(name);
        if (headerValues != null) {
            return headerValues.length == 1 ? headerValues[0] : headerValues;
        }
        return null;
    }

    @Override
    protected void handleMissingValue(String name, MethodParameter parameter) throws ServletRequestBindingException {
        throw new MissingRequestHeaderException(name, parameter);
    }

    @Override
    protected void handleMissingValueAfterConversion(String name, MethodParameter parameter, NativeWebRequest request) throws Exception {
        throw new MissingRequestHeaderException(name, parameter, true);
    }

    private static final class RequestHeaderNamedValueInfo
    extends AbstractNamedValueMethodArgumentResolver.NamedValueInfo {
        private RequestHeaderNamedValueInfo(RequestHeader annotation) {
            super(annotation.name(), annotation.required(), annotation.defaultValue());
        }
    }
}

