/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.server.adapter;

import java.util.concurrent.atomic.AtomicBoolean;
import keycloakjar.io.micrometer.observation.Observation;
import keycloakjar.io.micrometer.observation.ObservationRegistry;
import keycloakjar.org.apache.commons.logging.Log;
import keycloakjar.org.apache.commons.logging.LogFactory;
import keycloakjar.org.springframework.context.ApplicationContext;
import keycloakjar.org.springframework.core.log.LogFormatUtils;
import keycloakjar.org.springframework.http.HttpHeaders;
import keycloakjar.org.springframework.http.HttpStatus;
import keycloakjar.org.springframework.http.HttpStatusCode;
import keycloakjar.org.springframework.http.codec.LoggingCodecSupport;
import keycloakjar.org.springframework.http.codec.ServerCodecConfigurer;
import keycloakjar.org.springframework.http.server.reactive.HttpHandler;
import keycloakjar.org.springframework.http.server.reactive.ServerHttpRequest;
import keycloakjar.org.springframework.http.server.reactive.ServerHttpResponse;
import keycloakjar.org.springframework.http.server.reactive.observation.DefaultServerRequestObservationConvention;
import keycloakjar.org.springframework.http.server.reactive.observation.ServerHttpObservationDocumentation;
import keycloakjar.org.springframework.http.server.reactive.observation.ServerRequestObservationContext;
import keycloakjar.org.springframework.http.server.reactive.observation.ServerRequestObservationConvention;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.StringUtils;
import keycloakjar.org.springframework.web.server.ServerWebExchange;
import keycloakjar.org.springframework.web.server.WebHandler;
import keycloakjar.org.springframework.web.server.adapter.DefaultServerWebExchange;
import keycloakjar.org.springframework.web.server.adapter.ForwardedHeaderTransformer;
import keycloakjar.org.springframework.web.server.handler.ExceptionHandlingWebHandler;
import keycloakjar.org.springframework.web.server.handler.WebHandlerDecorator;
import keycloakjar.org.springframework.web.server.i18n.AcceptHeaderLocaleContextResolver;
import keycloakjar.org.springframework.web.server.i18n.LocaleContextResolver;
import keycloakjar.org.springframework.web.server.session.DefaultWebSessionManager;
import keycloakjar.org.springframework.web.server.session.WebSessionManager;
import keycloakjar.org.springframework.web.util.DisconnectedClientHelper;
import reactor.core.observability.DefaultSignalListener;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class HttpWebHandlerAdapter
extends WebHandlerDecorator
implements HttpHandler {
    private static final String DISCONNECTED_CLIENT_LOG_CATEGORY = "keycloakjar.org.springframework.web.server.DisconnectedClient";
    private static final DisconnectedClientHelper disconnectedClientHelper = new DisconnectedClientHelper("keycloakjar.org.springframework.web.server.DisconnectedClient");
    private static final ServerRequestObservationConvention DEFAULT_OBSERVATION_CONVENTION = new DefaultServerRequestObservationConvention();
    private static final Log logger = LogFactory.getLog(HttpWebHandlerAdapter.class);
    private WebSessionManager sessionManager = new DefaultWebSessionManager();
    @Nullable
    private ServerCodecConfigurer codecConfigurer;
    private LocaleContextResolver localeContextResolver = new AcceptHeaderLocaleContextResolver();
    @Nullable
    private ForwardedHeaderTransformer forwardedHeaderTransformer;
    private ObservationRegistry observationRegistry = ObservationRegistry.NOOP;
    private ServerRequestObservationConvention observationConvention = DEFAULT_OBSERVATION_CONVENTION;
    @Nullable
    private ApplicationContext applicationContext;
    private boolean enableLoggingRequestDetails = false;

    public HttpWebHandlerAdapter(WebHandler delegate) {
        super(delegate);
    }

    public void setSessionManager(WebSessionManager sessionManager) {
        Assert.notNull((Object)sessionManager, "WebSessionManager must not be null");
        this.sessionManager = sessionManager;
    }

    public WebSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setCodecConfigurer(ServerCodecConfigurer codecConfigurer) {
        Assert.notNull((Object)codecConfigurer, "ServerCodecConfigurer is required");
        this.codecConfigurer = codecConfigurer;
        this.enableLoggingRequestDetails = false;
        this.codecConfigurer.getReaders().stream().filter(LoggingCodecSupport.class::isInstance).forEach(reader -> {
            if (((LoggingCodecSupport)((Object)reader)).isEnableLoggingRequestDetails()) {
                this.enableLoggingRequestDetails = true;
            }
        });
    }

    public ServerCodecConfigurer getCodecConfigurer() {
        if (this.codecConfigurer == null) {
            this.setCodecConfigurer(ServerCodecConfigurer.create());
        }
        return this.codecConfigurer;
    }

    public void setLocaleContextResolver(LocaleContextResolver resolver) {
        Assert.notNull((Object)resolver, "LocaleContextResolver is required");
        this.localeContextResolver = resolver;
    }

    public LocaleContextResolver getLocaleContextResolver() {
        return this.localeContextResolver;
    }

    public void setForwardedHeaderTransformer(@Nullable ForwardedHeaderTransformer transformer) {
        this.forwardedHeaderTransformer = transformer;
    }

    @Nullable
    public ForwardedHeaderTransformer getForwardedHeaderTransformer() {
        return this.forwardedHeaderTransformer;
    }

    public void setObservationRegistry(ObservationRegistry observationRegistry) {
        this.observationRegistry = observationRegistry;
    }

    public ObservationRegistry getObservationRegistry() {
        return this.observationRegistry;
    }

    public void setObservationConvention(ServerRequestObservationConvention observationConvention) {
        this.observationConvention = observationConvention;
    }

    public ServerRequestObservationConvention getObservationConvention() {
        return this.observationConvention;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    @Nullable
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void afterPropertiesSet() {
        if (logger.isDebugEnabled()) {
            String value = this.enableLoggingRequestDetails ? "shown which may lead to unsafe logging of potentially sensitive data" : "masked to prevent unsafe logging of potentially sensitive data";
            logger.debug("enableLoggingRequestDetails='" + this.enableLoggingRequestDetails + "': form data and headers will be " + value);
        }
    }

    @Override
    public Mono<Void> handle(ServerHttpRequest request, ServerHttpResponse response) {
        if (this.forwardedHeaderTransformer != null) {
            try {
                request = this.forwardedHeaderTransformer.apply(request);
            }
            catch (Throwable ex2) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Failed to apply forwarded headers to " + this.formatRequest(request), ex2);
                }
                response.setStatusCode(HttpStatus.BAD_REQUEST);
                return response.setComplete();
            }
        }
        ServerWebExchange exchange2 = this.createExchange(request, response);
        LogFormatUtils.traceDebug(logger, traceOn -> exchange2.getLogPrefix() + this.formatRequest(exchange2.getRequest()) + (String)(traceOn != false ? ", headers=" + this.formatHeaders(exchange2.getRequest().getHeaders()) : ""));
        ServerRequestObservationContext observationContext = new ServerRequestObservationContext(exchange2.getRequest(), exchange2.getResponse(), exchange2.getAttributes());
        exchange2.getAttributes().put(ServerRequestObservationContext.CURRENT_OBSERVATION_CONTEXT_ATTRIBUTE, observationContext);
        return this.getDelegate().handle(exchange2).doOnSuccess(aVoid -> this.logResponse(exchange2)).onErrorResume(ex -> this.handleUnresolvedError(exchange2, observationContext, (Throwable)ex)).tap(() -> new ObservationSignalListener(observationContext)).then(exchange2.cleanupMultipart()).then(Mono.defer(response::setComplete));
    }

    protected ServerWebExchange createExchange(ServerHttpRequest request, ServerHttpResponse response) {
        return new DefaultServerWebExchange(request, response, this.sessionManager, this.getCodecConfigurer(), this.getLocaleContextResolver(), this.applicationContext);
    }

    protected String formatRequest(ServerHttpRequest request) {
        String rawQuery = request.getURI().getRawQuery();
        Object query = StringUtils.hasText(rawQuery) ? "?" + rawQuery : "";
        return "HTTP " + String.valueOf(request.getMethod()) + " \"" + String.valueOf(request.getPath()) + (String)query + "\"";
    }

    private void logResponse(ServerWebExchange exchange2) {
        LogFormatUtils.traceDebug(logger, traceOn -> {
            HttpStatusCode status = exchange2.getResponse().getStatusCode();
            return exchange2.getLogPrefix() + "Completed " + String.valueOf(status != null ? status : "200 OK") + (String)(traceOn != false ? ", headers=" + this.formatHeaders(exchange2.getResponse().getHeaders()) : "");
        });
    }

    private String formatHeaders(HttpHeaders responseHeaders) {
        return this.enableLoggingRequestDetails ? responseHeaders.toString() : (responseHeaders.isEmpty() ? "{}" : "{masked}");
    }

    private Mono<Void> handleUnresolvedError(ServerWebExchange exchange2, ServerRequestObservationContext observationContext, Throwable ex) {
        ServerHttpRequest request = exchange2.getRequest();
        ServerHttpResponse response = exchange2.getResponse();
        String logPrefix = exchange2.getLogPrefix();
        if (response.setStatusCode(HttpStatus.INTERNAL_SERVER_ERROR)) {
            logger.error(logPrefix + "500 Server Error for " + this.formatRequest(request), ex);
            return Mono.empty();
        }
        if (disconnectedClientHelper.checkAndLogClientDisconnectedException(ex)) {
            observationContext.setConnectionAborted(true);
            return Mono.empty();
        }
        logger.error(logPrefix + "Error [" + String.valueOf(ex) + "] for " + this.formatRequest(request) + ", but ServerHttpResponse already committed (" + String.valueOf(response.getStatusCode()) + ")");
        return Mono.error((Throwable)ex);
    }

    private final class ObservationSignalListener
    extends DefaultSignalListener<Void> {
        private final ServerRequestObservationContext observationContext;
        private final Observation observation;
        private final AtomicBoolean observationRecorded = new AtomicBoolean();

        ObservationSignalListener(ServerRequestObservationContext observationContext) {
            this.observationContext = observationContext;
            this.observation = ServerHttpObservationDocumentation.HTTP_REACTIVE_SERVER_REQUESTS.observation(HttpWebHandlerAdapter.this.observationConvention, DEFAULT_OBSERVATION_CONVENTION, () -> observationContext, HttpWebHandlerAdapter.this.observationRegistry);
        }

        public Context addToContext(Context originalContext) {
            return originalContext.put((Object)"micrometer.observation", (Object)this.observation);
        }

        public void doFirst() throws Throwable {
            this.observation.start();
        }

        public void doOnCancel() throws Throwable {
            if (this.observationRecorded.compareAndSet(false, true)) {
                this.observationContext.setConnectionAborted(true);
                this.observation.stop();
            }
        }

        public void doOnComplete() throws Throwable {
            if (this.observationRecorded.compareAndSet(false, true)) {
                Throwable throwable = (Throwable)this.observationContext.getAttributes().get(ExceptionHandlingWebHandler.HANDLED_WEB_EXCEPTION);
                if (throwable != null) {
                    this.observation.error(throwable);
                }
                this.doOnTerminate(this.observationContext);
            }
        }

        public void doOnError(Throwable error) throws Throwable {
            if (this.observationRecorded.compareAndSet(false, true)) {
                this.observationContext.setError(error);
                this.doOnTerminate(this.observationContext);
            }
        }

        private void doOnTerminate(ServerRequestObservationContext context) {
            ServerHttpResponse response = (ServerHttpResponse)context.getResponse();
            if (response != null) {
                if (response.isCommitted()) {
                    this.observation.stop();
                } else {
                    response.beforeCommit(() -> {
                        this.observation.stop();
                        return Mono.empty();
                    });
                }
            }
        }
    }
}

