/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.service.invoker;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import keycloakjar.org.springframework.aop.framework.ProxyFactory;
import keycloakjar.org.springframework.aop.framework.ReflectiveMethodInvocation;
import keycloakjar.org.springframework.core.KotlinDetector;
import keycloakjar.org.springframework.core.MethodIntrospector;
import keycloakjar.org.springframework.core.annotation.AnnotatedElementUtils;
import keycloakjar.org.springframework.core.convert.ConversionService;
import keycloakjar.org.springframework.format.support.DefaultFormattingConversionService;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.StringValueResolver;
import keycloakjar.org.springframework.web.service.annotation.HttpExchange;
import keycloakjar.org.springframework.web.service.invoker.CookieValueArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.HttpExchangeAdapter;
import keycloakjar.org.springframework.web.service.invoker.HttpMethodArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.HttpServiceMethod;
import keycloakjar.org.springframework.web.service.invoker.PathVariableArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.RequestAttributeArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.RequestBodyArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.RequestHeaderArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.RequestParamArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.RequestPartArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.UriBuilderFactoryArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.UrlArgumentResolver;
import org.aopalliance.intercept.Interceptor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public final class HttpServiceProxyFactory {
    private final HttpExchangeAdapter exchangeAdapter;
    private final List<HttpServiceArgumentResolver> argumentResolvers;
    @Nullable
    private final StringValueResolver embeddedValueResolver;

    private HttpServiceProxyFactory(HttpExchangeAdapter exchangeAdapter, List<HttpServiceArgumentResolver> argumentResolvers, @Nullable StringValueResolver embeddedValueResolver) {
        this.exchangeAdapter = exchangeAdapter;
        this.argumentResolvers = argumentResolvers;
        this.embeddedValueResolver = embeddedValueResolver;
    }

    public <S> S createClient(Class<S> serviceType) {
        List<HttpServiceMethod> httpServiceMethods = MethodIntrospector.selectMethods(serviceType, this::isExchangeMethod).stream().map(method -> this.createHttpServiceMethod(serviceType, (Method)method)).toList();
        return (S)ProxyFactory.getProxy(serviceType, (Interceptor)new HttpServiceMethodInterceptor(httpServiceMethods));
    }

    private boolean isExchangeMethod(Method method) {
        return AnnotatedElementUtils.hasAnnotation(method, HttpExchange.class);
    }

    private <S> HttpServiceMethod createHttpServiceMethod(Class<S> serviceType, Method method) {
        Assert.notNull(this.argumentResolvers, "No argument resolvers: afterPropertiesSet was not called");
        return new HttpServiceMethod(method, serviceType, this.argumentResolvers, this.exchangeAdapter, this.embeddedValueResolver);
    }

    public static Builder builderFor(HttpExchangeAdapter exchangeAdapter) {
        return new Builder().exchangeAdapter(exchangeAdapter);
    }

    public static Builder builder() {
        return new Builder();
    }

    private static final class HttpServiceMethodInterceptor
    implements MethodInterceptor {
        private final Map<Method, HttpServiceMethod> httpServiceMethods;

        private HttpServiceMethodInterceptor(List<HttpServiceMethod> methods) {
            this.httpServiceMethods = methods.stream().collect(Collectors.toMap(HttpServiceMethod::getMethod, Function.identity()));
        }

        @Nullable
        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            HttpServiceMethod httpServiceMethod = this.httpServiceMethods.get(method);
            if (httpServiceMethod != null) {
                Object[] arguments = KotlinDetector.isSuspendingFunction(method) ? HttpServiceMethodInterceptor.resolveCoroutinesArguments(invocation.getArguments()) : invocation.getArguments();
                return httpServiceMethod.invoke(arguments);
            }
            if (method.isDefault() && invocation instanceof ReflectiveMethodInvocation) {
                ReflectiveMethodInvocation reflectiveMethodInvocation = (ReflectiveMethodInvocation)invocation;
                Object proxy = reflectiveMethodInvocation.getProxy();
                return InvocationHandler.invokeDefault(proxy, method, invocation.getArguments());
            }
            throw new IllegalStateException("Unexpected method invocation: " + String.valueOf(method));
        }

        private static Object[] resolveCoroutinesArguments(Object[] args) {
            Object[] functionArgs = new Object[args.length - 1];
            System.arraycopy(args, 0, functionArgs, 0, args.length - 1);
            return functionArgs;
        }
    }

    public static final class Builder {
        @Nullable
        private HttpExchangeAdapter exchangeAdapter;
        private final List<HttpServiceArgumentResolver> customArgumentResolvers = new ArrayList<HttpServiceArgumentResolver>();
        @Nullable
        private ConversionService conversionService;
        @Nullable
        private StringValueResolver embeddedValueResolver;

        private Builder() {
        }

        public Builder exchangeAdapter(HttpExchangeAdapter adapter) {
            this.exchangeAdapter = adapter;
            return this;
        }

        public Builder customArgumentResolver(HttpServiceArgumentResolver resolver) {
            this.customArgumentResolvers.add(resolver);
            return this;
        }

        public Builder conversionService(ConversionService conversionService) {
            this.conversionService = conversionService;
            return this;
        }

        public Builder embeddedValueResolver(StringValueResolver embeddedValueResolver) {
            this.embeddedValueResolver = embeddedValueResolver;
            return this;
        }

        public HttpServiceProxyFactory build() {
            Assert.notNull((Object)this.exchangeAdapter, "HttpClientAdapter is required");
            return new HttpServiceProxyFactory(this.exchangeAdapter, this.initArgumentResolvers(), this.embeddedValueResolver);
        }

        private List<HttpServiceArgumentResolver> initArgumentResolvers() {
            ArrayList<HttpServiceArgumentResolver> resolvers = new ArrayList<HttpServiceArgumentResolver>(this.customArgumentResolvers);
            ConversionService service = this.conversionService != null ? this.conversionService : new DefaultFormattingConversionService();
            resolvers.add(new RequestHeaderArgumentResolver(service));
            resolvers.add(new RequestBodyArgumentResolver(this.exchangeAdapter));
            resolvers.add(new PathVariableArgumentResolver(service));
            resolvers.add(new RequestParamArgumentResolver(service));
            resolvers.add(new RequestPartArgumentResolver(this.exchangeAdapter));
            resolvers.add(new CookieValueArgumentResolver(service));
            if (this.exchangeAdapter.supportsRequestAttributes()) {
                resolvers.add(new RequestAttributeArgumentResolver());
            }
            resolvers.add(new UrlArgumentResolver());
            resolvers.add(new UriBuilderFactoryArgumentResolver());
            resolvers.add(new HttpMethodArgumentResolver());
            return resolvers;
        }
    }
}

