/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.service.invoker;

import java.util.Optional;
import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.core.ParameterizedTypeReference;
import keycloakjar.org.springframework.core.ReactiveAdapter;
import keycloakjar.org.springframework.core.ReactiveAdapterRegistry;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.util.Assert;
import keycloakjar.org.springframework.util.ClassUtils;
import keycloakjar.org.springframework.web.bind.annotation.RequestBody;
import keycloakjar.org.springframework.web.service.invoker.HttpExchangeAdapter;
import keycloakjar.org.springframework.web.service.invoker.HttpRequestValues;
import keycloakjar.org.springframework.web.service.invoker.HttpServiceArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.ReactiveHttpRequestValues;
import keycloakjar.org.springframework.web.service.invoker.ReactorHttpExchangeAdapter;

public class RequestBodyArgumentResolver
implements HttpServiceArgumentResolver {
    private static final boolean REACTOR_PRESENT = ClassUtils.isPresent("reactor.core.publisher.Mono", RequestBodyArgumentResolver.class.getClassLoader());
    @Nullable
    private final ReactiveAdapterRegistry reactiveAdapterRegistry;

    public RequestBodyArgumentResolver(HttpExchangeAdapter exchangeAdapter) {
        if (REACTOR_PRESENT) {
            ReactiveAdapterRegistry reactiveAdapterRegistry;
            if (exchangeAdapter instanceof ReactorHttpExchangeAdapter) {
                ReactorHttpExchangeAdapter reactorAdapter = (ReactorHttpExchangeAdapter)exchangeAdapter;
                reactiveAdapterRegistry = reactorAdapter.getReactiveAdapterRegistry();
            } else {
                reactiveAdapterRegistry = ReactiveAdapterRegistry.getSharedInstance();
            }
            this.reactiveAdapterRegistry = reactiveAdapterRegistry;
        } else {
            this.reactiveAdapterRegistry = null;
        }
    }

    @Override
    public boolean resolve(@Nullable Object argument, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        ReactiveAdapter adapter;
        RequestBody annot = parameter.getParameterAnnotation(RequestBody.class);
        if (annot == null) {
            return false;
        }
        if (argument instanceof Optional) {
            Optional optionalValue = (Optional)argument;
            argument = optionalValue.orElse(null);
        }
        if (argument == null) {
            Assert.isTrue(!annot.required() || parameter.isOptional(), "RequestBody is required");
            return true;
        }
        if (this.reactiveAdapterRegistry != null && (adapter = this.reactiveAdapterRegistry.getAdapter(parameter.getParameterType())) != null) {
            MethodParameter nestedParam = parameter.nested();
            String message = "Async type for @RequestBody should produce value(s)";
            Assert.isTrue(!adapter.isNoValue(), message);
            Assert.isTrue(nestedParam.getNestedParameterType() != Void.class, message);
            if (!(requestValues instanceof ReactiveHttpRequestValues.Builder)) {
                throw new IllegalStateException("RequestBody with a reactive type is only supported with reactive client");
            }
            ReactiveHttpRequestValues.Builder rrv = (ReactiveHttpRequestValues.Builder)requestValues;
            rrv.setBodyPublisher(adapter.toPublisher(argument), ParameterizedTypeReference.forType(nestedParam.getNestedGenericParameterType()));
            return true;
        }
        requestValues.setBodyValue(argument, ParameterizedTypeReference.forType(parameter.getGenericParameterType()));
        return true;
    }
}

