/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.org.springframework.web.service.invoker;

import keycloakjar.org.springframework.core.MethodParameter;
import keycloakjar.org.springframework.core.convert.ConversionService;
import keycloakjar.org.springframework.http.MediaType;
import keycloakjar.org.springframework.lang.Nullable;
import keycloakjar.org.springframework.web.bind.annotation.RequestParam;
import keycloakjar.org.springframework.web.service.invoker.AbstractNamedValueArgumentResolver;
import keycloakjar.org.springframework.web.service.invoker.HttpRequestValues;

public class RequestParamArgumentResolver
extends AbstractNamedValueArgumentResolver {
    private boolean favorSingleValue;

    public RequestParamArgumentResolver(ConversionService conversionService) {
        super(conversionService);
    }

    public void setFavorSingleValue(boolean favorSingleValue) {
        this.favorSingleValue = favorSingleValue;
    }

    public boolean isFavorSingleValue() {
        return this.favorSingleValue;
    }

    @Override
    @Nullable
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter, HttpRequestValues.Metadata metadata) {
        RequestParam annot = parameter.getParameterAnnotation(RequestParam.class);
        if (annot == null) {
            return null;
        }
        return new AbstractNamedValueArgumentResolver.NamedValueInfo(annot.name(), annot.required(), annot.defaultValue(), "request parameter", this.supportsMultipleValues(parameter, metadata));
    }

    @Override
    protected AbstractNamedValueArgumentResolver.NamedValueInfo createNamedValueInfo(MethodParameter parameter) {
        throw new UnsupportedOperationException();
    }

    protected boolean supportsMultipleValues(MethodParameter parameter, HttpRequestValues.Metadata metadata) {
        return !this.isFavorSingleValue() || this.isFormOrMultipartContent(metadata);
    }

    protected boolean isFormOrMultipartContent(HttpRequestValues.Metadata metadata) {
        MediaType mediaType = metadata.getContentType();
        return mediaType != null && (mediaType.getType().equals("multipart") || mediaType.isCompatibleWith(MediaType.APPLICATION_FORM_URLENCODED));
    }

    @Override
    protected void addRequestValue(String name, Object value, MethodParameter parameter, HttpRequestValues.Builder requestValues) {
        requestValues.addRequestParameter(name, (String)value);
    }
}

