/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak.config;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.camunda.bpm.extension.keycloak.config.KeycloakCockpitConfiguration;
import org.springframework.web.client.RestTemplate;

public class KeycloakCockpitConfigurationFilter
implements Filter {
    public static String KEYCLOAK_OPTIONS_PATH = "/app/keycloak/keycloak-options.json";
    public static String KEYCLOAK_JS_PATH = "/app/keycloak/keycloak.min.js";
    KeycloakCockpitConfiguration configuration;

    public KeycloakCockpitConfigurationFilter(KeycloakCockpitConfiguration configuration) {
        this.configuration = configuration;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        PrintWriter out = response.getWriter();
        response.setCharacterEncoding("UTF-8");
        if (((HttpServletRequest)request).getRequestURI().endsWith("keycloak.min.js")) {
            response.setContentType("text/javascript");
            this.getKeycloakMinJs(out);
        } else {
            response.setContentType("application/json");
            out.print(this.configuration.toJSON());
        }
        out.flush();
    }

    private void getKeycloakMinJs(PrintWriter out) {
        try {
            out.print((String)new RestTemplate().getForObject(new URI(this.configuration.getKeycloakUrl() + "/js/keycloak.min.js"), String.class));
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

