/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak.auth;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import org.camunda.bpm.engine.ProcessEngine;
import org.camunda.bpm.engine.rest.security.auth.AuthenticationResult;
import org.camunda.bpm.webapp.impl.security.SecurityActions;
import org.camunda.bpm.webapp.impl.security.auth.Authentications;
import org.camunda.bpm.webapp.impl.security.auth.ContainerBasedAuthenticationFilter;
import org.camunda.bpm.webapp.impl.security.auth.UserAuthentication;
import org.springframework.util.StringUtils;

public class KeycloakJwtAuthenticationFilter
extends ContainerBasedAuthenticationFilter {
    private static final int HTTP_STATUS_NOT_AUTHENTICATED = 401;
    private static final int HTTP_STATUS_NOT_FOUND = 404;
    private static final String GET_METHOD = "GET";
    private String processEngineName = "default";
    private String camundaApplicationPath = "";

    public KeycloakJwtAuthenticationFilter(String camundaApplicationPath) {
        if (StringUtils.hasLength((String)camundaApplicationPath)) {
            this.camundaApplicationPath = camundaApplicationPath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        String engineName = this.extractEngineName(req);
        if (engineName == null) {
            chain.doFilter(request, response);
            return;
        }
        ProcessEngine engine = this.getAddressedEngine(engineName);
        if (engine == null) {
            resp.sendError(404, "Process engine " + engineName + " not available");
            return;
        }
        AuthenticationResult authenticationResult = this.authenticationProvider.extractAuthenticatedUser(req, engine);
        if (authenticationResult.isAuthenticated()) {
            List tenants;
            List groups;
            UserAuthentication authentication;
            Authentications authentications = new Authentications();
            String authenticatedUser = authenticationResult.getAuthenticatedUser();
            if (!this.existisAuthentication(authentications, engineName, authenticatedUser) && (authentication = this.createAuthentication(engine, authenticatedUser, groups = authenticationResult.getGroups(), tenants = authenticationResult.getTenants())) != null) {
                authentications.addOrReplace(authentication);
            }
            Authentications.setCurrent((Authentications)authentications);
            try {
                SecurityActions.runWithAuthentications(() -> {
                    chain.doFilter(request, response);
                    return null;
                }, (Authentications)authentications);
            }
            finally {
                Authentications.clearCurrent();
            }
        } else {
            resp.setStatus(401);
            this.authenticationProvider.augmentResponseByAuthenticationChallenge(resp, engine);
        }
    }

    public void setProcessEngineName(String processEngineName) {
        this.processEngineName = processEngineName;
    }

    protected String extractEngineName(HttpServletRequest request) {
        String requestUri = request.getRequestURI().substring(this.camundaApplicationPath.length());
        Matcher apiStaticPluginPattern = API_STATIC_PLUGIN_PATTERN.matcher(requestUri);
        if (request.getMethod().equals(GET_METHOD) && apiStaticPluginPattern.matches()) {
            return null;
        }
        return this.processEngineName;
    }
}

