/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.util.Objects;
import org.apache.commons.codec.digest.DigestUtils;

public class CacheableKeycloakCheckPasswordCall {
    private final String userId;
    private final String hash;

    public CacheableKeycloakCheckPasswordCall(String userId, String password) {
        this.userId = userId;
        this.hash = password != null ? DigestUtils.sha256Hex(password) : null;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getHash() {
        return this.hash;
    }

    public int hashCode() {
        return Objects.hash(this.hash, this.userId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheableKeycloakCheckPasswordCall other = (CacheableKeycloakCheckPasswordCall)obj;
        return Objects.equals(this.hash, other.hash) && Objects.equals(this.userId, other.userId);
    }
}

