/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import keycloakjar.com.google.gson.JsonObject;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContext;
import org.camunda.bpm.extension.keycloak.json.JsonException;
import org.camunda.bpm.extension.keycloak.json.JsonUtil;
import org.camunda.bpm.extension.keycloak.rest.KeycloakRestTemplate;
import org.camunda.bpm.extension.keycloak.util.KeycloakPluginLogger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;

public class KeycloakContextProvider {
    private static final KeycloakPluginLogger LOG = KeycloakPluginLogger.INSTANCE;
    protected KeycloakConfiguration keycloakConfiguration;
    protected KeycloakRestTemplate restTemplate;
    protected KeycloakContext context;

    public KeycloakContextProvider(KeycloakConfiguration keycloakConfiguration, KeycloakRestTemplate restTemplate) {
        this.keycloakConfiguration = keycloakConfiguration;
        this.restTemplate = restTemplate;
        restTemplate.registerKeycloakContextProvider(this);
    }

    private KeycloakContext openAuthorizationContext() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-www-form-urlencoded;charset=" + this.keycloakConfiguration.getCharset());
        HttpEntity request = new HttpEntity((Object)("client_id=" + this.keycloakConfiguration.getClientId() + "&client_secret=" + this.keycloakConfiguration.getClientSecret() + "&grant_type=client_credentials"), (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(this.keycloakConfiguration.getKeycloakIssuerUrl() + "/protocol/openid-connect/token", request, String.class, new Object[0]);
            if (!response.getStatusCode().equals(HttpStatus.OK)) {
                throw new IdentityProviderException("Could not connect to " + this.keycloakConfiguration.getKeycloakIssuerUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JsonObject json = JsonUtil.parseAsJsonObject((String)response.getBody());
            String accessToken = JsonUtil.getJsonString(json, "access_token");
            String tokenType = JsonUtil.getJsonString(json, "token_type");
            String refreshToken = JsonUtil.getJsonString(json, "refresh_token");
            long expiresInMillis = JsonUtil.getJsonLong(json, "expires_in") * 1000L;
            return new KeycloakContext(accessToken, tokenType, expiresInMillis, refreshToken, this.keycloakConfiguration.getCharset());
        }
        catch (RestClientException rce) {
            LOG.requestTokenFailed((Exception)((Object)rce));
            throw new IdentityProviderException("Unable to get access token from Keycloak server", (Throwable)rce);
        }
        catch (JsonException je) {
            LOG.requestTokenFailed(je);
            throw new IdentityProviderException("Unable to get access token from Keycloak server", (Throwable)je);
        }
    }

    private KeycloakContext refreshToken() {
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Type", "application/x-www-form-urlencoded;charset=" + this.keycloakConfiguration.getCharset());
        HttpEntity request = new HttpEntity((Object)("client_id=" + this.keycloakConfiguration.getClientId() + "&client_secret=" + this.keycloakConfiguration.getClientSecret() + "&refresh_token=" + this.context.getRefreshToken() + "&grant_type=refresh_token"), (MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.postForEntity(this.keycloakConfiguration.getKeycloakIssuerUrl() + "/protocol/openid-connect/token", request, String.class, new Object[0]);
            if (!response.getStatusCode().equals(HttpStatus.OK)) {
                throw new IdentityProviderException("Could not connect to " + this.keycloakConfiguration.getKeycloakIssuerUrl() + ": HTTP status code " + response.getStatusCodeValue());
            }
            JsonObject json = JsonUtil.parseAsJsonObject((String)response.getBody());
            String accessToken = JsonUtil.getJsonString(json, "access_token");
            String tokenType = JsonUtil.getJsonString(json, "token_type");
            String refreshToken = JsonUtil.getJsonString(json, "refresh_token");
            long expiresInMillis = JsonUtil.getJsonLong(json, "expires_in") * 1000L;
            return new KeycloakContext(accessToken, tokenType, expiresInMillis, refreshToken, this.keycloakConfiguration.getCharset());
        }
        catch (RestClientException rce) {
            LOG.refreshTokenFailed((Exception)((Object)rce));
            throw new IdentityProviderException("Unable to refresh access token from Keycloak server", (Throwable)rce);
        }
        catch (JsonException je) {
            LOG.refreshTokenFailed(je);
            throw new IdentityProviderException("Unable to refresh access token from Keycloak server", (Throwable)je);
        }
    }

    public HttpEntity<String> createApiRequestEntity() {
        if (this.context == null) {
            this.context = this.openAuthorizationContext();
        } else if (this.context.needsRefresh()) {
            if (this.context.getRefreshToken() == null) {
                LOG.missingRefreshToken();
                this.context = this.openAuthorizationContext();
            } else {
                try {
                    this.context = this.refreshToken();
                }
                catch (IdentityProviderException ipe) {
                    this.context = this.openAuthorizationContext();
                }
            }
        }
        return this.context.createHttpRequestEntity();
    }

    public void invalidateToken() {
        this.context = null;
    }
}

