/*
 * Decompiled with CFR 0.152.
 */
package keycloakjar.com.github.benmanes.caffeine.cache;

import keycloakjar.com.github.benmanes.caffeine.cache.BoundedWeigher;
import keycloakjar.com.github.benmanes.caffeine.cache.SingletonWeigher;
import keycloakjar.org.checkerframework.checker.index.qual.NonNegative;

@FunctionalInterface
public interface Weigher<K, V> {
    public @NonNegative int weigh(K var1, V var2);

    public static <K, V> Weigher<K, V> singletonWeigher() {
        SingletonWeigher instance = SingletonWeigher.INSTANCE;
        return instance;
    }

    public static <K, V> Weigher<K, V> boundedWeigher(Weigher<K, V> delegate) {
        return new BoundedWeigher<K, V>(delegate);
    }
}

