/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import java.net.URI;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.Session;
import org.camunda.bpm.engine.impl.interceptor.SessionFactory;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakCheckPasswordCall;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakGroupQuery;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakUserQuery;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakIdentityProviderSession;
import org.camunda.bpm.extension.keycloak.cache.CacheConfiguration;
import org.camunda.bpm.extension.keycloak.cache.CacheFactory;
import org.camunda.bpm.extension.keycloak.cache.QueryCache;
import org.camunda.bpm.extension.keycloak.rest.KeycloakRestTemplate;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.util.StringUtils;

public class KeycloakIdentityProviderFactory
implements SessionFactory {
    protected KeycloakConfiguration keycloakConfiguration;
    protected KeycloakContextProvider keycloakContextProvider;
    protected QueryCache<CacheableKeycloakUserQuery, List<User>> userQueryCache;
    protected QueryCache<CacheableKeycloakGroupQuery, List<Group>> groupQueryCache;
    protected QueryCache<CacheableKeycloakCheckPasswordCall, Boolean> checkPasswordCache;
    protected KeycloakRestTemplate restTemplate = new KeycloakRestTemplate();

    public KeycloakIdentityProviderFactory(KeycloakConfiguration keycloakConfiguration, List<ClientHttpRequestInterceptor> customHttpRequestInterceptors) {
        this.keycloakConfiguration = keycloakConfiguration;
        CacheConfiguration cacheConfiguration = CacheConfiguration.from(keycloakConfiguration);
        CacheConfiguration loginCacheConfiguration = CacheConfiguration.fromLoginConfigOf(keycloakConfiguration);
        this.setUserQueryCache(CacheFactory.create(cacheConfiguration));
        this.setGroupQueryCache(CacheFactory.create(cacheConfiguration));
        this.setCheckPasswordCache(CacheFactory.create(loginCacheConfiguration));
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnTotal(keycloakConfiguration.getMaxHttpConnections());
        if (keycloakConfiguration.isDisableSSLCertificateValidation()) {
            try {
                SSLContext sslContext = SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)new TrustAllStrategy()).build();
                SSLConnectionSocketFactory sslConnectionSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
                connectionManagerBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslConnectionSocketFactory);
            }
            catch (GeneralSecurityException e) {
                throw new IdentityProviderException("Disabling SSL certificate validation failed", (Throwable)e);
            }
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connectionManagerBuilder.build()).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        if (StringUtils.hasLength((String)keycloakConfiguration.getProxyUri())) {
            URI proxyUri = URI.create(keycloakConfiguration.getProxyUri());
            HttpHost proxy = new HttpHost(proxyUri.getScheme(), proxyUri.getHost(), proxyUri.getPort());
            httpClientBuilder.setProxy(proxy);
            if (StringUtils.hasLength((String)keycloakConfiguration.getProxyUser()) && keycloakConfiguration.getProxyPassword() != null) {
                credentialsProvider.setCredentials(new AuthScope(proxyUri.getHost(), proxyUri.getPort()), (Credentials)new UsernamePasswordCredentials(keycloakConfiguration.getProxyUser(), keycloakConfiguration.getProxyPassword().toCharArray()));
            }
        }
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClientBuilder.build());
        this.restTemplate.setRequestFactory((ClientHttpRequestFactory)factory);
        for (int i = 0; i < this.restTemplate.getMessageConverters().size(); ++i) {
            if (!(this.restTemplate.getMessageConverters().get(i) instanceof StringHttpMessageConverter)) continue;
            this.restTemplate.getMessageConverters().set(i, new StringHttpMessageConverter(Charset.forName(keycloakConfiguration.getCharset())));
            break;
        }
        this.restTemplate.getInterceptors().addAll(customHttpRequestInterceptors);
        this.keycloakContextProvider = new KeycloakContextProvider(keycloakConfiguration, this.restTemplate);
    }

    public Class<?> getSessionType() {
        return ReadOnlyIdentityProvider.class;
    }

    public void setUserQueryCache(QueryCache<CacheableKeycloakUserQuery, List<User>> userQueryCache) {
        this.userQueryCache = userQueryCache;
    }

    public void setGroupQueryCache(QueryCache<CacheableKeycloakGroupQuery, List<Group>> groupQueryCache) {
        this.groupQueryCache = groupQueryCache;
    }

    public void setCheckPasswordCache(QueryCache<CacheableKeycloakCheckPasswordCall, Boolean> checkPasswordCache) {
        this.checkPasswordCache = checkPasswordCache;
    }

    public void clearCache() {
        this.userQueryCache.clear();
        this.groupQueryCache.clear();
        this.checkPasswordCache.clear();
    }

    public Session openSession() {
        return new KeycloakIdentityProviderSession(this.keycloakConfiguration, this.restTemplate, this.keycloakContextProvider, this.userQueryCache, this.groupQueryCache, this.checkPasswordCache);
    }
}

