/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.extension.keycloak;

import com.google.gson.JsonObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;
import org.camunda.bpm.engine.BadUserRequestException;
import org.camunda.bpm.engine.identity.Group;
import org.camunda.bpm.engine.identity.GroupQuery;
import org.camunda.bpm.engine.identity.NativeUserQuery;
import org.camunda.bpm.engine.identity.Tenant;
import org.camunda.bpm.engine.identity.TenantQuery;
import org.camunda.bpm.engine.identity.User;
import org.camunda.bpm.engine.identity.UserQuery;
import org.camunda.bpm.engine.impl.UserQueryImpl;
import org.camunda.bpm.engine.impl.context.Context;
import org.camunda.bpm.engine.impl.identity.IdentityProviderException;
import org.camunda.bpm.engine.impl.identity.ReadOnlyIdentityProvider;
import org.camunda.bpm.engine.impl.interceptor.CommandContext;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakCheckPasswordCall;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakGroupQuery;
import org.camunda.bpm.extension.keycloak.CacheableKeycloakUserQuery;
import org.camunda.bpm.extension.keycloak.KeycloakConfiguration;
import org.camunda.bpm.extension.keycloak.KeycloakContextProvider;
import org.camunda.bpm.extension.keycloak.KeycloakGroupQuery;
import org.camunda.bpm.extension.keycloak.KeycloakGroupService;
import org.camunda.bpm.extension.keycloak.KeycloakTenantQuery;
import org.camunda.bpm.extension.keycloak.KeycloakUserNotFoundException;
import org.camunda.bpm.extension.keycloak.KeycloakUserQuery;
import org.camunda.bpm.extension.keycloak.KeycloakUserService;
import org.camunda.bpm.extension.keycloak.cache.QueryCache;
import org.camunda.bpm.extension.keycloak.json.JsonException;
import org.camunda.bpm.extension.keycloak.json.JsonUtil;
import org.camunda.bpm.extension.keycloak.rest.KeycloakRestTemplate;
import org.camunda.bpm.extension.keycloak.util.KeycloakPluginLogger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;

public class KeycloakIdentityProviderSession
implements ReadOnlyIdentityProvider {
    protected KeycloakConfiguration keycloakConfiguration;
    protected KeycloakRestTemplate restTemplate;
    protected KeycloakContextProvider keycloakContextProvider;
    protected KeycloakUserService userService;
    protected KeycloakGroupService groupService;
    protected QueryCache<CacheableKeycloakUserQuery, List<User>> userQueryCache;
    protected QueryCache<CacheableKeycloakGroupQuery, List<Group>> groupQueryCache;
    protected QueryCache<CacheableKeycloakCheckPasswordCall, Boolean> checkPasswordCache;

    public KeycloakIdentityProviderSession(KeycloakConfiguration keycloakConfiguration, KeycloakRestTemplate restTemplate, KeycloakContextProvider keycloakContextProvider, QueryCache<CacheableKeycloakUserQuery, List<User>> userQueryCache, QueryCache<CacheableKeycloakGroupQuery, List<Group>> groupQueryCache, QueryCache<CacheableKeycloakCheckPasswordCall, Boolean> checkPasswordCache) {
        this.keycloakConfiguration = keycloakConfiguration;
        this.restTemplate = restTemplate;
        this.keycloakContextProvider = keycloakContextProvider;
        this.userService = new KeycloakUserService(keycloakConfiguration, restTemplate, keycloakContextProvider);
        this.groupService = new KeycloakGroupService(keycloakConfiguration, restTemplate, keycloakContextProvider);
        this.userQueryCache = userQueryCache;
        this.groupQueryCache = groupQueryCache;
        this.checkPasswordCache = checkPasswordCache;
    }

    public void flush() {
    }

    public void close() {
    }

    public User findUserById(String userId) {
        return (User)this.createUserQuery(Context.getCommandContext()).userId(userId).singleResult();
    }

    public UserQuery createUserQuery() {
        return new KeycloakUserQuery(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public UserQueryImpl createUserQuery(CommandContext commandContext) {
        return new KeycloakUserQuery();
    }

    public NativeUserQuery createNativeUserQuery() {
        throw new BadUserRequestException("Native user queries are not supported for Keycloak identity service provider.");
    }

    protected long findUserCountByQueryCriteria(KeycloakUserQuery userQuery) {
        return this.findUserByQueryCriteria(userQuery).size();
    }

    protected List<User> findUserByQueryCriteria(KeycloakUserQuery userQuery) {
        StringBuilder resultLogger = new StringBuilder();
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("Keycloak group query results: [");
        }
        List allMatchingUsers = this.userQueryCache.getOrCompute(CacheableKeycloakUserQuery.of(userQuery), this::doFindUserByQueryCriteria);
        List<User> processedUsers = this.userService.postProcessResults(userQuery, allMatchingUsers, resultLogger);
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("]");
            KeycloakPluginLogger.INSTANCE.groupQueryResult(resultLogger.toString());
        }
        return processedUsers;
    }

    private List<User> doFindUserByQueryCriteria(CacheableKeycloakUserQuery userQuery) {
        if (StringUtils.hasLength((String)userQuery.getGroupId())) {
            return this.userService.requestUsersByGroupId(userQuery);
        }
        return this.userService.requestUsersWithoutGroupId(userQuery);
    }

    public String getKeycloakAdminUserId(String configuredAdminUserId) {
        return this.userService.getKeycloakAdminUserId(configuredAdminUserId);
    }

    public boolean checkPassword(String userId, String password) {
        return this.checkPasswordCache.getOrCompute(new CacheableKeycloakCheckPasswordCall(userId, password), c -> this.doCheckPassword(c.getUserId(), password));
    }

    private boolean doCheckPassword(String userId, String password) {
        String userName;
        if (!StringUtils.hasLength((String)userId)) {
            return false;
        }
        if (!StringUtils.hasLength((String)password)) {
            return false;
        }
        try {
            userName = this.getKeycloakUsername(userId);
        }
        catch (KeycloakUserNotFoundException aunfe) {
            KeycloakPluginLogger.INSTANCE.userNotFound(userId, aunfe);
            return false;
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("Content-Type", "application/x-www-form-urlencoded;charset=" + this.keycloakConfiguration.getCharset());
            HttpEntity request = new HttpEntity((Object)("client_id=" + this.keycloakConfiguration.getClientId() + "&client_secret=" + this.keycloakConfiguration.getClientSecret() + "&username=" + userName + "&password=" + URLEncoder.encode(password, this.keycloakConfiguration.getCharset()) + "&grant_type=password"), (MultiValueMap)headers);
            this.restTemplate.postForEntity(this.keycloakConfiguration.getKeycloakIssuerUrl() + "/protocol/openid-connect/token", request, String.class, new Object[0]);
            return true;
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals(HttpStatus.UNAUTHORIZED)) {
                return false;
            }
            throw new IdentityProviderException("Unable to authenticate user at " + this.keycloakConfiguration.getKeycloakIssuerUrl(), (Throwable)hcee);
        }
        catch (UnsupportedEncodingException | RestClientException rce) {
            throw new IdentityProviderException("Unable to authenticate user at " + this.keycloakConfiguration.getKeycloakIssuerUrl(), rce);
        }
    }

    protected String getKeycloakUsername(String userId) throws KeycloakUserNotFoundException, RestClientException {
        if (this.keycloakConfiguration.isUseUsernameAsCamundaUserId()) {
            return userId;
        }
        try {
            if (this.keycloakConfiguration.isUseEmailAsCamundaUserId()) {
                ResponseEntity<String> response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users?email=" + userId, HttpMethod.GET, String.class, new Object[0]);
                JsonObject result = JsonUtil.findFirst(JsonUtil.parseAsJsonArray((String)response.getBody()), "email", userId);
                if (result != null) {
                    return JsonUtil.getJsonString(result, "username");
                }
                throw new KeycloakUserNotFoundException(userId + " not found - email unknown");
            }
            ResponseEntity<String> response = this.restTemplate.exchange(this.keycloakConfiguration.getKeycloakAdminUrl() + "/users/" + userId, HttpMethod.GET, String.class, new Object[0]);
            return JsonUtil.parseAsJsonObjectAndGetMemberAsString((String)response.getBody(), "username");
        }
        catch (JsonException je) {
            throw new KeycloakUserNotFoundException(userId + (this.keycloakConfiguration.isUseEmailAsCamundaUserId() ? " not found - email unknown" : " not found - ID unknown"), je);
        }
        catch (HttpClientErrorException hcee) {
            if (hcee.getStatusCode().equals(HttpStatus.NOT_FOUND)) {
                throw new KeycloakUserNotFoundException(userId + " not found", hcee);
            }
            throw hcee;
        }
    }

    public Group findGroupById(String groupId) {
        return (Group)this.createGroupQuery(Context.getCommandContext()).groupId(groupId).singleResult();
    }

    public GroupQuery createGroupQuery() {
        return new KeycloakGroupQuery(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public GroupQuery createGroupQuery(CommandContext commandContext) {
        return new KeycloakGroupQuery();
    }

    protected long findGroupCountByQueryCriteria(KeycloakGroupQuery groupQuery) {
        return this.findGroupByQueryCriteria(groupQuery).size();
    }

    protected List<Group> findGroupByQueryCriteria(KeycloakGroupQuery groupQuery) {
        StringBuilder resultLogger = new StringBuilder();
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("Keycloak group query results: [");
        }
        List allMatchingGroups = this.groupQueryCache.getOrCompute(CacheableKeycloakGroupQuery.of(groupQuery), this::doFindGroupByQueryCriteria);
        List<Group> processedGroups = this.groupService.postProcessResults(groupQuery, allMatchingGroups, resultLogger);
        if (KeycloakPluginLogger.INSTANCE.isDebugEnabled()) {
            resultLogger.append("]");
            KeycloakPluginLogger.INSTANCE.groupQueryResult(resultLogger.toString());
        }
        return processedGroups;
    }

    private List<Group> doFindGroupByQueryCriteria(CacheableKeycloakGroupQuery groupQuery) {
        if (StringUtils.hasLength((String)groupQuery.getUserId())) {
            return this.groupService.requestGroupsByUserId(groupQuery);
        }
        return this.groupService.requestGroupsWithoutUserId(groupQuery);
    }

    public String getKeycloakAdminGroupId(String configuredAdminGroupName) {
        return this.groupService.getKeycloakAdminGroupId(configuredAdminGroupName);
    }

    public TenantQuery createTenantQuery() {
        return new KeycloakTenantQuery(Context.getProcessEngineConfiguration().getCommandExecutorTxRequired());
    }

    public TenantQuery createTenantQuery(CommandContext commandContext) {
        return new KeycloakTenantQuery();
    }

    public Tenant findTenantById(String id) {
        return null;
    }
}

