/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.wmf2svg.gdi.wmf;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import net.arnx.wmf2svg.gdi.Gdi;
import net.arnx.wmf2svg.gdi.GdiBrush;
import net.arnx.wmf2svg.gdi.GdiFont;
import net.arnx.wmf2svg.gdi.GdiObject;
import net.arnx.wmf2svg.gdi.GdiPalette;
import net.arnx.wmf2svg.gdi.GdiRegion;
import net.arnx.wmf2svg.gdi.Point;
import net.arnx.wmf2svg.gdi.wmf.WmfConstants;
import net.arnx.wmf2svg.gdi.wmf.WmfParseException;
import net.arnx.wmf2svg.io.DataInput;

public class WmfParser
implements WmfConstants {
    private static Logger log = Logger.getLogger(WmfParser.class.getName());

    public void parse(InputStream inputStream, Gdi gdi) throws IOException, WmfParseException {
        block100: {
            DataInput dataInput = null;
            boolean bl = true;
            try {
                int n;
                int n2;
                int n3;
                dataInput = new DataInput(new BufferedInputStream(inputStream), ByteOrder.LITTLE_ENDIAN);
                int n4 = 0;
                int n5 = 0;
                long l = dataInput.readUint32();
                bl = false;
                if (l == -1698247209L) {
                    n3 = dataInput.readInt16();
                    int n6 = dataInput.readInt16();
                    int n7 = dataInput.readInt16();
                    n2 = dataInput.readInt16();
                    int n8 = dataInput.readInt16();
                    int n9 = dataInput.readUint16();
                    long l2 = dataInput.readUint32();
                    n = dataInput.readUint16();
                    gdi.placeableHeader(n6, n7, n2, n8, n9);
                    n4 = dataInput.readUint16();
                    n5 = dataInput.readUint16();
                } else {
                    n4 = (int)(l & 0xFFFFL);
                    n5 = (int)((l & 0xFFFFFFFFFFFF0000L) >> 16);
                }
                n3 = dataInput.readUint16();
                long l3 = dataInput.readUint32();
                n2 = dataInput.readUint16();
                long l4 = dataInput.readUint32();
                int n10 = dataInput.readUint16();
                if (n4 != 1 || n5 != 9) {
                    throw new WmfParseException("invalid file format.");
                }
                gdi.header();
                GdiObject[] gdiObjectArray = new GdiObject[n2];
                block73: while (true) {
                    int n11;
                    int n12;
                    n = (int)dataInput.readUint32() - 3;
                    int n13 = dataInput.readUint16();
                    if (n13 == 0) break;
                    dataInput.setCount(0);
                    block1 : switch (n13) {
                        case 1078: {
                            int n14;
                            int[] nArray = new int[dataInput.readUint16()];
                            n12 = dataInput.readUint16();
                            int n15 = dataInput.readUint16();
                            for (n14 = 0; n14 < nArray.length; ++n14) {
                                nArray[n14] = dataInput.readInt32();
                            }
                            gdi.animatePalette((GdiPalette)gdiObjectArray[n15], n12, nArray);
                            break;
                        }
                        case 2071: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n17 = dataInput.readInt16();
                            int n18 = dataInput.readInt16();
                            int n19 = dataInput.readInt16();
                            gdi.arc(n19, n18, n17, n16, n14, n15, n12, n11);
                            break;
                        }
                        case 2338: {
                            long l5 = dataInput.readUint32();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n20 = dataInput.readInt16();
                            int n21 = dataInput.readInt16();
                            int n22 = dataInput.readInt16();
                            byte[] byArray = dataInput.readBytes(n * 2 - dataInput.getCount());
                            gdi.bitBlt(byArray, n22, n21, n20, n16, n14, n15, l5);
                            break;
                        }
                        case 2096: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n23 = dataInput.readInt16();
                            int n24 = dataInput.readInt16();
                            int n25 = dataInput.readInt16();
                            gdi.chord(n25, n24, n23, n16, n14, n15, n12, n11);
                            break;
                        }
                        case 764: {
                            int n14;
                            n11 = dataInput.readUint16();
                            n12 = dataInput.readInt32();
                            int n15 = dataInput.readUint16();
                            for (n14 = 0; n14 < gdiObjectArray.length; ++n14) {
                                if (gdiObjectArray[n14] != null) continue;
                                gdiObjectArray[n14] = gdi.createBrushIndirect(n11, n12, n15);
                                break block1;
                            }
                            break;
                        }
                        case 763: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            boolean bl2 = dataInput.readByte() == 1;
                            boolean bl3 = dataInput.readByte() == 1;
                            boolean bl4 = dataInput.readByte() == 1;
                            int n26 = dataInput.readByte();
                            int n27 = dataInput.readByte();
                            int n28 = dataInput.readByte();
                            int n29 = dataInput.readByte();
                            int n30 = dataInput.readByte();
                            int n31 = 3 & n30;
                            int n32 = 0xF0 & n30;
                            byte[] byArray = dataInput.readBytes(2 * (n - 9));
                            GdiFont gdiFont = gdi.createFontIndirect(n11, n12, n15, n14, n16, bl2, bl3, bl4, n26, n27, n28, n29, n30, byArray);
                            for (int i = 0; i < gdiObjectArray.length; ++i) {
                                if (gdiObjectArray[i] != null) continue;
                                gdiObjectArray[i] = gdiFont;
                                break block1;
                            }
                            break;
                        }
                        case 247: {
                            int n15;
                            n11 = dataInput.readUint16();
                            int[] nArray = new int[dataInput.readUint16()];
                            for (n15 = 0; n15 < nArray.length; ++n15) {
                                nArray[n15] = dataInput.readInt32();
                            }
                            for (n15 = 0; n15 < gdiObjectArray.length; ++n15) {
                                if (gdiObjectArray[n15] != null) continue;
                                gdiObjectArray[n15] = gdi.createPalette(n11, nArray);
                                break block1;
                            }
                            break;
                        }
                        case 505: {
                            byte[] byArray = dataInput.readBytes(n * 2 - dataInput.getCount());
                            for (n12 = 0; n12 < gdiObjectArray.length; ++n12) {
                                if (gdiObjectArray[n12] != null) continue;
                                gdiObjectArray[n12] = gdi.createPatternBrush(byArray);
                                break block1;
                            }
                            break;
                        }
                        case 762: {
                            int n14;
                            n11 = dataInput.readUint16();
                            n12 = dataInput.readInt16();
                            dataInput.readInt16();
                            int n15 = dataInput.readInt32();
                            for (n14 = 0; n14 < gdiObjectArray.length; ++n14) {
                                if (gdiObjectArray[n14] != null) continue;
                                gdiObjectArray[n14] = gdi.createPenIndirect(n11, n12, n15);
                                break block1;
                            }
                            break;
                        }
                        case 1791: {
                            int n16;
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            for (n16 = 0; n16 < gdiObjectArray.length; ++n16) {
                                if (gdiObjectArray[n16] != null) continue;
                                gdiObjectArray[n16] = gdi.createRectRgn(n14, n15, n12, n11);
                                break block1;
                            }
                            break;
                        }
                        case 496: {
                            n11 = dataInput.readUint16();
                            gdi.deleteObject(gdiObjectArray[n11]);
                            gdiObjectArray[n11] = null;
                            break;
                        }
                        case 2368: {
                            n11 = 0;
                            long l6 = dataInput.readUint32();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n33 = dataInput.readInt16();
                            if (n33 == 0) {
                                n33 = dataInput.readInt16();
                                n11 = 1;
                            }
                            int n34 = dataInput.readInt16();
                            int n35 = dataInput.readInt16();
                            int n36 = dataInput.readInt16();
                            if (n11 != 0) {
                                gdi.dibBitBlt(null, n36, n35, n34, n33, n16, n14, l6);
                                break;
                            }
                            byte[] byArray = dataInput.readBytes(n * 2 - dataInput.getCount());
                            gdi.dibBitBlt(byArray, n36, n35, n34, n33, n16, n14, l6);
                            break;
                        }
                        case 322: {
                            int n15;
                            n11 = dataInput.readInt32();
                            byte[] byArray = dataInput.readBytes(n * 2 - dataInput.getCount());
                            for (n15 = 0; n15 < gdiObjectArray.length; ++n15) {
                                if (gdiObjectArray[n15] != null) continue;
                                gdiObjectArray[n15] = gdi.dibCreatePatternBrush(byArray, n11);
                                break block1;
                            }
                            break;
                        }
                        case 2881: {
                            long l7 = dataInput.readUint32();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n37 = dataInput.readInt16();
                            int n38 = dataInput.readInt16();
                            int n39 = dataInput.readInt16();
                            int n40 = dataInput.readInt16();
                            int n41 = dataInput.readInt16();
                            byte[] byArray = dataInput.readBytes(n * 2 - dataInput.getCount());
                            gdi.dibStretchBlt(byArray, n41, n40, n39, n38, n16, n37, n14, n15, l7);
                            break;
                        }
                        case 1048: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            gdi.ellipse(n14, n15, n12, n11);
                            break;
                        }
                        case 1574: {
                            byte[] byArray = dataInput.readBytes(2 * n);
                            gdi.escape(byArray);
                            break;
                        }
                        case 1045: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            gdi.excludeClipRect(n14, n15, n12, n11);
                            break;
                        }
                        case 1352: {
                            n11 = dataInput.readUint16();
                            n12 = dataInput.readInt32();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            gdi.extFloodFill(n14, n15, n12, n11);
                            break;
                        }
                        case 2610: {
                            n11 = n;
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readUint16();
                            n11 -= 4;
                            int[] nArray = null;
                            if ((n16 & 6) > 0) {
                                nArray = new int[]{dataInput.readInt16(), dataInput.readInt16(), dataInput.readInt16(), dataInput.readInt16()};
                                n11 -= 4;
                            }
                            byte[] byArray = dataInput.readBytes(n14);
                            if (n14 % 2 == 1) {
                                dataInput.readByte();
                            }
                            int[] nArray2 = null;
                            if ((n11 -= (n14 + 1) / 2) > 0) {
                                nArray2 = new int[n11];
                                for (int i = 0; i < nArray2.length; ++i) {
                                    nArray2[i] = dataInput.readInt16();
                                }
                            }
                            gdi.extTextOut(n15, n12, n16, nArray, byArray, nArray2);
                            break;
                        }
                        case 552: {
                            n11 = dataInput.readUint16();
                            n12 = dataInput.readUint16();
                            gdi.fillRgn((GdiRegion)gdiObjectArray[n12], (GdiBrush)gdiObjectArray[n11]);
                            break;
                        }
                        case 1049: {
                            n11 = dataInput.readInt32();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            gdi.floodFill(n15, n12, n11);
                            break;
                        }
                        case 1065: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readUint16();
                            int n14 = dataInput.readUint16();
                            gdi.frameRgn((GdiRegion)gdiObjectArray[n14], (GdiBrush)gdiObjectArray[n15], n12, n11);
                            break;
                        }
                        case 1046: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            gdi.intersectClipRect(n14, n15, n12, n11);
                            break;
                        }
                        case 298: {
                            n11 = dataInput.readUint16();
                            gdi.invertRgn((GdiRegion)gdiObjectArray[n11]);
                            break;
                        }
                        case 531: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            gdi.lineTo(n12, n11);
                            break;
                        }
                        case 532: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            gdi.moveToEx(n12, n11, null);
                            break;
                        }
                        case 544: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            gdi.offsetClipRgn(n12, n11);
                            break;
                        }
                        case 529: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            gdi.offsetViewportOrgEx(n12, n11, null);
                            break;
                        }
                        case 527: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            gdi.offsetWindowOrgEx(n12, n11, null);
                            break;
                        }
                        case 299: {
                            n11 = dataInput.readUint16();
                            gdi.paintRgn((GdiRegion)gdiObjectArray[n11]);
                            break;
                        }
                        case 1565: {
                            long l8 = dataInput.readUint32();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n42 = dataInput.readInt16();
                            gdi.patBlt(n42, n16, n14, n15, l8);
                            break;
                        }
                        case 2074: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n43 = dataInput.readInt16();
                            int n44 = dataInput.readInt16();
                            int n45 = dataInput.readInt16();
                            gdi.pie(n45, n44, n43, n16, n14, n15, n12, n11);
                            break;
                        }
                        case 804: {
                            Point[] pointArray = new Point[dataInput.readInt16()];
                            for (n12 = 0; n12 < pointArray.length; ++n12) {
                                pointArray[n12] = new Point(dataInput.readInt16(), dataInput.readInt16());
                            }
                            gdi.polygon(pointArray);
                            break;
                        }
                        case 805: {
                            Point[] pointArray = new Point[dataInput.readInt16()];
                            for (n12 = 0; n12 < pointArray.length; ++n12) {
                                pointArray[n12] = new Point(dataInput.readInt16(), dataInput.readInt16());
                            }
                            gdi.polyline(pointArray);
                            break;
                        }
                        case 1336: {
                            int n15;
                            Point[][] pointArray = new Point[dataInput.readInt16()][];
                            for (n12 = 0; n12 < pointArray.length; ++n12) {
                                pointArray[n12] = new Point[dataInput.readInt16()];
                            }
                            for (n12 = 0; n12 < pointArray.length; ++n12) {
                                for (n15 = 0; n15 < pointArray[n12].length; ++n15) {
                                    pointArray[n12][n15] = new Point(dataInput.readInt16(), dataInput.readInt16());
                                }
                            }
                            gdi.polyPolygon(pointArray);
                            break;
                        }
                        case 53: {
                            gdi.realizePalette();
                            break;
                        }
                        case 1051: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            gdi.rectangle(n14, n15, n12, n11);
                            break;
                        }
                        case 313: {
                            n11 = dataInput.readUint16();
                            gdi.resizePalette((GdiPalette)gdiObjectArray[n11]);
                            break;
                        }
                        case 295: {
                            n11 = dataInput.readInt16();
                            gdi.restoreDC(n11);
                            break;
                        }
                        case 1564: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n46 = dataInput.readInt16();
                            gdi.roundRect(n46, n16, n14, n15, n12, n11);
                            break;
                        }
                        case 30: {
                            gdi.seveDC();
                            break;
                        }
                        case 1042: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            gdi.scaleViewportExtEx(n14, n15, n12, n11, null);
                            break;
                        }
                        case 1040: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            gdi.scaleWindowExtEx(n14, n15, n12, n11, null);
                            break;
                        }
                        case 300: {
                            n11 = dataInput.readUint16();
                            GdiRegion gdiRegion = n11 > 0 ? (GdiRegion)gdiObjectArray[n11] : null;
                            gdi.selectClipRgn(gdiRegion);
                            break;
                        }
                        case 301: {
                            n11 = dataInput.readUint16();
                            gdi.selectObject(gdiObjectArray[n11]);
                            break;
                        }
                        case 564: {
                            int n47 = n11 = dataInput.readInt16() != 0 ? 1 : 0;
                            if (n * 2 - dataInput.getCount() <= 0) break;
                            n12 = dataInput.readUint16();
                            gdi.selectPalette((GdiPalette)gdiObjectArray[n12], n11 != 0);
                            break;
                        }
                        case 513: {
                            n11 = dataInput.readInt32();
                            gdi.setBkColor(n11);
                            break;
                        }
                        case 258: {
                            n11 = dataInput.readInt16();
                            gdi.setBkMode(n11);
                            break;
                        }
                        case 3379: {
                            n11 = dataInput.readUint16();
                            n12 = dataInput.readUint16();
                            int n15 = dataInput.readUint16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n48 = dataInput.readInt16();
                            int n49 = dataInput.readInt16();
                            int n50 = dataInput.readInt16();
                            int n51 = dataInput.readInt16();
                            byte[] byArray = dataInput.readBytes(n * 2 - dataInput.getCount());
                            gdi.setDIBitsToDevice(n51, n50, n49, n48, n16, n14, n15, n12, byArray, n11);
                            break;
                        }
                        case 329: {
                            long l9 = dataInput.readUint32();
                            gdi.setLayout(l9);
                            break;
                        }
                        case 259: {
                            n11 = dataInput.readInt16();
                            gdi.setMapMode(n11);
                            break;
                        }
                        case 561: {
                            long l10 = dataInput.readUint32();
                            gdi.setMapperFlags(l10);
                            break;
                        }
                        case 55: {
                            int n14;
                            int[] nArray = new int[dataInput.readUint16()];
                            n12 = dataInput.readUint16();
                            int n15 = dataInput.readUint16();
                            for (n14 = 0; n14 < nArray.length; ++n14) {
                                nArray[n14] = dataInput.readInt32();
                            }
                            gdi.setPaletteEntries((GdiPalette)gdiObjectArray[n15], n12, nArray);
                            break;
                        }
                        case 1055: {
                            n11 = dataInput.readInt32();
                            n12 = dataInput.readInt16();
                            int n15 = dataInput.readInt16();
                            gdi.setPixel(n15, n12, n11);
                            break;
                        }
                        case 262: {
                            n11 = dataInput.readInt16();
                            gdi.setPolyFillMode(n11);
                            break;
                        }
                        case 261: {
                            n11 = dataInput.readInt16();
                            gdi.setRelAbs(n11);
                            break;
                        }
                        case 260: {
                            n11 = dataInput.readInt16();
                            gdi.setROP2(n11);
                            break;
                        }
                        case 263: {
                            n11 = dataInput.readInt16();
                            gdi.setStretchBltMode(n11);
                            break;
                        }
                        case 302: {
                            n11 = dataInput.readInt16();
                            gdi.setTextAlign(n11);
                            break;
                        }
                        case 264: {
                            n11 = dataInput.readInt16();
                            gdi.setTextCharacterExtra(n11);
                            break;
                        }
                        case 521: {
                            n11 = dataInput.readInt32();
                            gdi.setTextColor(n11);
                            break;
                        }
                        case 522: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            gdi.setTextJustification(n12, n11);
                            break;
                        }
                        case 526: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            gdi.setViewportExtEx(n12, n11, null);
                            break;
                        }
                        case 525: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            gdi.setViewportOrgEx(n12, n11, null);
                            break;
                        }
                        case 524: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            gdi.setWindowExtEx(n12, n11, null);
                            break;
                        }
                        case 523: {
                            n11 = dataInput.readInt16();
                            n12 = dataInput.readInt16();
                            gdi.setWindowOrgEx(n12, n11, null);
                            break;
                        }
                        case 2851: {
                            long l11 = dataInput.readUint32();
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n52 = dataInput.readInt16();
                            int n53 = dataInput.readInt16();
                            int n54 = dataInput.readInt16();
                            int n55 = dataInput.readInt16();
                            int n56 = dataInput.readInt16();
                            byte[] byArray = dataInput.readBytes(n * 2 - dataInput.getCount());
                            gdi.stretchBlt(byArray, n56, n55, n54, n53, n52, n16, n14, n15, l11);
                            break;
                        }
                        case 3907: {
                            long l12 = dataInput.readUint32();
                            int n15 = dataInput.readUint16();
                            int n14 = dataInput.readInt16();
                            int n16 = dataInput.readInt16();
                            int n57 = dataInput.readInt16();
                            int n58 = dataInput.readInt16();
                            int n59 = dataInput.readInt16();
                            int n60 = dataInput.readInt16();
                            int n61 = dataInput.readInt16();
                            int n28 = dataInput.readInt16();
                            byte[] byArray = dataInput.readBytes(n * 2 - dataInput.getCount());
                            gdi.stretchDIBits(n28, n61, n60, n59, n58, n57, n16, n14, byArray, n15, l12);
                            break;
                        }
                        case 1313: {
                            n11 = dataInput.readInt16();
                            byte[] byArray = dataInput.readBytes(n11);
                            if (n11 % 2 == 1) {
                                dataInput.readByte();
                            }
                            int n15 = dataInput.readInt16();
                            int n14 = dataInput.readInt16();
                            gdi.textOut(n14, n15, byArray);
                            break;
                        }
                        default: {
                            log.fine("unsuppored id find: " + n13 + " (size=" + n + ")");
                        }
                    }
                    n11 = n * 2 - dataInput.getCount();
                    n12 = 0;
                    while (true) {
                        if (n12 >= n11) continue block73;
                        dataInput.readByte();
                        ++n12;
                    }
                    break;
                }
                dataInput.close();
                gdi.footer();
            }
            catch (EOFException eOFException) {
                if (!bl) break block100;
                throw new WmfParseException("input file size is zero.");
            }
        }
    }
}

