/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.datatypes.PercentBaseContext;
import org.apache.fop.datatypes.SimplePercentBaseContext;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginBlock;
import org.apache.fop.fo.properties.CommonTextDecoration;
import org.apache.fop.fonts.Font;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.MinOptMax;

public final class TraitSetter {
    private static final Log LOG = LogFactory.getLog(TraitSetter.class);

    private TraitSetter() {
    }

    public static void setBorderPaddingTraits(Area area, CommonBorderPaddingBackground bpProps, boolean isNotFirst, boolean isNotLast, PercentBaseContext context) {
        int padding = bpProps.getPadding(2, isNotFirst, context);
        if (padding > 0) {
            area.addTrait(Trait.PADDING_START, padding);
        }
        if ((padding = bpProps.getPadding(3, isNotLast, context)) > 0) {
            area.addTrait(Trait.PADDING_END, padding);
        }
        if ((padding = bpProps.getPadding(0, false, context)) > 0) {
            area.addTrait(Trait.PADDING_BEFORE, padding);
        }
        if ((padding = bpProps.getPadding(1, false, context)) > 0) {
            area.addTrait(Trait.PADDING_AFTER, padding);
        }
        TraitSetter.addBorderTrait(area, bpProps, isNotFirst, 2, 0, Trait.BORDER_START);
        TraitSetter.addBorderTrait(area, bpProps, isNotLast, 3, 0, Trait.BORDER_END);
        TraitSetter.addBorderTrait(area, bpProps, false, 0, 0, Trait.BORDER_BEFORE);
        TraitSetter.addBorderTrait(area, bpProps, false, 1, 0, Trait.BORDER_AFTER);
    }

    private static void addBorderTrait(Area area, CommonBorderPaddingBackground bpProps, boolean discard, int side, int mode, Integer trait) {
        int borderWidth = bpProps.getBorderWidth(side, discard);
        if (borderWidth > 0) {
            area.addTrait(trait, new BorderProps(bpProps.getBorderStyle(side), borderWidth, bpProps.getBorderColor(side), mode));
        }
    }

    public static void addBorders(Area area, CommonBorderPaddingBackground borderProps, PercentBaseContext context) {
        BorderProps bps = TraitSetter.getBorderProps(borderProps, 0);
        if (bps != null) {
            area.addTrait(Trait.BORDER_BEFORE, bps);
        }
        if ((bps = TraitSetter.getBorderProps(borderProps, 1)) != null) {
            area.addTrait(Trait.BORDER_AFTER, bps);
        }
        if ((bps = TraitSetter.getBorderProps(borderProps, 2)) != null) {
            area.addTrait(Trait.BORDER_START, bps);
        }
        if ((bps = TraitSetter.getBorderProps(borderProps, 3)) != null) {
            area.addTrait(Trait.BORDER_END, bps);
        }
        TraitSetter.addPadding(area, borderProps, context);
    }

    public static void addBorders(Area area, CommonBorderPaddingBackground borderProps, boolean discardBefore, boolean discardAfter, boolean discardStart, boolean discardEnd, PercentBaseContext context) {
        BorderProps bps = TraitSetter.getBorderProps(borderProps, 0);
        if (bps != null && !discardBefore) {
            area.addTrait(Trait.BORDER_BEFORE, bps);
        }
        if ((bps = TraitSetter.getBorderProps(borderProps, 1)) != null && !discardAfter) {
            area.addTrait(Trait.BORDER_AFTER, bps);
        }
        if ((bps = TraitSetter.getBorderProps(borderProps, 2)) != null && !discardStart) {
            area.addTrait(Trait.BORDER_START, bps);
        }
        if ((bps = TraitSetter.getBorderProps(borderProps, 3)) != null && !discardEnd) {
            area.addTrait(Trait.BORDER_END, bps);
        }
    }

    public static void addCollapsingBorders(Area area, CommonBorderPaddingBackground.BorderInfo borderBefore, CommonBorderPaddingBackground.BorderInfo borderAfter, CommonBorderPaddingBackground.BorderInfo borderStart, CommonBorderPaddingBackground.BorderInfo borderEnd, boolean[] outer) {
        BorderProps bps = TraitSetter.getCollapsingBorderProps(borderBefore, outer[0]);
        if (bps != null) {
            area.addTrait(Trait.BORDER_BEFORE, bps);
        }
        if ((bps = TraitSetter.getCollapsingBorderProps(borderAfter, outer[1])) != null) {
            area.addTrait(Trait.BORDER_AFTER, bps);
        }
        if ((bps = TraitSetter.getCollapsingBorderProps(borderStart, outer[2])) != null) {
            area.addTrait(Trait.BORDER_START, bps);
        }
        if ((bps = TraitSetter.getCollapsingBorderProps(borderEnd, outer[3])) != null) {
            area.addTrait(Trait.BORDER_END, bps);
        }
    }

    private static void addPadding(Area area, CommonBorderPaddingBackground bordProps, PercentBaseContext context) {
        TraitSetter.addPadding(area, bordProps, false, false, false, false, context);
    }

    public static void addPadding(Area area, CommonBorderPaddingBackground bordProps, boolean discardBefore, boolean discardAfter, boolean discardStart, boolean discardEnd, PercentBaseContext context) {
        int padding = bordProps.getPadding(0, discardBefore, context);
        if (padding != 0) {
            area.addTrait(Trait.PADDING_BEFORE, padding);
        }
        if ((padding = bordProps.getPadding(1, discardAfter, context)) != 0) {
            area.addTrait(Trait.PADDING_AFTER, padding);
        }
        if ((padding = bordProps.getPadding(2, discardStart, context)) != 0) {
            area.addTrait(Trait.PADDING_START, padding);
        }
        if ((padding = bordProps.getPadding(3, discardEnd, context)) != 0) {
            area.addTrait(Trait.PADDING_END, padding);
        }
    }

    private static BorderProps getBorderProps(CommonBorderPaddingBackground bordProps, int side) {
        int width = bordProps.getBorderWidth(side, false);
        if (width != 0) {
            BorderProps bps = new BorderProps(bordProps.getBorderStyle(side), width, bordProps.getBorderColor(side), 0);
            return bps;
        }
        return null;
    }

    private static BorderProps getCollapsingBorderProps(CommonBorderPaddingBackground.BorderInfo borderInfo, boolean outer) {
        assert (borderInfo != null);
        int width = borderInfo.getRetainedWidth();
        if (width != 0) {
            return new BorderProps(borderInfo.getStyle(), width, borderInfo.getColor(), outer ? 2 : 1);
        }
        return null;
    }

    public static void addBackground(Area area, CommonBorderPaddingBackground backProps, PercentBaseContext context, int ipdShift, int bpdShift, int referenceIPD, int referenceBPD) {
        if (!backProps.hasBackground()) {
            return;
        }
        Trait.Background back = new Trait.Background();
        back.setColor(backProps.backgroundColor);
        if (backProps.getImageInfo() != null) {
            SimplePercentBaseContext refContext;
            back.setURL(backProps.backgroundImage);
            back.setImageInfo(backProps.getImageInfo());
            back.setRepeat(backProps.backgroundRepeat);
            if (backProps.backgroundPositionHorizontal != null && (back.getRepeat() == 96 || back.getRepeat() == 114)) {
                if (area.getIPD() > 0) {
                    refContext = new SimplePercentBaseContext(context, 9, referenceIPD - back.getImageInfo().getSize().getWidthMpt());
                    back.setHoriz(ipdShift + backProps.backgroundPositionHorizontal.getValue(refContext));
                } else {
                    LOG.warn("Horizontal background image positioning ignored because the IPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
            if (backProps.backgroundPositionVertical != null && (back.getRepeat() == 96 || back.getRepeat() == 113)) {
                if (area.getBPD() > 0) {
                    refContext = new SimplePercentBaseContext(context, 10, referenceBPD - back.getImageInfo().getSize().getHeightMpt());
                    back.setVertical(bpdShift + backProps.backgroundPositionVertical.getValue(refContext));
                } else {
                    LOG.warn("Vertical background image positioning ignored because the BPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
        }
        area.addTrait(Trait.BACKGROUND, back);
    }

    public static void addBackground(Area area, CommonBorderPaddingBackground backProps, PercentBaseContext context) {
        if (!backProps.hasBackground()) {
            return;
        }
        Trait.Background back = new Trait.Background();
        back.setColor(backProps.backgroundColor);
        if (backProps.getImageInfo() != null) {
            SimplePercentBaseContext simplePercentBaseContext;
            int lengthBaseValue;
            back.setURL(backProps.backgroundImage);
            back.setImageInfo(backProps.getImageInfo());
            back.setRepeat(backProps.backgroundRepeat);
            if (backProps.backgroundPositionHorizontal != null && (back.getRepeat() == 96 || back.getRepeat() == 114)) {
                if (area.getIPD() > 0) {
                    int width = area.getIPD();
                    width += backProps.getPaddingStart(false, context);
                    int imageWidthMpt = back.getImageInfo().getSize().getWidthMpt();
                    lengthBaseValue = (width += backProps.getPaddingEnd(false, context)) - imageWidthMpt;
                    simplePercentBaseContext = new SimplePercentBaseContext(context, 9, lengthBaseValue);
                    int horizontal = backProps.backgroundPositionHorizontal.getValue(simplePercentBaseContext);
                    back.setHoriz(horizontal);
                } else {
                    LOG.warn("Horizontal background image positioning ignored because the IPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
            if (backProps.backgroundPositionVertical != null && (back.getRepeat() == 96 || back.getRepeat() == 113)) {
                if (area.getBPD() > 0) {
                    int height = area.getBPD();
                    height += backProps.getPaddingBefore(false, context);
                    int imageHeightMpt = back.getImageInfo().getSize().getHeightMpt();
                    lengthBaseValue = (height += backProps.getPaddingAfter(false, context)) - imageHeightMpt;
                    simplePercentBaseContext = new SimplePercentBaseContext(context, 10, lengthBaseValue);
                    int vertical = backProps.backgroundPositionVertical.getValue(simplePercentBaseContext);
                    back.setVertical(vertical);
                } else {
                    LOG.warn("Vertical background image positioning ignored because the BPD was not set on the area. (Yes, it's a bug in FOP)");
                }
            }
        }
        area.addTrait(Trait.BACKGROUND, back);
    }

    public static void addMargins(Area area, CommonBorderPaddingBackground bpProps, int startIndent, int endIndent, PercentBaseContext context) {
        int spaceEnd;
        int spaceStart;
        if (startIndent != 0) {
            area.addTrait(Trait.START_INDENT, startIndent);
        }
        if ((spaceStart = startIndent - bpProps.getBorderStartWidth(false) - bpProps.getPaddingStart(false, context)) != 0) {
            area.addTrait(Trait.SPACE_START, spaceStart);
        }
        if (endIndent != 0) {
            area.addTrait(Trait.END_INDENT, endIndent);
        }
        if ((spaceEnd = endIndent - bpProps.getBorderEndWidth(false) - bpProps.getPaddingEnd(false, context)) != 0) {
            area.addTrait(Trait.SPACE_END, spaceEnd);
        }
    }

    public static void addMargins(Area area, CommonBorderPaddingBackground bpProps, CommonMarginBlock marginProps, PercentBaseContext context) {
        int startIndent = marginProps.startIndent.getValue(context);
        int endIndent = marginProps.endIndent.getValue(context);
        TraitSetter.addMargins(area, bpProps, startIndent, endIndent, context);
    }

    public static int getEffectiveSpace(double adjust, MinOptMax space) {
        if (space == null) {
            return 0;
        }
        int spaceOpt = space.getOpt();
        spaceOpt = adjust > 0.0 ? (spaceOpt += (int)(adjust * (double)space.getStretch())) : (spaceOpt += (int)(adjust * (double)space.getShrink()));
        return spaceOpt;
    }

    public static void addSpaceBeforeAfter(Area area, double adjust, MinOptMax spaceBefore, MinOptMax spaceAfter) {
        TraitSetter.addSpaceTrait(area, Trait.SPACE_BEFORE, spaceBefore, adjust);
        TraitSetter.addSpaceTrait(area, Trait.SPACE_AFTER, spaceAfter, adjust);
    }

    private static void addSpaceTrait(Area area, Integer spaceTrait, MinOptMax space, double adjust) {
        int effectiveSpace = TraitSetter.getEffectiveSpace(adjust, space);
        if (effectiveSpace != 0) {
            area.addTrait(spaceTrait, effectiveSpace);
        }
    }

    public static void addBreaks(Area area, int breakBefore, int breakAfter) {
    }

    public static void addFontTraits(Area area, Font font) {
        area.addTrait(Trait.FONT, font.getFontTriplet());
        area.addTrait(Trait.FONT_SIZE, font.getFontSize());
    }

    public static void addTextDecoration(Area area, CommonTextDecoration deco) {
        if (deco != null) {
            if (deco.hasUnderline()) {
                area.addTrait(Trait.UNDERLINE, Boolean.TRUE);
                area.addTrait(Trait.UNDERLINE_COLOR, deco.getUnderlineColor());
            }
            if (deco.hasOverline()) {
                area.addTrait(Trait.OVERLINE, Boolean.TRUE);
                area.addTrait(Trait.OVERLINE_COLOR, deco.getOverlineColor());
            }
            if (deco.hasLineThrough()) {
                area.addTrait(Trait.LINETHROUGH, Boolean.TRUE);
                area.addTrait(Trait.LINETHROUGH_COLOR, deco.getLineThroughColor());
            }
            if (deco.isBlinking()) {
                area.addTrait(Trait.BLINK, Boolean.TRUE);
            }
        }
    }

    public static void addStructureTreeElement(Area area, StructureTreeElement structureTreeElement) {
        if (structureTreeElement != null) {
            area.addTrait(Trait.STRUCTURE_TREE_ELEMENT, structureTreeElement);
        }
    }

    public static void setProducerID(Area area, String id) {
        if (id != null && id.length() > 0) {
            area.addTrait(Trait.PROD_ID, id);
        }
    }
}

