/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.io.File;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.xmlgraphics.util.QName;

public class AFPForeignAttributeReader {
    private static final Log LOG = LogFactory.getLog("org.apache.xmlgraphics.afp");
    public static final QName RESOURCE_NAME = new QName("http://xmlgraphics.apache.org/fop/extensions/afp", "afp:resource-name");
    public static final QName RESOURCE_LEVEL = new QName("http://xmlgraphics.apache.org/fop/extensions/afp", "afp:resource-level");
    public static final QName RESOURCE_GROUP_FILE = new QName("http://xmlgraphics.apache.org/fop/extensions/afp", "afp:resource-group-file");

    public AFPResourceInfo getResourceInfo(Map foreignAttributes) {
        AFPResourceInfo resourceInfo = new AFPResourceInfo();
        if (foreignAttributes != null && !foreignAttributes.isEmpty()) {
            AFPResourceLevel level;
            String resourceName = (String)foreignAttributes.get(RESOURCE_NAME);
            if (resourceName != null) {
                resourceInfo.setName(resourceName);
            }
            if ((level = this.getResourceLevel(foreignAttributes)) != null) {
                resourceInfo.setLevel(level);
            }
        }
        return resourceInfo;
    }

    public AFPResourceLevel getResourceLevel(Map foreignAttributes) {
        String levelString;
        AFPResourceLevel resourceLevel = null;
        if (foreignAttributes != null && !foreignAttributes.isEmpty() && foreignAttributes.containsKey(RESOURCE_LEVEL) && (resourceLevel = AFPResourceLevel.valueOf(levelString = (String)foreignAttributes.get(RESOURCE_LEVEL))) != null && resourceLevel.isExternal()) {
            String msg;
            String resourceGroupFile = (String)foreignAttributes.get(RESOURCE_GROUP_FILE);
            if (resourceGroupFile == null) {
                String msg2 = RESOURCE_GROUP_FILE + " not specified";
                LOG.error(msg2);
                throw new UnsupportedOperationException(msg2);
            }
            File resourceExternalGroupFile = new File(resourceGroupFile);
            SecurityManager security = System.getSecurityManager();
            try {
                if (security != null) {
                    security.checkWrite(resourceExternalGroupFile.getPath());
                }
            }
            catch (SecurityException ex) {
                msg = "unable to gain write access to external resource file: " + resourceGroupFile;
                LOG.error(msg);
            }
            try {
                boolean exists = resourceExternalGroupFile.exists();
                if (exists) {
                    LOG.warn("overwriting external resource file: " + resourceGroupFile);
                }
                resourceLevel.setExternalFilePath(resourceGroupFile);
            }
            catch (SecurityException ex) {
                msg = "unable to gain read access to external resource file: " + resourceGroupFile;
                LOG.error(msg);
            }
        }
        return resourceLevel;
    }
}

