/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx;

import java.io.InputStream;
import org.camunda.bpm.dmn.xlsx.InputOutputDetectionStrategy;
import org.camunda.bpm.dmn.xlsx.SimpleInputOutputDetectionStrategy;
import org.camunda.bpm.dmn.xlsx.XlsxWorksheetContext;
import org.camunda.bpm.dmn.xlsx.XlsxWorksheetConverter;
import org.camunda.bpm.model.dmn.DmnModelInstance;
import org.docx4j.docProps.extended.Properties;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.SpreadsheetMLPackage;
import org.docx4j.openpackaging.parts.SpreadsheetML.SharedStrings;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorkbookPart;
import org.docx4j.openpackaging.parts.SpreadsheetML.WorksheetPart;
import org.xlsx4j.sml.CTSst;
import org.xlsx4j.sml.Worksheet;

public class XlsxConverter {
    protected InputOutputDetectionStrategy ioDetectionStrategy = new SimpleInputOutputDetectionStrategy();

    public DmnModelInstance convert(InputStream inputStream) {
        SpreadsheetMLPackage spreadSheetPackage = null;
        try {
            spreadSheetPackage = (SpreadsheetMLPackage)SpreadsheetMLPackage.load(inputStream);
        }
        catch (Docx4JException e) {
            throw new RuntimeException("cannot load document", e);
        }
        WorkbookPart workbookPart = spreadSheetPackage.getWorkbookPart();
        XlsxWorksheetContext worksheetContext = null;
        try {
            Properties properties = (Properties)spreadSheetPackage.getDocPropsExtendedPart().getContents();
            String worksheetName = (String)properties.getTitlesOfParts().getVector().getVariantOrI1OrI2().get(0).getValue();
            WorksheetPart worksheetPart = workbookPart.getWorksheet(0);
            SharedStrings sharedStrings = workbookPart.getSharedStrings();
            worksheetContext = new XlsxWorksheetContext((CTSst)sharedStrings.getContents(), (Worksheet)worksheetPart.getContents(), worksheetName);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not determine worksheet", e);
        }
        return new XlsxWorksheetConverter(worksheetContext, this.ioDetectionStrategy).convert();
    }

    public InputOutputDetectionStrategy getIoDetectionStrategy() {
        return this.ioDetectionStrategy;
    }

    public void setIoDetectionStrategy(InputOutputDetectionStrategy ioDetectionStrategy) {
        this.ioDetectionStrategy = ioDetectionStrategy;
    }
}

