/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.docx4j.XmlUtils;
import org.docx4j.dml.CTGvmlGroupShape;
import org.docx4j.dml.CTGvmlPicture;
import org.docx4j.dml.CTHyperlink;
import org.docx4j.dml.CTNonVisualDrawingProps;
import org.docx4j.dml.Graphic;
import org.docx4j.dml.GraphicData;
import org.docx4j.dml.diagram.CTDataModel;
import org.docx4j.dml.diagram2008.CTDrawing;
import org.docx4j.dml.picture.Pic;
import org.docx4j.dml.wordprocessingDrawing.Anchor;
import org.docx4j.dml.wordprocessingDrawing.Inline;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.CommentsPart;
import org.docx4j.openpackaging.parts.WordprocessingML.EndnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FootnotesPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.WordprocessingML.MainDocumentPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.utils.CompoundTraversalUtilVisitorCallback;
import org.docx4j.utils.SingleTraversalUtilVisitorCallback;
import org.docx4j.utils.TraversalUtilVisitor;
import org.docx4j.vml.CTShape;
import org.docx4j.vml.CTTextbox;
import org.docx4j.wml.Body;
import org.docx4j.wml.CTEndnotes;
import org.docx4j.wml.CTFootnotes;
import org.docx4j.wml.CTObject;
import org.docx4j.wml.CTTxbxContent;
import org.docx4j.wml.Comments;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Document;
import org.docx4j.wml.FldChar;
import org.docx4j.wml.Ftr;
import org.docx4j.wml.Hdr;
import org.docx4j.wml.Pict;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.Text;
import org.jvnet.jaxb2_commons.ppp.Child;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraversalUtil {
    private static Logger log = LoggerFactory.getLogger(TraversalUtil.class);
    Callback cb;

    public TraversalUtil(Object parent, Callback cb) {
        this.cb = cb;
        cb.walkJAXBElements(parent);
    }

    static void visitChildrenImpl(Object o) {
    }

    private static List<Object> handleGraphicData(GraphicData graphicData) {
        CTNonVisualDrawingProps picNonVisual;
        ArrayList<Object> tmpArtificialList = new ArrayList<Object>();
        if (graphicData.getPic() != null && (picNonVisual = graphicData.getPic().getNvPicPr().getCNvPr()) != null) {
            TraversalUtil.handleCTNonVisualDrawingProps(picNonVisual, tmpArtificialList);
        }
        if (graphicData.getPic() != null && graphicData.getPic().getBlipFill() != null && graphicData.getPic().getBlipFill().getBlip() != null) {
            log.debug("found CTBlip");
            ArrayList<Object> artificialList = new ArrayList<Object>();
            if (!tmpArtificialList.isEmpty()) {
                artificialList.addAll(tmpArtificialList);
            }
            artificialList.add(graphicData.getPic().getBlipFill().getBlip());
            return artificialList;
        }
        return graphicData.getAny();
    }

    private static void handleCTNonVisualDrawingProps(CTNonVisualDrawingProps drawingProps, List<Object> artificialList) {
        CTHyperlink docPrHyperLink;
        if (drawingProps != null && (docPrHyperLink = drawingProps.getHlinkClick()) != null) {
            artificialList.add(docPrHyperLink);
        }
    }

    public static List<Object> getChildrenImpl(Object o) {
        CTNonVisualDrawingProps drawingProps;
        ArrayList<Object> artificialList;
        if (o == null) {
            log.warn("null passed to getChildrenImpl");
            return null;
        }
        log.debug("getting children of " + o.getClass().getName());
        if (o instanceof Text) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof ContentAccessor) {
            return ((ContentAccessor)o).getContent();
        }
        if (o instanceof SdtElement) {
            return ((SdtElement)o).getSdtContent().getContent();
        }
        if (o instanceof Anchor) {
            Anchor anchor = (Anchor)o;
            artificialList = new ArrayList<Object>();
            drawingProps = anchor.getDocPr();
            if (drawingProps != null) {
                TraversalUtil.handleCTNonVisualDrawingProps(drawingProps, artificialList);
            }
            if (anchor.getGraphic() != null) {
                log.debug("found a:graphic");
                Graphic graphic = anchor.getGraphic();
                if (graphic.getGraphicData() != null) {
                    artificialList.addAll(TraversalUtil.handleGraphicData(graphic.getGraphicData()));
                }
            }
            if (!artificialList.isEmpty()) {
                return artificialList;
            }
        } else if (o instanceof Inline) {
            Inline inline = (Inline)o;
            artificialList = new ArrayList();
            drawingProps = inline.getDocPr();
            if (drawingProps != null) {
                TraversalUtil.handleCTNonVisualDrawingProps(drawingProps, artificialList);
            }
            if (inline.getGraphic() != null) {
                log.debug("found a:graphic");
                Graphic graphic = inline.getGraphic();
                if (graphic.getGraphicData() != null) {
                    artificialList.addAll(TraversalUtil.handleGraphicData(graphic.getGraphicData()));
                }
                return artificialList;
            }
            if (!artificialList.isEmpty()) {
                return artificialList;
            }
        } else {
            if (o instanceof Pict) {
                return ((Pict)o).getAnyAndAny();
            }
            if (o instanceof Pic) {
                Pic dmlPic = (Pic)o;
                if (dmlPic.getBlipFill() != null && dmlPic.getBlipFill().getBlip() != null) {
                    log.debug("found DML Blip");
                    ArrayList<Object> artificialList2 = new ArrayList<Object>();
                    artificialList2.add(dmlPic.getBlipFill().getBlip());
                    return artificialList2;
                }
                return null;
            }
            if (o instanceof CTGvmlPicture) {
                CTGvmlPicture dmlPic = (CTGvmlPicture)o;
                if (dmlPic.getBlipFill() != null && dmlPic.getBlipFill().getBlip() != null) {
                    log.debug("found DML Blip");
                    ArrayList<Object> artificialList3 = new ArrayList<Object>();
                    artificialList3.add(dmlPic.getBlipFill().getBlip());
                    return artificialList3;
                }
                return null;
            }
            if (o instanceof CTShape) {
                ArrayList<Object> artificialList4 = new ArrayList<Object>();
                for (JAXBElement<?> j : ((CTShape)o).getPathOrFormulasOrHandles()) {
                    artificialList4.add(j);
                }
                return artificialList4;
            }
            if (o instanceof CTDataModel) {
                CTDataModel dataModel = (CTDataModel)o;
                ArrayList<Object> artificialList5 = new ArrayList<Object>();
                artificialList5.addAll(dataModel.getPtLst().getPt());
                artificialList5.addAll(dataModel.getCxnLst().getCxn());
                return artificialList5;
            }
            if (o instanceof CTDrawing) {
                return ((CTDrawing)o).getSpTree().getSpOrGrpSp();
            }
            if (o instanceof CTTextbox) {
                CTTextbox textBox = (CTTextbox)o;
                if (textBox.getTxbxContent() == null) {
                    return null;
                }
                return textBox.getTxbxContent().getEGBlockLevelElts();
            }
            if (o instanceof CTObject) {
                CTObject ctObject = (CTObject)o;
                ArrayList<Object> artificialList6 = new ArrayList<Object>();
                artificialList6.addAll(ctObject.getAnyAndAny());
                if (ctObject.getControl() != null) {
                    artificialList6.add(ctObject.getControl());
                }
                return artificialList6;
            }
            if (o instanceof CTGvmlGroupShape) {
                return ((CTGvmlGroupShape)o).getTxSpOrSpOrCxnSp();
            }
            if (o instanceof FldChar) {
                FldChar fldChar = (FldChar)o;
                ArrayList<Object> artificialList7 = new ArrayList<Object>();
                artificialList7.add((Object)fldChar.getFldCharType());
                if (fldChar.getFfData() != null) {
                    artificialList7.add(fldChar.getFfData());
                }
                if (fldChar.getFldData() != null) {
                    artificialList7.add(fldChar.getFldData());
                }
                if (fldChar.getNumberingChange() != null) {
                    artificialList7.add(fldChar.getNumberingChange());
                }
                return artificialList7;
            }
        }
        log.debug(".. looking for method which returns list ");
        try {
            Method[] methods = o.getClass().getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method m = methods[i];
                if (!m.getReturnType().getName().equals("java.util.List")) continue;
                return (List)m.invoke(o, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.debug(".. no list member");
        return null;
    }

    public static void main(String[] args) throws Exception {
        String inputfilepath = System.getProperty("user.dir") + "/sample-docs/sample-docx.xml";
        WordprocessingMLPackage wordMLPackage = WordprocessingMLPackage.load(new File(inputfilepath));
        MainDocumentPart documentPart = wordMLPackage.getMainDocumentPart();
        Document wmlDocumentEl = (Document)documentPart.getJaxbElement();
        Body body = wmlDocumentEl.getBody();
        new TraversalUtil(body, new Callback(){
            String indent = "";

            @Override
            public List<Object> apply(Object o) {
                String text = "";
                if (o instanceof Text) {
                    text = ((Text)o).getValue();
                }
                System.out.println(this.indent + o.getClass().getName() + "  \"" + text + "\"");
                return null;
            }

            @Override
            public boolean shouldTraverse(Object o) {
                return true;
            }

            @Override
            public void walkJAXBElements(Object parent) {
                this.indent = this.indent + "    ";
                List<Object> children = this.getChildren(parent);
                if (children != null) {
                    for (Object o : children) {
                        o = XmlUtils.unwrap(o);
                        this.apply(o);
                        if (!this.shouldTraverse(o)) continue;
                        this.walkJAXBElements(o);
                    }
                }
                this.indent = this.indent.substring(0, this.indent.length() - 4);
            }

            @Override
            public List<Object> getChildren(Object o) {
                return TraversalUtil.getChildrenImpl(o);
            }
        });
    }

    public static void replaceChildren(Object o, List<Object> newChildren) {
        if (o instanceof ContentAccessor) {
            ((ContentAccessor)o).getContent().clear();
            ((ContentAccessor)o).getContent().addAll(newChildren);
        } else if (o instanceof SdtElement) {
            ((SdtElement)o).getSdtContent().getContent().clear();
            ((SdtElement)o).getSdtContent().getContent().addAll(newChildren);
        } else if (o instanceof CTTxbxContent) {
            ((CTTxbxContent)o).getEGBlockLevelElts().clear();
            ((CTTxbxContent)o).getEGBlockLevelElts().addAll(newChildren);
        } else {
            log.info("Don't know how to replaceChildren in " + o.getClass().getName());
            if (o instanceof Node) {
                log.warn(" IGNORED " + ((Node)o).getNodeName());
            }
        }
    }

    public static void visit(WordprocessingMLPackage wmlPackage, boolean bodyOnly, TraversalUtilVisitor visitor) {
        if (visitor != null) {
            TraversalUtil.visit(wmlPackage, bodyOnly, new SingleTraversalUtilVisitorCallback(visitor));
        }
    }

    public static void visit(Object parent, TraversalUtilVisitor visitor) {
        if (visitor != null) {
            TraversalUtil.visit(parent, new SingleTraversalUtilVisitorCallback(visitor));
        }
    }

    public static void visit(WordprocessingMLPackage wmlPackage, boolean bodyOnly, List<TraversalUtilVisitor> visitorList) {
        Object callback = null;
        if (visitorList != null && !visitorList.isEmpty()) {
            if (visitorList.size() > 1) {
                TraversalUtil.visit(wmlPackage, bodyOnly, new CompoundTraversalUtilVisitorCallback(visitorList));
            } else {
                TraversalUtil.visit(wmlPackage, bodyOnly, visitorList.get(0));
            }
        }
    }

    public static void visit(Object parent, List<TraversalUtilVisitor> visitorList) {
        Object callback = null;
        if (visitorList != null && !visitorList.isEmpty()) {
            if (visitorList.size() > 1) {
                TraversalUtil.visit(parent, new CompoundTraversalUtilVisitorCallback(visitorList));
            } else {
                TraversalUtil.visit(parent, visitorList.get(0));
            }
        }
    }

    public static void visit(Object parent, Callback callback) {
        if (parent != null && callback != null) {
            callback.walkJAXBElements(parent);
        }
    }

    public static void visit(WordprocessingMLPackage wmlPackage, boolean bodyOnly, Callback callback) {
        MainDocumentPart mainDocument = null;
        RelationshipsPart relPart = null;
        List<Relationship> relList = null;
        List<Object> elementList = null;
        if (wmlPackage != null && callback != null) {
            mainDocument = wmlPackage.getMainDocumentPart();
            callback.walkJAXBElements(((Document)mainDocument.getJaxbElement()).getBody());
            if (!bodyOnly) {
                relPart = mainDocument.getRelationshipsPart();
                relList = relPart.getRelationships().getRelationship();
                for (Relationship rs : relList) {
                    elementList = null;
                    if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header".equals(rs.getType())) {
                        elementList = ((Hdr)((HeaderPart)relPart.getPart(rs)).getJaxbElement()).getContent();
                    } else if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer".equals(rs.getType())) {
                        elementList = ((Ftr)((FooterPart)relPart.getPart(rs)).getJaxbElement()).getContent();
                    } else if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/endnotes".equals(rs.getType())) {
                        elementList = new ArrayList<Object>();
                        elementList.addAll(((CTEndnotes)((EndnotesPart)relPart.getPart(rs)).getJaxbElement()).getEndnote());
                    } else if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footnotes".equals(rs.getType())) {
                        elementList = new ArrayList<Object>();
                        elementList.addAll(((CTFootnotes)((FootnotesPart)relPart.getPart(rs)).getJaxbElement()).getFootnote());
                    } else if ("http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments".equals(rs.getType())) {
                        elementList = new ArrayList<Object>();
                        for (Comments.Comment comment : ((Comments)((CommentsPart)relPart.getPart(rs)).getJaxbElement()).getComment()) {
                            elementList.addAll(comment.getEGBlockLevelElts());
                        }
                    }
                    if (elementList == null || elementList.isEmpty()) continue;
                    log.debug("Processing target: " + rs.getTarget() + ", type: " + rs.getType());
                    callback.walkJAXBElements(elementList);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class CallbackImpl
    implements Callback {
        @Override
        public void walkJAXBElements(Object parent) {
            List<Object> children = this.getChildren(parent);
            if (children != null) {
                for (Object o : children) {
                    if ((o = XmlUtils.unwrap(o)) instanceof Child) {
                        if (parent instanceof SdtBlock) {
                            ((Child)o).setParent(((SdtBlock)parent).getSdtContent());
                        } else {
                            ((Child)o).setParent(parent);
                        }
                    }
                    this.apply(o);
                    if (!this.shouldTraverse(o)) continue;
                    this.walkJAXBElements(o);
                }
            }
        }

        @Override
        public List<Object> getChildren(Object o) {
            return TraversalUtil.getChildrenImpl(o);
        }

        @Override
        public abstract List<Object> apply(Object var1);

        @Override
        public boolean shouldTraverse(Object o) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Callback {
        public void walkJAXBElements(Object var1);

        public List<Object> getChildren(Object var1);

        public List<Object> apply(Object var1);

        public boolean shouldTraverse(Object var1);
    }
}

