/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.datastorage;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBElement;
import org.apache.commons.lang.StringUtils;
import org.docx4j.Docx4jProperties;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.finders.TcFinder;
import org.docx4j.jaxb.Context;
import org.docx4j.model.datastorage.BookmarkRenumber;
import org.docx4j.model.datastorage.DocxFetcher;
import org.docx4j.model.datastorage.InputIntegrityException;
import org.docx4j.model.datastorage.W15RepeatZeroException;
import org.docx4j.model.datastorage.XPathEnhancerParser;
import org.docx4j.model.sdt.QueryString;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.openpackaging.parts.CustomXmlPart;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.AlternativeFormatInputPart;
import org.docx4j.openpackaging.parts.WordprocessingML.FooterPart;
import org.docx4j.openpackaging.parts.WordprocessingML.HeaderPart;
import org.docx4j.openpackaging.parts.opendope.ComponentsPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.docx4j.w15.CTSdtRepeatedSection;
import org.docx4j.wml.CTAltChunk;
import org.docx4j.wml.CTDataBinding;
import org.docx4j.wml.CTLock;
import org.docx4j.wml.CTSdtCell;
import org.docx4j.wml.CTSdtRow;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Id;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.STLock;
import org.docx4j.wml.SdtBlock;
import org.docx4j.wml.SdtElement;
import org.docx4j.wml.SdtPr;
import org.docx4j.wml.SdtRun;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Tag;
import org.docx4j.wml.Tc;
import org.opendope.components.Components;
import org.opendope.conditions.Condition;
import org.opendope.conditions.Conditions;
import org.opendope.xpaths.Xpaths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDoPEHandler {
    private static Logger log = LoggerFactory.getLogger(OpenDoPEHandler.class);
    private Map<String, Xpaths.Xpath> xpathsMap = null;
    private Map<String, Condition> conditionsMap = null;
    private WordprocessingMLPackage wordMLPackage;
    private ShallowTraversor shallowTraversor;
    private BookmarkRenumber bookmarkRenumber;
    public static final String BINDING_ROLE_XPATH = "od:xpath";
    public static final String BINDING_ROLE_CONDITIONAL = "od:condition";
    public static final String BINDING_RESULT_CONDITION_FALSE = "od:resultConditionFalse";
    public static final String BINDING_ROLE_REPEAT = "od:repeat";
    public static final String BINDING_RESULT_RPTD_ZERO = "od:resultRepeatZero";
    public static final String BINDING_RESULT_RPTD_ZERO_W15 = "w15:resultRepeatZero";
    public static final String BINDING_RESULT_RPTD = "od:rptd";
    public static final String BINDING_ROLE_RPT_POS_CON = "od:RptPosCon";
    public static final String BINDING_ROLE_NARRATIVE = "od:narrative";
    public static final String BINDING_ROLE_COMPONENT = "od:component";
    public static final String BINDING_ROLE_COMPONENT_BEFORE = "od:continuousBefore";
    public static final String BINDING_ROLE_COMPONENT_AFTER = "od:continuousAfter";
    public static final String BINDING_CONTENTTYPE = "od:ContentType";
    public static final String BINDING_HANDLER = "od:Handler";
    public static final String BINDING_PROGID = "od:progid";
    private Components components;
    private boolean justGotAComponent = false;
    private static DocxFetcher docxFetcher;
    boolean reverterSupported = Docx4jProperties.getProperty("docx4j.model.datastorage.OpenDoPEReverter.Supported", true);
    public long cloneTime = 0L;
    public long fixBTime = 0L;

    public OpenDoPEHandler(WordprocessingMLPackage wordMLPackage) throws Docx4JException {
        this.wordMLPackage = wordMLPackage;
        if (wordMLPackage.getMainDocumentPart().getXPathsPart() == null) {
            log.info("OpenDoPE XPaths part missing (ok if you are just processing w15 repeatingSection)");
            this.xpathsMap = new HashMap<String, Xpaths.Xpath>();
        } else {
            Xpaths xPaths = (Xpaths)wordMLPackage.getMainDocumentPart().getXPathsPart().getJaxbElement();
            log.debug(XmlUtils.marshaltoString((Object)xPaths, true, true));
            this.xpathsMap = new HashMap<String, Xpaths.Xpath>(2 * xPaths.getXpath().size());
            for (Xpaths.Xpath xp : xPaths.getXpath()) {
                if (this.xpathsMap.put(xp.getId(), xp) == null) continue;
                log.error("Duplicates in XPaths part: " + xp.getId());
            }
        }
        if (wordMLPackage.getMainDocumentPart().getConditionsPart() != null) {
            Conditions conditions = (Conditions)wordMLPackage.getMainDocumentPart().getConditionsPart().getJaxbElement();
            log.debug(XmlUtils.marshaltoString((Object)conditions, true, true));
            this.conditionsMap = new HashMap<String, Condition>(2 * conditions.getCondition().size());
            for (Condition c : conditions.getCondition()) {
                if (this.conditionsMap.put(c.getId(), c) == null) continue;
                log.error("Duplicates in Conditions part: " + c.getId());
            }
        }
        if (wordMLPackage.getMainDocumentPart().getComponentsPart() != null) {
            this.components = (Components)wordMLPackage.getMainDocumentPart().getComponentsPart().getJaxbElement();
            log.debug(XmlUtils.marshaltoString((Object)this.components, true, true));
        }
        this.shallowTraversor = new ShallowTraversor();
        this.shallowTraversor.wordMLPackage = wordMLPackage;
        this.bookmarkRenumber = new BookmarkRenumber(wordMLPackage);
    }

    public AtomicInteger getNextBookmarkId() {
        return this.bookmarkRenumber.getBookmarkId();
    }

    public WordprocessingMLPackage preprocess() throws Docx4JException {
        do {
            Set<ContentAccessor> partList = OpenDoPEHandler.getParts(this.wordMLPackage);
            try {
                for (ContentAccessor part : partList) {
                    new TraversalUtil(part, this.shallowTraversor);
                }
            }
            catch (InputIntegrityException iie) {
                throw new Docx4JException(iie.getMessage(), iie);
            }
            for (ContentAccessor part : partList) {
                this.wordMLPackage = this.fetchComponents(this.wordMLPackage, part);
            }
        } while (this.justGotAComponent);
        if (this.wordMLPackage.getMainDocumentPart().getXPathsPart() != null) {
            ((Xpaths)this.wordMLPackage.getMainDocumentPart().getXPathsPart().getContents()).getXpath().clear();
            ((Xpaths)this.wordMLPackage.getMainDocumentPart().getXPathsPart().getContents()).getXpath().addAll(this.xpathsMap.values());
        }
        if (this.wordMLPackage.getMainDocumentPart().getConditionsPart() != null) {
            ((Conditions)this.wordMLPackage.getMainDocumentPart().getConditionsPart().getContents()).getCondition().clear();
            ((Conditions)this.wordMLPackage.getMainDocumentPart().getConditionsPart().getContents()).getCondition().addAll(this.conditionsMap.values());
        }
        return this.wordMLPackage;
    }

    public static DocxFetcher getDocxFetcher() {
        return docxFetcher;
    }

    public static void setDocxFetcher(DocxFetcher docxFetcher) {
        OpenDoPEHandler.docxFetcher = docxFetcher;
    }

    protected static Set<ContentAccessor> getParts(WordprocessingMLPackage srcPackage) {
        HashSet<ContentAccessor> partList = new HashSet<ContentAccessor>();
        partList.add(srcPackage.getMainDocumentPart());
        RelationshipsPart rp = srcPackage.getMainDocumentPart().getRelationshipsPart();
        for (Relationship r : rp.getRelationships().getRelationship()) {
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header")) {
                partList.add((HeaderPart)rp.getPart(r));
                continue;
            }
            if (!r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer")) continue;
            partList.add((FooterPart)rp.getPart(r));
        }
        return partList;
    }

    private WordprocessingMLPackage fetchComponents(WordprocessingMLPackage srcPackage, ContentAccessor contentAccessor) throws Docx4JException {
        HashMap<Integer, CTAltChunk> replacements = new HashMap<Integer, CTAltChunk>();
        Integer index = 0;
        this.justGotAComponent = false;
        LinkedList<Integer> continuousBeforeIndex = new LinkedList<Integer>();
        ArrayList<Boolean> continuousBefore = new ArrayList<Boolean>();
        ArrayList<Boolean> continuousAfter = new ArrayList<Boolean>();
        for (Object block : contentAccessor.getContent()) {
            Object tag;
            Object sdt;
            if (block instanceof SdtBlock) {
                sdt = (SdtBlock)block;
                tag = OpenDoPEHandler.getSdtPr(sdt).getTag();
                if (tag == null) {
                    ArrayList<Object> newContent = new ArrayList<Object>();
                    newContent.add(sdt);
                    continue;
                }
                log.info(((Tag)tag).getVal());
                HashMap<String, String> map = QueryString.parseQueryString(((Tag)tag).getVal(), true);
                String componentId = map.get(BINDING_ROLE_COMPONENT);
                if (componentId == null) continue;
                String iri = ComponentsPart.getComponentById(this.components, componentId).getIri();
                log.debug("Fetching " + iri);
                if (docxFetcher == null) {
                    log.error("You need a docxFetcher (and the MergeDocx extension) to fetch components");
                    return srcPackage;
                }
                AlternativeFormatInputPart afiPart = new AlternativeFormatInputPart(this.getNewPartName("/chunk", ".docx", srcPackage.getMainDocumentPart().getRelationshipsPart()));
                afiPart.setBinaryData(docxFetcher.getDocxFromIRI(iri));
                afiPart.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml"));
                Relationship altChunkRel = srcPackage.getMainDocumentPart().addTargetPart(afiPart);
                CTAltChunk ac = Context.getWmlObjectFactory().createCTAltChunk();
                ac.setId(altChunkRel.getId());
                replacements.put(index, ac);
                if (map.get(BINDING_ROLE_COMPONENT_BEFORE) != null && map.get(BINDING_ROLE_COMPONENT_BEFORE).equals("true")) {
                    continuousBefore.add(Boolean.TRUE);
                    continuousBeforeIndex.addFirst(index);
                    log.info("ctsBefore index: " + index);
                } else {
                    continuousBefore.add(Boolean.FALSE);
                    continuousBeforeIndex.addFirst(index);
                }
                if (map.get(BINDING_ROLE_COMPONENT_AFTER) != null && map.get(BINDING_ROLE_COMPONENT_AFTER).equals("true")) {
                    continuousAfter.add(Boolean.TRUE);
                } else {
                    continuousAfter.add(Boolean.TRUE);
                }
                this.justGotAComponent = true;
            }
            sdt = index;
            index = index + 1;
            tag = index;
        }
        if (!this.justGotAComponent) {
            return srcPackage;
        }
        for (Integer key : replacements.keySet()) {
            contentAccessor.getContent().set(key, replacements.get(key));
        }
        List<Object> bodyChildren = contentAccessor.getContent();
        int i = 0;
        for (Integer indexIntoBody : continuousBeforeIndex) {
            if (((Boolean)continuousBefore.get(i)).booleanValue() && indexIntoBody != 0) {
                Object block = bodyChildren.get(indexIntoBody - 1);
                if (block instanceof P && ((P)block).getPPr() != null && ((P)block).getPPr().getSectPr() != null) {
                    this.makeContinuous(((P)block).getPPr().getSectPr());
                } else if (block instanceof P) {
                    PPr ppr = ((P)block).getPPr();
                    if (ppr == null) {
                        ppr = Context.getWmlObjectFactory().createPPr();
                        ((P)block).setPPr(ppr);
                    }
                    SectPr newSectPr = Context.getWmlObjectFactory().createSectPr();
                    SectPr.Type type = Context.getWmlObjectFactory().createSectPrType();
                    type.setVal("continuous");
                    newSectPr.setType(type);
                    ppr.setSectPr(newSectPr);
                } else {
                    P newP = Context.getWmlObjectFactory().createP();
                    PPr ppr = Context.getWmlObjectFactory().createPPr();
                    newP.setPPr(ppr);
                    SectPr newSectPr = Context.getWmlObjectFactory().createSectPr();
                    SectPr.Type type = Context.getWmlObjectFactory().createSectPrType();
                    type.setVal("continuous");
                    newSectPr.setType(type);
                    ppr.setSectPr(newSectPr);
                    bodyChildren.add(indexIntoBody, newP);
                }
            }
            ++i;
        }
        try {
            Class<?> documentBuilder = Class.forName("com.plutext.merge.ProcessAltChunk");
            Method[] methods = documentBuilder.getMethods();
            Method processMethod = null;
            for (int j = 0; j < methods.length; ++j) {
                log.debug(methods[j].getName());
                if (!methods[j].getName().equals("process")) continue;
                processMethod = methods[j];
            }
            if (processMethod == null) {
                throw new NoSuchMethodException();
            }
            return (WordprocessingMLPackage)processMethod.invoke(null, srcPackage);
        }
        catch (ClassNotFoundException e) {
            this.extensionMissing(e);
            this.justGotAComponent = false;
            return srcPackage;
        }
        catch (NoSuchMethodException e) {
            this.extensionMissing(e);
            this.justGotAComponent = false;
            return srcPackage;
        }
        catch (Exception e) {
            throw new Docx4JException("Problem processing w:altChunk", e);
        }
    }

    public void makeContinuous(SectPr sectPr) {
        if (sectPr == null) {
            log.warn("sectPr was null");
            return;
        }
        SectPr.Type type = Context.getWmlObjectFactory().createSectPrType();
        type.setVal("continuous");
        sectPr.setType(type);
        sectPr.setBidi(null);
        sectPr.setDocGrid(null);
        sectPr.setPaperSrc(null);
        sectPr.setPgBorders(null);
        sectPr.setPgMar(null);
        sectPr.setPgNumType(null);
        sectPr.setPgSz(null);
        sectPr.setPrinterSettings(null);
        sectPr.setSectPrChange(null);
        sectPr.setTitlePg(null);
        sectPr.setVAlign(null);
    }

    private PartName getNewPartName(String prefix, String suffix, RelationshipsPart rp) throws InvalidFormatException {
        PartName proposed = null;
        int i = 1;
        do {
            proposed = i > 1 ? new PartName(prefix + i + suffix) : new PartName(prefix + suffix);
            ++i;
        } while (rp.getRel(proposed) != null);
        return proposed;
    }

    public void extensionMissing(Exception e) {
        log.error("\n" + e.getClass().getName() + ": " + e.getMessage() + "\n");
        log.error("* You don't appear to have the MergeDocx paid extension,");
        log.error("* which is necessary to merge docx, or process altChunk.");
        log.error("* Purchases of this extension support the docx4j project.");
        log.error("* Please visit www.plutext.com if you want to buy it.");
    }

    private CTSdtRepeatedSection getW15RepeatingSection(SdtPr sdtPr) {
        return (CTSdtRepeatedSection)sdtPr.getByClass(CTSdtRepeatedSection.class);
    }

    private List<Object> processBindingRoleIfAny(WordprocessingMLPackage wordMLPackage, Object sdt) {
        Tag tag;
        Id id = OpenDoPEHandler.getSdtPr(sdt).getId();
        if (id != null) {
            log.debug("Processing " + id.getVal());
        }
        if ((tag = OpenDoPEHandler.getSdtPr(sdt).getTag()) == null) {
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(sdt);
            return newContent;
        }
        log.info(tag.getVal());
        HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
        String conditionId = map.get(BINDING_ROLE_CONDITIONAL);
        String repeatId = map.get(BINDING_ROLE_REPEAT);
        String xp = map.get(BINDING_ROLE_XPATH);
        if (conditionId == null && repeatId == null && xp == null) {
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(sdt);
            return newContent;
        }
        HashMap<String, CustomXmlPart> customXmlDataStorageParts = wordMLPackage.getCustomXmlDataStorageParts();
        if (conditionId != null) {
            log.info("Processing Conditional: " + tag.getVal());
            Condition c = this.conditionsMap.get(conditionId);
            if (c == null) {
                log.error("Missing condition " + conditionId);
            }
            if (c.evaluate(wordMLPackage, customXmlDataStorageParts, this.conditionsMap, this.xpathsMap)) {
                log.debug("so keeping");
                ArrayList<Object> newContent = new ArrayList<Object>();
                newContent.add(sdt);
                return newContent;
            }
            if (this.reverterSupported) {
                return this.conditionFalse(sdt);
            }
            return new ArrayList<Object>();
        }
        if (repeatId != null) {
            log.info("Processing OpenDoPE Repeat: " + tag.getVal());
            return this.processOpenDopeRepeat(sdt, customXmlDataStorageParts);
        }
        if (xp != null) {
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(sdt);
            return newContent;
        }
        return null;
    }

    private List<Object> conditionFalse(Object sdt) {
        ArrayList<Object> newContent = new ArrayList<Object>();
        newContent.add(sdt);
        SdtPr sdtPr = OpenDoPEHandler.getSdtPr(sdt);
        CTDataBinding binding = sdtPr.getDataBinding();
        if (binding != null) {
            sdtPr.getRPrOrAliasOrLock().remove(binding);
        }
        Tag tag = sdtPr.getTag();
        String tagVal = tag.getVal();
        Pattern stripConditionArgPattern = Pattern.compile("(.*od:condition=)([^&]*)(.*)");
        Matcher stripPatternMatcher = stripConditionArgPattern.matcher(tagVal);
        if (!stripPatternMatcher.matches()) {
            log.error("Cannot find condition tag in sdtPr/tag while setting conditionFalse; something is wrong with " + tagVal);
            return newContent;
        }
        String emptyConditionValue = "od:resultConditionFalse=" + stripPatternMatcher.group(2) + stripPatternMatcher.group(3);
        tag.setVal(emptyConditionValue);
        CTLock lock = Context.getWmlObjectFactory().createCTLock();
        lock.setVal(STLock.SDT_CONTENT_LOCKED);
        JAXBElement<CTLock> lockWrapped = Context.getWmlObjectFactory().createSdtPrLock(lock);
        sdtPr.getRPrOrAliasOrLock().add(lockWrapped);
        TcFinder tcFinder = new TcFinder();
        new TraversalUtil(((SdtElement)sdt).getSdtContent().getContent(), tcFinder);
        if (tcFinder.tcList.size() > 0) {
            Tc tc = tcFinder.tcList.get(0);
            tc.getContent().clear();
            P p = Context.getWmlObjectFactory().createP();
            tc.getContent().add(p);
            ((SdtElement)sdt).getSdtContent().getContent().clear();
            ((SdtElement)sdt).getSdtContent().getContent().add(tc);
        } else {
            ((SdtElement)sdt).getSdtContent().getContent().clear();
        }
        return newContent;
    }

    private List<Object> processOpenDopeRepeat(Object sdt, Map<String, CustomXmlPart> customXmlDataStorageParts) {
        Tag tag = OpenDoPEHandler.getSdtPr(sdt).getTag();
        HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
        String repeatId = map.get(BINDING_ROLE_REPEAT);
        if (StringUtils.isEmpty(repeatId)) {
            return new ArrayList<Object>();
        }
        Xpaths.Xpath xpathObj = this.xpathsMap.get(repeatId);
        String storeItemId = xpathObj.getDataBinding().getStoreItemID();
        String xpath = xpathObj.getDataBinding().getXpath();
        String prefixMappings = xpathObj.getDataBinding().getPrefixMappings();
        try {
            return this.processRepeat(sdt, customXmlDataStorageParts, storeItemId, xpath, prefixMappings, false);
        }
        catch (W15RepeatZeroException w15) {
            return null;
        }
    }

    private List<Object> processW15Repeat(Object repeatingSectionSdt, Map<String, CustomXmlPart> customXmlDataStorageParts) {
        CTDataBinding w15Databinding = OpenDoPEHandler.getSdtPr(repeatingSectionSdt).getDataBinding();
        String storeItemId = w15Databinding.getStoreItemID();
        String xpath = w15Databinding.getXpath();
        String prefixMappings = w15Databinding.getPrefixMappings();
        ContentAccessor ca = ((SdtElement)repeatingSectionSdt).getSdtContent();
        SdtElement repeatingItem = (SdtElement)XmlUtils.unwrap(ca.getContent().get(0));
        try {
            List<Object> repeatingSectionItems = this.processRepeat(repeatingItem, customXmlDataStorageParts, storeItemId, xpath, prefixMappings, true);
            ca.getContent().clear();
            ca.getContent().addAll(repeatingSectionItems);
        }
        catch (W15RepeatZeroException w15) {
            log.warn(w15.getMessage());
            SdtPr sdtPr = OpenDoPEHandler.getSdtPr(repeatingSectionSdt);
            Tag tag = new Tag();
            tag.setVal("w15:resultRepeatZero=true");
            sdtPr.setTag(tag);
        }
        ArrayList<Object> newContent = new ArrayList<Object>();
        newContent.add(repeatingSectionSdt);
        return newContent;
    }

    private List<Object> processRepeat(Object sdt, Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings, boolean isW15RepeatingSection) throws W15RepeatZeroException {
        int i;
        long startTime = System.currentTimeMillis();
        String xpathBase = xpath.endsWith("/") ? xpath.substring(0, xpath.length() - 1) : (xpath.endsWith("[1]") ? xpath.substring(0, xpath.length() - 3) : xpath);
        log.info("/n/n Repeat: using xpath: " + xpathBase + " and " + prefixMappings);
        List<Node> repeatedSiblings = this.xpathGetNodes(customXmlDataStorageParts, storeItemId, xpathBase, prefixMappings);
        int numRepeats = repeatedSiblings.size();
        log.debug("yields REPEATS: " + numRepeats);
        if (numRepeats == 0) {
            if (isW15RepeatingSection) {
                throw new W15RepeatZeroException("Zero repeats found for " + xpathBase + "; leaving existing content (as Word does)!");
            }
            if (this.reverterSupported) {
                return this.repeatZero(sdt);
            }
            return new ArrayList<Object>();
        }
        List<Object> repeated = this.cloneRepeatSdt(sdt, xpathBase, numRepeats);
        this.cloneTime += System.currentTimeMillis() - startTime;
        startTime = System.currentTimeMillis();
        DeepTraversor dt = new DeepTraversor();
        dt.xpathBase = xpathBase;
        for (i = 0; i < repeated.size(); ++i) {
            log.info("\n Traversing clone " + i);
            dt.index = i;
            new TraversalUtil(repeated.get(i), dt);
        }
        log.info(".. deep traversals done ");
        this.fixBTime += System.currentTimeMillis() - startTime;
        for (i = 0; i < repeated.size(); ++i) {
            try {
                Id id = ((SdtElement)repeated.get(i)).getSdtPr().getId();
                if (id == null) {
                    ((SdtElement)repeated.get(i)).getSdtPr().setId();
                    id = ((SdtElement)repeated.get(i)).getSdtPr().getId();
                }
                long global = id.getVal().longValue();
                this.bookmarkRenumber.fixRange(((SdtElement)repeated.get(i)).getSdtContent().getContent(), "CTBookmark", "CTMarkupRange", null, global, i);
                continue;
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        return repeated;
    }

    private List<Object> repeatZero(Object sdt) {
        ArrayList<Object> newContent = new ArrayList<Object>();
        newContent.add(sdt);
        SdtPr sdtPr = OpenDoPEHandler.getSdtPr(sdt);
        CTDataBinding binding = sdtPr.getDataBinding();
        if (binding != null) {
            sdtPr.getRPrOrAliasOrLock().remove(binding);
        }
        Tag tag = sdtPr.getTag();
        String tagVal = tag.getVal();
        Pattern stripRepeatArgPattern = Pattern.compile("(.*od:repeat=)([^&]*)(.*)");
        Matcher stripPatternMatcher = stripRepeatArgPattern.matcher(tagVal);
        if (!stripPatternMatcher.matches()) {
            log.error("Cannot find repeat tag in sdtPr/tag while processing repeat; something is wrong with " + tagVal);
            return newContent;
        }
        String emptyRepeatValue = "od:resultRepeatZero=" + stripPatternMatcher.group(2) + stripPatternMatcher.group(3);
        tag.setVal(emptyRepeatValue);
        CTLock lock = Context.getWmlObjectFactory().createCTLock();
        lock.setVal(STLock.SDT_CONTENT_LOCKED);
        JAXBElement<CTLock> lockWrapped = Context.getWmlObjectFactory().createSdtPrLock(lock);
        sdtPr.getRPrOrAliasOrLock().add(lockWrapped);
        TcFinder tcFinder = new TcFinder();
        new TraversalUtil(((SdtElement)sdt).getSdtContent().getContent(), tcFinder);
        if (tcFinder.tcList.size() > 0) {
            Tc tc = tcFinder.tcList.get(0);
            tc.getContent().clear();
            P p = Context.getWmlObjectFactory().createP();
            tc.getContent().add(p);
            ((SdtElement)sdt).getSdtContent().getContent().clear();
            ((SdtElement)sdt).getSdtContent().getContent().add(tc);
        } else {
            ((SdtElement)sdt).getSdtContent().getContent().clear();
        }
        return newContent;
    }

    private List<Object> cloneRepeatSdt(Object sdt, String xpathBase, int numRepeats) {
        ArrayList<Object> newContent = new ArrayList<Object>();
        SdtPr sdtPr = OpenDoPEHandler.getSdtPr(sdt);
        log.debug(XmlUtils.marshaltoString((Object)sdtPr, true, true));
        CTDataBinding binding = sdtPr.getDataBinding();
        if (binding != null) {
            sdtPr.getRPrOrAliasOrLock().remove(binding);
        }
        this.emptyRepeatTagValue(sdtPr.getTag());
        for (int i = 0; i < numRepeats; ++i) {
            if (i > 0) {
                sdtPr.setId();
            }
            newContent.add(XmlUtils.deepCopy(sdt));
        }
        return newContent;
    }

    private void emptyRepeatTagValue(Tag tag) {
        if (tag == null) {
            log.warn("No tag");
            return;
        }
        String tagVal = tag.getVal();
        Pattern stripRepeatArgPattern = Pattern.compile("(.*od:repeat=)([^&]*)(.*)");
        Matcher stripPatternMatcher = stripRepeatArgPattern.matcher(tagVal);
        if (!stripPatternMatcher.matches()) {
            log.error("Cannot find repeat tag in sdtPr/tag while processing repeat; something is wrong with " + tagVal);
            return;
        }
        String emptyRepeatValue = "od:rptd=" + stripPatternMatcher.group(2) + stripPatternMatcher.group(3);
        tag.setVal(emptyRepeatValue);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processDescendantBindings(Object sdt, String xpathBase, int index) {
        SdtPr sdtPr = OpenDoPEHandler.getSdtPr(sdt);
        sdtPr.setId();
        CTDataBinding binding = sdtPr.getDataBinding();
        String thisXPath = null;
        String conditionId = null;
        String repeatId = null;
        String bindingId = null;
        Xpaths.Xpath xpathObj = null;
        HashMap<Object, Object> map = null;
        Tag tag = sdtPr.getTag();
        map = tag == null ? new HashMap() : QueryString.parseQueryString(tag.getVal(), true);
        if (binding == null) {
            conditionId = (String)map.get(BINDING_ROLE_CONDITIONAL);
            repeatId = (String)map.get(BINDING_ROLE_REPEAT);
            if (conditionId != null) {
                this.processDescendantCondition(sdt, xpathBase, index, tag);
                return;
            }
            if (repeatId != null) {
                xpathObj = this.xpathsMap.get(repeatId);
                thisXPath = xpathObj.getDataBinding().getXpath();
            } else {
                if (!(map.containsKey(BINDING_CONTENTTYPE) || map.containsKey(BINDING_HANDLER) || map.containsKey(BINDING_PROGID))) {
                    log.warn("couldn't find binding or bindingrole!");
                    return;
                }
                xpathObj = this.xpathsMap.get(map.get(BINDING_ROLE_XPATH));
                thisXPath = xpathObj.getDataBinding().getXpath();
            }
        } else {
            thisXPath = binding.getXpath();
            bindingId = (String)map.get(BINDING_ROLE_XPATH);
            try {
                xpathObj = this.xpathsMap.get(bindingId);
            }
            catch (InputIntegrityException iie) {
                log.warn(iie.getMessage());
            }
            if (xpathObj == null) {
                log.warn("No XPaths part object for " + binding.getXpath());
            } else if (!thisXPath.equals(xpathObj.getDataBinding().getXpath())) {
                log.error("XPaths didn't match for id " + bindingId + ": \n\r    " + thisXPath + "\n\rcf. " + xpathObj.getDataBinding().getXpath());
            }
        }
        String newPath = XPathEnhancerParser.enhanceXPath(xpathBase, index + 1, thisXPath);
        if (log.isDebugEnabled() && !thisXPath.equals(newPath)) {
            log.debug("xpath prefix enhanced " + thisXPath + " to " + newPath);
        }
        if (binding == null) {
            if (repeatId != null) {
                Xpaths.Xpath newXPathObj = this.createNewXPathObject(newPath, xpathObj, index);
                map.put(BINDING_ROLE_REPEAT, newXPathObj.getId());
                tag.setVal(QueryString.create(map));
                return;
            }
            if (!map.containsKey(BINDING_CONTENTTYPE) && !map.containsKey(BINDING_HANDLER)) {
                if (!map.containsKey(BINDING_PROGID)) return;
            }
            Xpaths.Xpath newXPathObj = this.createNewXPathObject(newPath, xpathObj, index);
            map.put(BINDING_ROLE_XPATH, newXPathObj.getId());
            tag.setVal(QueryString.create(map));
            return;
        }
        binding.setXpath(newPath);
        if (xpathObj == null) {
            log.debug("Not setting tag");
            return;
        }
        Xpaths.Xpath newXPathObj = this.createNewXPathObject(newPath, xpathObj, index);
        map.put(BINDING_ROLE_XPATH, newXPathObj.getId());
        tag.setVal(QueryString.create(map));
    }

    private void processDescendantCondition(Object sdt, String xpathBase, int index, Tag tag) {
        Condition c = null;
        HashMap<String, String> map = QueryString.parseQueryString(tag.getVal(), true);
        String conditionId = map.get(BINDING_ROLE_CONDITIONAL);
        if (conditionId != null) {
            c = this.conditionsMap.get(conditionId);
            if (c == null) {
                log.error("Missing condition " + conditionId);
                throw new InputIntegrityException("Required condition '" + conditionId + "' is missing");
            }
            log.debug("Using condition" + XmlUtils.marshaltoString((Object)c, true, true));
            Condition newCondition = c.repeat(xpathBase, index, this.conditionsMap, this.xpathsMap);
            map.put(BINDING_ROLE_CONDITIONAL, newCondition.getId());
            tag.setVal(QueryString.create(map));
        }
    }

    private Xpaths.Xpath createNewXPathObject(String newPath, Xpaths.Xpath xpathObj, int index) {
        Xpaths.Xpath newXPathObj = new Xpaths.Xpath();
        String newXPathId = xpathObj.getId() + "_" + index;
        newXPathObj.setId(newXPathId);
        Xpaths.Xpath.DataBinding dataBinding = new Xpaths.Xpath.DataBinding();
        newXPathObj.setDataBinding(dataBinding);
        dataBinding.setXpath(newPath);
        dataBinding.setStoreItemID(xpathObj.getDataBinding().getStoreItemID());
        dataBinding.setPrefixMappings(xpathObj.getDataBinding().getPrefixMappings());
        if (this.xpathsMap.put(newXPathId, newXPathObj) != null) {
            log.error("New xpath entry overwrites existing xpath " + newXPathId);
        }
        return newXPathObj;
    }

    public static SdtPr getSdtPr(Object o) {
        if (o instanceof SdtBlock) {
            return ((SdtBlock)o).getSdtPr();
        }
        if (o instanceof SdtRun) {
            return ((SdtRun)o).getSdtPr();
        }
        if (o instanceof CTSdtRow) {
            return ((CTSdtRow)o).getSdtPr();
        }
        if (o instanceof CTSdtCell) {
            return ((CTSdtCell)o).getSdtPr();
        }
        log.warn("TODO: Handle " + o.getClass().getName());
        return null;
    }

    private List<Node> xpathGetNodes(Map<String, CustomXmlPart> customXmlDataStorageParts, String storeItemId, String xpath, String prefixMappings) {
        CustomXmlPart part = customXmlDataStorageParts.get(storeItemId.toLowerCase());
        if (part == null) {
            log.error("Couldn't locate part by storeItemId " + storeItemId);
            return null;
        }
        try {
            return part.xpathGetNodes(xpath, prefixMappings);
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DeepTraversor
    implements TraversalUtil.Callback {
        int index = 0;
        String xpathBase = null;

        DeepTraversor() {
        }

        @Override
        public List<Object> apply(Object o) {
            if (o instanceof SdtBlock || o instanceof SdtRun || o instanceof CTSdtRow || o instanceof CTSdtCell) {
                OpenDoPEHandler.this.processDescendantBindings(o, this.xpathBase, this.index);
            }
            return null;
        }

        @Override
        public void walkJAXBElements(Object parent) {
            List<Object> children = this.getChildren(parent);
            if (children != null) {
                for (Object o : children) {
                    o = XmlUtils.unwrap(o);
                    this.apply(o);
                    if (!this.shouldTraverse(o)) continue;
                    this.walkJAXBElements(o);
                }
            }
        }

        @Override
        public List<Object> getChildren(Object o) {
            return TraversalUtil.getChildrenImpl(o);
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ShallowTraversor
    implements TraversalUtil.Callback {
        WordprocessingMLPackage wordMLPackage;

        private ShallowTraversor() {
        }

        @Override
        public List<Object> apply(Object wrapped) throws RuntimeException {
            Object o = XmlUtils.unwrap(wrapped);
            if (o instanceof SdtBlock || o instanceof SdtRun || o instanceof CTSdtRow || o instanceof CTSdtCell) {
                SdtPr sdtPr = OpenDoPEHandler.getSdtPr(o);
                if (sdtPr.getDataBinding() == null) {
                    return OpenDoPEHandler.this.processBindingRoleIfAny(this.wordMLPackage, o);
                }
                if (OpenDoPEHandler.this.getW15RepeatingSection(sdtPr) != null) {
                    return OpenDoPEHandler.this.processW15Repeat(o, this.wordMLPackage.getCustomXmlDataStorageParts());
                }
            }
            ArrayList<Object> newContent = new ArrayList<Object>();
            newContent.add(wrapped);
            return newContent;
        }

        @Override
        public boolean shouldTraverse(Object o) {
            return true;
        }

        @Override
        public List<Object> getChildren(Object o) {
            return TraversalUtil.getChildrenImpl(o);
        }

        @Override
        public void walkJAXBElements(Object parent) {
            ArrayList<Object> newChildren = new ArrayList<Object>();
            Object parentUnwrapped = XmlUtils.unwrap(parent);
            List<Object> children = this.getChildren(parentUnwrapped);
            if (children == null) {
                log.debug("no children: " + parentUnwrapped.getClass().getName());
                return;
            }
            for (Object o : children) {
                newChildren.addAll(this.apply(o));
            }
            TraversalUtil.replaceChildren(parentUnwrapped, newChildren);
            children = this.getChildren(parentUnwrapped);
            if (children == null) {
                log.debug("no children: " + parentUnwrapped.getClass().getName());
            } else {
                for (Object o : children) {
                    if (!this.shouldTraverse(o)) continue;
                    this.walkJAXBElements(o);
                }
            }
        }
    }
}

