/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.model.properties;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.docx4j.Docx4jProperties;
import org.docx4j.XmlUtils;
import org.docx4j.model.properties.AdHocProperty;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.paragraph.Bidi;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.model.properties.paragraph.Justification;
import org.docx4j.model.properties.paragraph.KeepNext;
import org.docx4j.model.properties.paragraph.LineSpacing;
import org.docx4j.model.properties.paragraph.NumberingProperty;
import org.docx4j.model.properties.paragraph.OutlineLevel;
import org.docx4j.model.properties.paragraph.PBorderBottom;
import org.docx4j.model.properties.paragraph.PBorderLeft;
import org.docx4j.model.properties.paragraph.PBorderRight;
import org.docx4j.model.properties.paragraph.PBorderTop;
import org.docx4j.model.properties.paragraph.PShading;
import org.docx4j.model.properties.paragraph.PageBreakBefore;
import org.docx4j.model.properties.paragraph.SpaceAfter;
import org.docx4j.model.properties.paragraph.SpaceBefore;
import org.docx4j.model.properties.paragraph.Tabs;
import org.docx4j.model.properties.paragraph.TextAlignmentVertical;
import org.docx4j.model.properties.run.Bold;
import org.docx4j.model.properties.run.FontColor;
import org.docx4j.model.properties.run.FontSize;
import org.docx4j.model.properties.run.HighlightColor;
import org.docx4j.model.properties.run.Italics;
import org.docx4j.model.properties.run.RBorder;
import org.docx4j.model.properties.run.RShading;
import org.docx4j.model.properties.run.Strike;
import org.docx4j.model.properties.run.TextDirection;
import org.docx4j.model.properties.run.Underline;
import org.docx4j.model.properties.run.VerticalAlignment;
import org.docx4j.model.properties.table.BorderBottom;
import org.docx4j.model.properties.table.BorderLeft;
import org.docx4j.model.properties.table.BorderRight;
import org.docx4j.model.properties.table.BorderTop;
import org.docx4j.model.properties.table.CellMarginBottom;
import org.docx4j.model.properties.table.CellMarginLeft;
import org.docx4j.model.properties.table.CellMarginRight;
import org.docx4j.model.properties.table.CellMarginTop;
import org.docx4j.model.properties.table.tc.Shading;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.wml.CTTblPrBase;
import org.docx4j.wml.CTTblStylePr;
import org.docx4j.wml.Highlight;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.TblBorders;
import org.docx4j.wml.TcMar;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TcPrInner;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.css.CSSValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyFactory {
    protected static Logger log = LoggerFactory.getLogger(PropertyFactory.class);
    private static Boolean useHIghlightInRPr = null;

    public static List<Property> createProperties(CTTblPrBase tblPr) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if ((tblPr.getJc() == null || !tblPr.getJc().getVal().equals((Object)JcEnumeration.CENTER) && !tblPr.getJc().getVal().equals((Object)JcEnumeration.RIGHT)) && tblPr.getTblInd() != null) {
            properties.add(new org.docx4j.model.properties.table.Indent(tblPr.getTblInd()));
        }
        if (tblPr.getTblBorders() != null) {
            TblBorders tblBorders = tblPr.getTblBorders();
            if (tblBorders.getTop() != null) {
                properties.add(new BorderTop(tblBorders.getTop()));
            }
            if (tblBorders.getBottom() != null) {
                properties.add(new BorderBottom(tblBorders.getBottom()));
            }
            if (tblBorders.getLeft() != null) {
                properties.add(new BorderLeft(tblBorders.getLeft()));
            }
            if (tblBorders.getRight() != null) {
                properties.add(new BorderRight(tblBorders.getRight()));
            }
        }
        if (tblPr.getTblW() != null) {
            if (tblPr.getTblW().getW() != null && tblPr.getTblW().getW() != BigInteger.ZERO) {
                properties.add(new AdHocProperty("table-layout", "fixed", "table-layout", "fixed"));
            } else if (tblPr.getTblW().getType() != null && tblPr.getTblW().getType().equals("auto")) {
                properties.add(new AdHocProperty("table-layout", "auto", "table-layout", "auto"));
            }
        }
        if (tblPr.getShd() != null) {
            properties.add(new Shading(tblPr.getShd()));
        }
        return properties;
    }

    public static List<Property> createProperties(List<CTTblStylePr> tblStylePrList) {
        ArrayList<Property> properties = new ArrayList<Property>();
        log.warn("TODO - implement for CTTblStylePr!");
        return properties;
    }

    public static List<Property> createProperties(TrPr trPr) {
        ArrayList<Property> properties = new ArrayList<Property>();
        log.warn("TODO - implement for TrPr!");
        return properties;
    }

    public static List<Property> createProperties(TcPr tcPr) {
        ArrayList<Property> properties = new ArrayList<Property>();
        PropertyFactory.createProperties(properties, tcPr);
        return properties;
    }

    public static void createPropertiesTable(List<Property> properties, TcPr tcPr) {
        if (tcPr.getTcBorders() != null) {
            TcPrInner.TcBorders tcBorders = tcPr.getTcBorders();
            if (tcBorders.getTop() != null) {
                properties.add(new BorderTop(tcBorders.getTop()));
            }
            if (tcBorders.getBottom() != null) {
                properties.add(new BorderBottom(tcBorders.getBottom()));
            }
            if (tcBorders.getLeft() != null) {
                properties.add(new BorderLeft(tcBorders.getLeft()));
            }
            if (tcBorders.getRight() != null) {
                properties.add(new BorderRight(tcBorders.getRight()));
            }
        }
        if (tcPr.getVAlign() != null) {
            properties.add(new org.docx4j.model.properties.table.tc.TextAlignmentVertical(tcPr.getVAlign()));
        }
        if (tcPr.getShd() != null) {
            properties.add(new Shading(tcPr.getShd()));
        }
    }

    public static void createProperties(List<Property> properties, TcPr tcPr) {
        PropertyFactory.createPropertiesTable(properties, tcPr);
        if (tcPr.getTcMar() != null) {
            TcMar tcMar = tcPr.getTcMar();
            if (tcMar.getTop() != null) {
                properties.add(new CellMarginTop(tcMar.getTop()));
            }
            if (tcMar.getBottom() != null) {
                properties.add(new CellMarginBottom(tcMar.getBottom()));
            }
            if (tcMar.getLeft() != null) {
                properties.add(new CellMarginLeft(tcMar.getLeft()));
            }
            if (tcMar.getRight() != null) {
                properties.add(new CellMarginRight(tcMar.getRight()));
            }
        }
    }

    public static List<Property> createProperties(OpcPackage wmlPackage, RPr rPr) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (rPr.getB() != null) {
            properties.add(new Bold(rPr.getB()));
        }
        if (rPr.getBdr() != null) {
            properties.add(new RBorder(rPr.getBdr()));
        }
        if (rPr.getColor() != null) {
            properties.add(new FontColor(rPr.getColor()));
        }
        if (rPr.getHighlight() != null) {
            properties.add(new HighlightColor(rPr.getHighlight()));
        }
        if (rPr.getI() != null) {
            properties.add(new Italics(rPr.getI()));
        }
        if (rPr.getRtl() != null) {
            properties.add(new TextDirection(rPr.getRtl()));
        }
        if (rPr.getShd() != null) {
            properties.add(new RShading(rPr.getShd()));
        }
        if (rPr.getStrike() != null) {
            properties.add(new Strike(rPr.getStrike()));
        }
        if (rPr.getSz() != null) {
            properties.add(new FontSize(rPr.getSz()));
        }
        if (rPr.getU() != null) {
            properties.add(new Underline(rPr.getU()));
        }
        if (rPr.getVertAlign() != null) {
            properties.add(new VerticalAlignment(rPr.getVertAlign()));
        }
        return properties;
    }

    public static List<Property> createProperties(OpcPackage wmlPackage, ParaRPr rPr) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (rPr.getB() != null) {
            properties.add(new Bold(rPr.getB()));
        }
        if (rPr.getColor() != null) {
            properties.add(new FontColor(rPr.getColor()));
        }
        if (rPr.getI() != null) {
            properties.add(new Italics(rPr.getI()));
        }
        if (rPr.getStrike() != null) {
            properties.add(new Strike(rPr.getStrike()));
        }
        if (rPr.getSz() != null) {
            properties.add(new FontSize(rPr.getSz()));
        }
        if (rPr.getU() != null) {
            properties.add(new Underline(rPr.getU()));
        }
        if (rPr.getVertAlign() != null) {
            properties.add(new VerticalAlignment(rPr.getVertAlign()));
        }
        return properties;
    }

    public static List<Property> createProperties(OpcPackage wmlPackage, PPr pPr) {
        ArrayList<Property> properties = new ArrayList<Property>();
        if (pPr.getBidi() != null) {
            properties.add(new Bidi(pPr.getBidi()));
        }
        if (pPr.getJc() != null) {
            properties.add(new Justification(pPr.getJc()));
        }
        if (pPr.getKeepNext() != null) {
            properties.add(new KeepNext(pPr.getKeepNext()));
        }
        Object indent = null;
        if (pPr.getNumPr() == null) {
            log.debug("No numPr.. ");
        } else {
            properties.add(new NumberingProperty(pPr.getNumPr()));
        }
        if (pPr.getInd() != null) {
            log.debug("Indent from ppr: " + XmlUtils.marshaltoString((Object)pPr.getInd(), true, true));
            properties.add(new Indent(pPr.getInd()));
        }
        if (pPr.getOutlineLvl() != null) {
            properties.add(new OutlineLevel(pPr.getOutlineLvl()));
        }
        if (pPr.getPageBreakBefore() != null) {
            properties.add(new PageBreakBefore(pPr.getPageBreakBefore()));
        }
        if (pPr.getPBdr() != null) {
            PPrBase.PBdr pBdr = pPr.getPBdr();
            if (pBdr.getTop() != null) {
                properties.add(new PBorderTop(pBdr.getTop()));
            }
            if (pBdr.getBottom() != null) {
                properties.add(new PBorderBottom(pBdr.getBottom()));
            }
            if (pBdr.getLeft() != null) {
                properties.add(new PBorderLeft(pBdr.getLeft()));
            }
            if (pBdr.getRight() != null) {
                properties.add(new PBorderRight(pBdr.getRight()));
            }
        }
        if (pPr.getShd() != null) {
            properties.add(new PShading(pPr.getShd()));
        }
        if (pPr.getSpacing() != null) {
            PPrBase.Spacing spacing = pPr.getSpacing();
            if (spacing.getBefore() != null) {
                properties.add(new SpaceBefore(spacing.getBefore()));
            }
            if (spacing.getAfter() != null) {
                properties.add(new SpaceAfter(spacing.getAfter()));
            }
            if (spacing.getLine() != null) {
                properties.add(new LineSpacing(spacing.getLine()));
            }
        }
        if (pPr.getTabs() != null) {
            properties.add(new Tabs(pPr.getTabs()));
        }
        if (pPr.getTextAlignment() != null) {
            properties.add(new TextAlignmentVertical(pPr.getTextAlignment()));
        }
        return properties;
    }

    private static boolean shouldUseHighlightInRPr() {
        if (useHIghlightInRPr == null) {
            useHIghlightInRPr = Docx4jProperties.getProperty("docx4j.model.properties.PropertyFactory.createPropertyFromCssName.background-color.useHighlightInRPr", false);
        }
        return useHIghlightInRPr;
    }

    public static Property createPropertyFromCssName(String name, CSSValue value) {
        try {
            if (name.equals("font-weight")) {
                return new Bold(value);
            }
            if (name.equals("font-style")) {
                return new Italics(value);
            }
            if (name.equals("text-decoration")) {
                if (value.getCssText().toLowerCase().equals("line-through") || value.getCssText().toLowerCase().equals("[line-through]")) {
                    return new Strike(value);
                }
                if (value.getCssText().toLowerCase().equals("underline") || value.getCssText().toLowerCase().equals("[underline]")) {
                    return new Underline(value);
                }
                if (value.getCssText().toLowerCase().equals("none")) {
                    return null;
                }
                log.error("What to do for " + name + ":" + value.getCssText());
            } else {
                if (name.equals("color")) {
                    return new FontColor(value);
                }
                if (name.equals("font-size")) {
                    return new FontSize(value);
                }
                if (name.equals("background-color")) {
                    if (value == null || value.getCssText() == null || value.getCssText().trim().length() == 0) {
                        log.warn("Ignoring CSS property " + name + " with null or empty value");
                        return null;
                    }
                    if (value.getCssText().toLowerCase().equals("transparent")) {
                        return null;
                    }
                    if (PropertyFactory.shouldUseHighlightInRPr()) {
                        HighlightColor highlightColor = new HighlightColor(value);
                        if (((Highlight)highlightColor.getObject()).getVal() == null) {
                            return null;
                        }
                        return highlightColor;
                    }
                    return new RShading(value);
                }
                if (name.equals("vertical-align")) {
                    if (value.getCssText().equals("baseline")) {
                        return null;
                    }
                    return new VerticalAlignment(value);
                }
            }
            if (name.equals("margin-left")) {
                return new Indent(value);
            }
            if (name.equals("text-align")) {
                return new Justification(value);
            }
            if (name.equals("page-break-after")) {
                return new KeepNext(value);
            }
            if (name.equals("page-break-before")) {
                return new PageBreakBefore(value);
            }
            if (name.equals("vertical-align")) {
                return new TextAlignmentVertical(value);
            }
            if (name.equals("margin-bottom")) {
                return new SpaceAfter(value);
            }
            if (name.equals("line-height")) {
                return new LineSpacing(value);
            }
        }
        catch (UnsupportedOperationException uoe) {
            log.error("Can't create property from: " + name + ":" + value.getCssText());
            return null;
        }
        log.debug("How to handle: " + name + "?");
        return null;
    }

    public static Property createPropertyFromCssNameForPPr(String name, CSSValue value) {
        try {
            if (name.equals("background-color")) {
                if (value.getCssText().toLowerCase().equals("transparent")) {
                    return null;
                }
                if (PropertyFactory.simpleRGBCheck(value.getCssText())) {
                    return new PShading(value);
                }
            }
        }
        catch (UnsupportedOperationException uoe) {
            log.error("Can't create property from: " + name + ":" + value.getCssText());
            return null;
        }
        log.debug("How to handle: " + name + "?");
        return null;
    }

    private static boolean simpleRGBCheck(String cssText) {
        return cssText.contains("#") || cssText.contains("rgb");
    }
}

