/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.parts.WordprocessingML;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.docx4j.Docx4jProperties;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.PhysicalFonts;
import org.docx4j.fonts.fop.fonts.CustomFont;
import org.docx4j.fonts.fop.fonts.EncodingMode;
import org.docx4j.fonts.fop.fonts.FontLoader;
import org.docx4j.fonts.fop.fonts.FontResolver;
import org.docx4j.fonts.fop.fonts.FontSetup;
import org.docx4j.openpackaging.contenttype.ContentType;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObfuscatedFontPart
extends BinaryPart {
    private static Logger log = LoggerFactory.getLogger(ObfuscatedFontPart.class);
    File f;
    private static final String DOCX4J_USER_DIR = ".docx4all";
    private static final String TEMPORARY_FONT_DIR = "temporary embedded fonts";
    private static File tmpFontDir = null;
    static CharSequence target;
    static CharSequence replacement;

    public static String getTemporaryEmbeddedFontsDir() {
        if (tmpFontDir == null) {
            throw new RuntimeException("No dir configured for temp fonts!  Either set system property user.home to a writable dir, or configure docx4j property 'docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart.tmpFontDir'");
        }
        try {
            return tmpFontDir.getCanonicalPath();
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private static File getUserHome() {
        File userDir;
        String s = System.getProperty("user.home");
        if (s != null && (userDir = new File(s)).exists()) {
            return userDir;
        }
        return null;
    }

    public ObfuscatedFontPart(PartName partName) throws InvalidFormatException {
        super(partName);
        this.init();
    }

    public void init() {
        this.setContentType(new ContentType("application/vnd.openxmlformats-officedocument.obfuscatedFont"));
    }

    public PhysicalFont deObfuscate(String fontNameAsInTablePart, String fontFileName, String fontKey, String filenamePrefix) {
        byte[] fontData = this.getBytes();
        log.debug("bytes: " + fontData.length);
        log.info("deObfuscating '" + fontFileName + "' with fontkey: " + fontKey);
        String tmpString = fontKey.substring(1, fontKey.length() - 1);
        log.debug(tmpString);
        String guidString = tmpString.replace(target, replacement);
        log.debug(guidString);
        byte[] guidByteArray = new byte[16];
        for (int i = 0; i < guidByteArray.length; ++i) {
            guidByteArray[i] = ObfuscatedFontPart.fromHexString(guidString.substring(i * 2, i * 2 + 2));
        }
        for (int j = 0; j < 2; ++j) {
            for (int i = 0; i < 16; ++i) {
                int n = j * 16 + i;
                fontData[n] = (byte)(fontData[n] ^ guidByteArray[15 - i]);
            }
        }
        this.f = new File(tmpFontDir, filenamePrefix + "-" + fontFileName + ".ttf");
        this.f.deleteOnExit();
        String path = null;
        FileOutputStream fos = null;
        try {
            path = this.f.getCanonicalPath();
            fos = new FileOutputStream(this.f);
            fos.write(fontData);
            log.debug("wrote: " + fontData.length);
            fos.close();
        }
        catch (IOException e) {
            log.error("Problem with " + path);
            log.error(e.getMessage(), e);
        }
        FontResolver fontResolver = FontSetup.createMinimalFontResolver();
        if (log.isDebugEnabled()) {
            CustomFont customFont = null;
            try {
                log.debug("Loading from: " + path);
                String subFontName = null;
                boolean embedded = true;
                boolean useKerning = true;
                customFont = FontLoader.loadFont("file:" + path, subFontName, embedded, EncodingMode.AUTO, useKerning, fontResolver);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (customFont != null) {
                log.info("Successfully reloaded " + customFont.getFontName());
                if (customFont.isEmbeddable()) {
                    log.debug("confirmed embeddable");
                } else {
                    log.error("this embedded font claims it is not embeddable!");
                }
            }
        }
        try {
            List<PhysicalFont> fonts = PhysicalFonts.getPhysicalFont(fontNameAsInTablePart, new URL("file:" + path));
            return fonts == null || fonts.isEmpty() ? null : fonts.iterator().next();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte fromHexString(String hexStr) {
        byte firstNibble = Byte.parseByte(hexStr.substring(0, 1), 16);
        byte secondNibble = Byte.parseByte(hexStr.substring(1, 2), 16);
        int finalByte = secondNibble | firstNibble << 4;
        return (byte)finalByte;
    }

    protected static void deleteEmbeddedFontTempFiles(String filenamePrefix) {
        int count;
        for (File f : tmpFontDir.listFiles()) {
            if (!f.getName().startsWith(filenamePrefix)) continue;
            f.delete();
        }
        if (log.isWarnEnabled() && (count = tmpFontDir.listFiles().length) > 0) {
            try {
                log.warn(count + " files remain in " + tmpFontDir.getCanonicalPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            log.debug("Deleting  " + this.f.getName());
            this.f.delete();
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        finally {
            super.finalize();
        }
    }

    static {
        String tmpFontDirPath = Docx4jProperties.getProperty("docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart.tmpFontDir");
        if (tmpFontDirPath == null) {
            File userHome = ObfuscatedFontPart.getUserHome();
            if (userHome == null) {
                log.warn("No home dir found; consider setting property 'docx4j.openpackaging.parts.WordprocessingML.ObfuscatedFontPart.tmpFontDir'");
            } else {
                File docx4jUserDir = new File(userHome, DOCX4J_USER_DIR);
                docx4jUserDir.mkdir();
                tmpFontDir = new File(docx4jUserDir, TEMPORARY_FONT_DIR);
                tmpFontDir.mkdir();
            }
        } else {
            tmpFontDir = new File(tmpFontDirPath);
            if (!tmpFontDir.exists()) {
                log.info(tmpFontDirPath + " does not exist. Attempting to create..");
                tmpFontDir.mkdir();
            } else if (!tmpFontDir.isDirectory()) {
                log.info(tmpFontDirPath + " exists, but is not a directory!");
            }
        }
        target = new String("-").subSequence(0, 1);
        replacement = new String("").subSequence(0, 0);
    }
}

