/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.InlineArea;

public class LineArea
extends Area {
    private static final long serialVersionUID = 7670235908329290684L;
    private LineAdjustingInfo adjustingInfo = null;
    private List<InlineArea> inlineAreas = new ArrayList<InlineArea>();

    public LineArea() {
    }

    public LineArea(int alignment, int diff, int stretch, int shrink) {
        this.adjustingInfo = new LineAdjustingInfo(alignment, diff, stretch, shrink);
    }

    public void addChildArea(Area childArea) {
        if (childArea instanceof InlineArea) {
            this.addInlineArea((InlineArea)childArea);
            ((InlineArea)childArea).setParentArea(this);
        }
    }

    public void addInlineArea(InlineArea area) {
        this.inlineAreas.add(area);
    }

    public void setInlineAreas(List inlineAreas) {
        for (InlineArea ia : inlineAreas) {
            Area pa = ia.getParentArea();
            if (pa == null) {
                ia.setParentArea(this);
                continue;
            }
            assert (pa == this);
        }
        this.inlineAreas = inlineAreas;
    }

    public List getInlineAreas() {
        return this.inlineAreas;
    }

    public int getStartIndent() {
        if (this.hasTrait(Trait.START_INDENT)) {
            return this.getTraitAsInteger(Trait.START_INDENT);
        }
        return 0;
    }

    public int getEndIndent() {
        if (this.hasTrait(Trait.END_INDENT)) {
            return this.getTraitAsInteger(Trait.END_INDENT);
        }
        return 0;
    }

    public void updateExtentsFromChildren() {
        int ipd = 0;
        int bpd = 0;
        int len = this.inlineAreas.size();
        for (int i = 0; i < len; ++i) {
            ipd = Math.max(ipd, this.inlineAreas.get(i).getAllocIPD());
            bpd += this.inlineAreas.get(i).getAllocBPD();
        }
        this.setIPD(ipd);
        this.setBPD(bpd);
    }

    public void handleIPDVariation(int ipdVariation) {
        int si = this.getStartIndent();
        int ei = this.getEndIndent();
        switch (this.adjustingInfo.lineAlignment) {
            case 135: {
                this.addTrait(Trait.END_INDENT, ei - ipdVariation);
                break;
            }
            case 23: {
                this.addTrait(Trait.START_INDENT, si - ipdVariation / 2);
                this.addTrait(Trait.END_INDENT, ei - ipdVariation / 2);
                break;
            }
            case 39: {
                this.addTrait(Trait.START_INDENT, si - ipdVariation);
                break;
            }
            case 70: {
                this.adjustingInfo.variationFactor *= (float)(this.adjustingInfo.difference - ipdVariation) / (float)this.adjustingInfo.difference;
                this.adjustingInfo.difference -= ipdVariation;
                if (!this.adjustingInfo.bAddedToAreaTree) break;
                this.finish();
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
    }

    public void finish() {
        if (this.adjustingInfo.lineAlignment == 70) {
            if (log.isTraceEnabled()) {
                log.trace("Applying variation factor to justified line: " + this.adjustingInfo);
            }
            boolean bUnresolvedAreasPresent = false;
            int len = this.inlineAreas.size();
            for (int i = 0; i < len; ++i) {
                bUnresolvedAreasPresent |= this.inlineAreas.get(i).applyVariationFactor(this.adjustingInfo.variationFactor, this.adjustingInfo.availableStretch, this.adjustingInfo.availableShrink);
            }
            if (!bUnresolvedAreasPresent) {
                this.adjustingInfo = null;
            } else {
                if (!this.adjustingInfo.bAddedToAreaTree) {
                    this.adjustingInfo.bAddedToAreaTree = true;
                }
                this.adjustingInfo.variationFactor = 1.0;
            }
        }
    }

    private final class LineAdjustingInfo
    implements Serializable {
        private static final long serialVersionUID = -6103629976229458273L;
        private int lineAlignment;
        private int difference;
        private int availableStretch;
        private int availableShrink;
        private double variationFactor;
        private boolean bAddedToAreaTree;

        private LineAdjustingInfo(int alignment, int diff, int stretch, int shrink) {
            this.lineAlignment = alignment;
            this.difference = diff;
            this.availableStretch = stretch;
            this.availableShrink = shrink;
            this.variationFactor = 1.0;
            this.bAddedToAreaTree = false;
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": diff=" + this.difference + ", variation=" + this.variationFactor + ", stretch=" + this.availableStretch + ", shrink=" + this.availableShrink;
        }
    }
}

