/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx.cli;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import org.camunda.bpm.dmn.xlsx.StaticInputOutputDetectionStrategy;
import org.camunda.bpm.dmn.xlsx.XlsxConverter;
import org.camunda.bpm.model.dmn.Dmn;
import org.camunda.bpm.model.dmn.DmnModelInstance;

public class CommandLineConverter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Usage: java -jar ...jar [--inputs A,B,C,..] [--outputs D,E,F,...] path/to/file.xlsx path/to/outfile.dmn");
            System.out.println(sb.toString());
            return;
        }
        String inputFile = args[args.length - 2];
        String outputFile = args[args.length - 1];
        HashSet<String> inputs = null;
        HashSet<String> outputs = null;
        for (int i = 0; i < args.length - 2; ++i) {
            if ("--inputs".equals(args[i])) {
                inputs = new HashSet<String>();
                inputs.addAll(Arrays.asList(args[i + 1].split(",")));
            }
            if (!"--outputs".equals(args[i])) continue;
            outputs = new HashSet<String>();
            outputs.addAll(Arrays.asList(args[i + 1].split(",")));
        }
        XlsxConverter converter = new XlsxConverter();
        if (inputs != null && outputs != null) {
            StaticInputOutputDetectionStrategy ioStrategy = new StaticInputOutputDetectionStrategy(inputs, outputs);
            converter.setIoDetectionStrategy(ioStrategy);
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(inputFile);
                DmnModelInstance dmnModelInstance = converter.convert(fileInputStream);
                fileOutputStream = new FileOutputStream(outputFile);
                Dmn.writeModelToStream(fileOutputStream, dmnModelInstance);
            }
            finally {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        catch (Exception e) {
            System.out.println("Could not convert file: " + e.getMessage());
            e.printStackTrace(System.out);
        }
    }
}

