/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx.elements;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xlsx4j.sml.Cell;

public class IndexedCell {
    public static final Pattern CELL_REF_PATTERN = Pattern.compile("([A-Z]+)([0-9]+)");
    protected Cell cell;
    protected String column;
    protected int row;

    public IndexedCell(Cell cell) {
        this.cell = cell;
        String cellReference = cell.getR();
        Matcher matcher = CELL_REF_PATTERN.matcher(cellReference);
        boolean matches = matcher.matches();
        if (!matches) {
            throw new RuntimeException("Cannot parse cell reference " + cellReference);
        }
        this.column = matcher.group(1);
        this.row = Integer.parseInt(matcher.group(2));
    }

    public Cell getCell() {
        return this.cell;
    }

    public String getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }
}

