/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.dmn.xlsx.elements;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.camunda.bpm.dmn.xlsx.elements.IndexedCell;
import org.camunda.bpm.model.dmn.instance.Input;
import org.camunda.bpm.model.dmn.instance.Output;

public class IndexedDmnColumns {
    protected Map<Input, IndexedCell> headerCellsByInput = new HashMap<Input, IndexedCell>();
    protected Map<Output, IndexedCell> headerCellsByOutput = new HashMap<Output, IndexedCell>();
    protected List<Input> orderedInputs = new ArrayList<Input>();
    protected List<Output> orderedOutputs = new ArrayList<Output>();

    public List<Input> getOrderedInputs() {
        return this.orderedInputs;
    }

    public List<Output> getOrderedOutputs() {
        return this.orderedOutputs;
    }

    public String getXlsxColumn(Input input) {
        IndexedCell headerCell = this.headerCellsByInput.get(input);
        return headerCell.getColumn();
    }

    public String getXlsxColumn(Output output) {
        IndexedCell headerCell = this.headerCellsByOutput.get(output);
        return headerCell.getColumn();
    }

    public void addInput(IndexedCell cell, Input input) {
        this.orderedInputs.add(input);
        this.headerCellsByInput.put(input, cell);
    }

    public void addOutput(IndexedCell cell, Output output) {
        this.orderedOutputs.add(output);
        this.headerCellsByOutput.put(output, cell);
    }
}

