/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.util.JAXBResult;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.docx4j.Docx4jProperties;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JAXBAssociation;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.jaxb.NamespacePrefixMapperUtils;
import org.docx4j.jaxb.NamespacePrefixMappings;
import org.docx4j.jaxb.XPathBinderAssociationIsPartialException;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.utils.XPathFactoryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtils {
    private static Logger log = LoggerFactory.getLogger(XmlUtils.class);
    public static String TRANSFORMER_FACTORY_PROCESSOR_XALAN = "org.apache.xalan.processor.TransformerFactoryImpl";
    private static TransformerFactory transformerFactory;
    private static final DocumentBuilderFactory documentBuilderFactory;

    public static TransformerFactory getTransformerFactory() {
        return transformerFactory;
    }

    @Deprecated
    public static DocumentBuilderFactory getDocumentBuilderFactory() {
        return documentBuilderFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DocumentBuilder getNewDocumentBuilder() {
        DocumentBuilderFactory documentBuilderFactory = XmlUtils.documentBuilderFactory;
        synchronized (documentBuilderFactory) {
            try {
                return XmlUtils.documentBuilderFactory.newDocumentBuilder();
            }
            catch (ParserConfigurationException e) {
                log.error(e.getMessage(), e);
                return null;
            }
        }
    }

    private static void instantiateTransformerFactory() {
        String originalSystemProperty = System.getProperty("javax.xml.transform.TransformerFactory");
        try {
            System.setProperty("javax.xml.transform.TransformerFactory", TRANSFORMER_FACTORY_PROCESSOR_XALAN);
            transformerFactory = TransformerFactory.newInstance();
            if (originalSystemProperty == null) {
                System.clearProperty("javax.xml.transform.TransformerFactory");
            } else {
                System.setProperty("javax.xml.transform.TransformerFactory", originalSystemProperty);
            }
        }
        catch (TransformerFactoryConfigurationError e) {
            log.warn("Xalan jar missing from classpath; xslt not supported");
            if (originalSystemProperty == null) {
                System.clearProperty("javax.xml.transform.TransformerFactory");
            } else {
                System.setProperty("javax.xml.transform.TransformerFactory", originalSystemProperty);
            }
            transformerFactory = TransformerFactory.newInstance();
        }
        LoggingErrorListener errorListener = new LoggingErrorListener(false);
        transformerFactory.setErrorListener(errorListener);
    }

    public static Object unwrap(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof JAXBElement) {
            log.debug("Unwrapped " + ((JAXBElement)o).getDeclaredType().getName());
            log.debug("name: " + ((JAXBElement)o).getName());
            return ((JAXBElement)o).getValue();
        }
        return o;
    }

    public static String JAXBElementDebug(JAXBElement o) {
        String prefix = null;
        if (o.getName().getNamespaceURI() != null) {
            try {
                prefix = NamespacePrefixMapperUtils.getPreferredPrefix(o.getName().getNamespaceURI(), null, false);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
        if (prefix != null) {
            return prefix + ':' + o.getName().getLocalPart() + " is a javax.xml.bind.JAXBElement; it has declared type " + o.getDeclaredType().getName();
        }
        return o.getName() + " is a javax.xml.bind.JAXBElement; it has declared type " + o.getDeclaredType().getName();
    }

    public static JAXBElement<?> getListItemByQName(List<JAXBElement<?>> list, QName name) {
        for (JAXBElement<?> el : list) {
            if (!el.getName().equals(name)) continue;
            return el;
        }
        return null;
    }

    public static Object unmarshal(InputStream is) throws JAXBException {
        return XmlUtils.unmarshal(is, Context.jc);
    }

    public static Object unmarshal(InputStream is, JAXBContext jc) throws JAXBException {
        XMLInputFactory xif = XMLInputFactory.newInstance();
        xif.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        xif.setProperty("javax.xml.stream.supportDTD", false);
        XMLStreamReader xsr = null;
        try {
            xsr = xif.createXMLStreamReader(is);
        }
        catch (XMLStreamException e) {
            throw new JAXBException((Throwable)e);
        }
        Object o = null;
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        o = u.unmarshal(xsr);
        return o;
    }

    public static Object unmarshalString(String str) throws JAXBException {
        return XmlUtils.unmarshalString(str, Context.jc);
    }

    public static Object unmarshalString(String str, JAXBContext jc, Class declaredType) throws JAXBException {
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        JAXBElement o = u.unmarshal((Source)new StreamSource(new StringReader(str)), declaredType);
        if (o instanceof JAXBElement) {
            return o.getValue();
        }
        return o;
    }

    public static Object unmarshalString(String str, JAXBContext jc) throws JAXBException {
        log.debug("Unmarshalling '" + str + "'");
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        return u.unmarshal((Source)new StreamSource(new StringReader(str)));
    }

    public static Object unmarshal(Node n) throws JAXBException {
        Unmarshaller u = Context.jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        return u.unmarshal(n);
    }

    public static Object unmarshal(Node n, JAXBContext jc, Class declaredType) throws JAXBException {
        Unmarshaller u = jc.createUnmarshaller();
        u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
        JAXBElement o = u.unmarshal(n, declaredType);
        if (o instanceof JAXBElement) {
            return o.getValue();
        }
        return o;
    }

    public static Object unmarshallFromTemplate(String wmlTemplateString, HashMap<String, String> mappings) throws JAXBException {
        return XmlUtils.unmarshallFromTemplate(wmlTemplateString, mappings, Context.jc);
    }

    public static Object unmarshallFromTemplate(String wmlTemplateString, HashMap<String, String> mappings, JAXBContext jc) throws JAXBException {
        String wmlString = XmlUtils.replace(wmlTemplateString, 0, new StringBuilder(), mappings).toString();
        log.debug("Results of substitution: " + wmlString);
        return XmlUtils.unmarshalString(wmlString, jc);
    }

    public static Object unmarshallFromTemplate(String wmlTemplateString, HashMap<String, String> mappings, JAXBContext jc, Class<?> declaredType) throws JAXBException {
        String wmlString = XmlUtils.replace(wmlTemplateString, 0, new StringBuilder(), mappings).toString();
        return XmlUtils.unmarshalString(wmlString, jc, declaredType);
    }

    private static StringBuilder replace(String wmlTemplateString, int offset, StringBuilder strB, HashMap<String, String> mappings) {
        int startKey = wmlTemplateString.indexOf("${", offset);
        if (startKey == -1) {
            return strB.append(wmlTemplateString.substring(offset));
        }
        strB.append(wmlTemplateString.substring(offset, startKey));
        int keyEnd = wmlTemplateString.indexOf(125, startKey);
        String key = wmlTemplateString.substring(startKey + 2, keyEnd);
        String val = mappings.get(key);
        if (val == null) {
            log.warn("Invalid key '" + key + "' or key not mapped to a value");
            strB.append(key);
        } else {
            strB.append(val);
        }
        return XmlUtils.replace(wmlTemplateString, keyEnd + 1, strB, mappings);
    }

    public static String marshaltoString(Object o) {
        JAXBContext jc = Context.jc;
        return XmlUtils.marshaltoString(o, true, true, jc);
    }

    public static String marshaltoString(Object o, JAXBContext jc) {
        return XmlUtils.marshaltoString(o, true, true, jc);
    }

    @Deprecated
    public static String marshaltoString(Object o, boolean suppressDeclaration) {
        JAXBContext jc = Context.jc;
        return XmlUtils.marshaltoString(o, suppressDeclaration, false, jc);
    }

    @Deprecated
    public static String marshaltoString(Object o, boolean suppressDeclaration, JAXBContext jc) {
        return XmlUtils.marshaltoString(o, suppressDeclaration, false, jc);
    }

    public static String marshaltoString(Object o, boolean suppressDeclaration, boolean prettyprint) {
        JAXBContext jc = Context.jc;
        return XmlUtils.marshaltoString(o, suppressDeclaration, prettyprint, jc);
    }

    public static String marshaltoString(Object o, boolean suppressDeclaration, boolean prettyprint, JAXBContext jc) {
        if (o == null) {
            return null;
        }
        try {
            Marshaller m = jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(m, NamespacePrefixMapperUtils.getPrefixMapper());
            if (prettyprint) {
                m.setProperty("jaxb.formatted.output", (Object)true);
            }
            if (suppressDeclaration) {
                m.setProperty("jaxb.fragment", (Object)true);
            }
            StringWriter sWriter = new StringWriter();
            m.marshal(o, (Writer)sWriter);
            return sWriter.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static String marshaltoString(Object o, boolean suppressDeclaration, boolean prettyprint, JAXBContext jc, String uri, String local, Class declaredType) {
        try {
            Marshaller m = jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(m, NamespacePrefixMapperUtils.getPrefixMapper());
            if (prettyprint) {
                m.setProperty("jaxb.formatted.output", (Object)true);
            }
            if (suppressDeclaration) {
                m.setProperty("jaxb.fragment", (Object)true);
            }
            StringWriter sWriter = new StringWriter();
            m.marshal((Object)new JAXBElement(new QName(uri, local), declaredType, o), (Writer)sWriter);
            return sWriter.toString();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream marshaltoInputStream(Object o, boolean suppressDeclaration, JAXBContext jc) {
        try {
            Marshaller m = jc.createMarshaller();
            NamespacePrefixMapperUtils.setProperty(m, NamespacePrefixMapperUtils.getPrefixMapper());
            if (suppressDeclaration) {
                m.setProperty("jaxb.fragment", (Object)true);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            m.marshal(o, (OutputStream)os);
            return new ByteArrayInputStream(os.toByteArray());
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document marshaltoW3CDomDocument(Object o) {
        return XmlUtils.marshaltoW3CDomDocument(o, Context.jc);
    }

    public static Document marshaltoW3CDomDocument(Object o, JAXBContext jc) {
        try {
            Marshaller marshaller = jc.createMarshaller();
            Document doc = XmlUtils.getNewDocumentBuilder().newDocument();
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            marshaller.marshal(o, (Node)doc);
            return doc;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static Document marshaltoW3CDomDocument(Object o, JAXBContext jc, String uri, String local, Class declaredType) {
        try {
            Marshaller marshaller = jc.createMarshaller();
            Document doc = XmlUtils.getNewDocumentBuilder().newDocument();
            NamespacePrefixMapperUtils.setProperty(marshaller, NamespacePrefixMapperUtils.getPrefixMapper());
            marshaller.marshal((Object)new JAXBElement(new QName(uri, local), declaredType, o), (Node)doc);
            return doc;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T deepCopy(T value) {
        return XmlUtils.deepCopy(value, Context.jc);
    }

    public static <T> T deepCopy(T value, JAXBContext jc) {
        if (value == null) {
            throw new IllegalArgumentException("Can't clone a null argument");
        }
        try {
            Object res;
            Class<?> valueClass;
            JAXBElement elem;
            if (value instanceof JAXBElement) {
                log.debug("deep copy of JAXBElement..");
                elem = (JAXBElement)value;
                valueClass = elem.getDeclaredType();
            } else {
                log.debug("deep copy of " + value.getClass().getName());
                Class<?> classT = value.getClass();
                elem = new JAXBElement(new QName("temp"), classT, value);
                valueClass = classT;
            }
            Marshaller mar = jc.createMarshaller();
            ByteArrayOutputStream bout = new ByteArrayOutputStream(256);
            mar.marshal((Object)elem, (OutputStream)bout);
            Unmarshaller unmar = jc.createUnmarshaller();
            if (log.isDebugEnabled()) {
                unmar.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            }
            elem = unmar.unmarshal((Source)new StreamSource(new ByteArrayInputStream(bout.toByteArray())), valueClass);
            if (value instanceof JAXBElement) {
                JAXBElement resT;
                res = resT = elem;
            } else {
                Object resT = elem.getValue();
                res = resT;
            }
            return (T)res;
        }
        catch (JAXBException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static String w3CDomNodeToString(Node n) {
        StringWriter sw = new StringWriter();
        try {
            Transformer serializer = transformerFactory.newTransformer();
            serializer.setOutputProperty("omit-xml-declaration", "yes");
            serializer.setOutputProperty("method", "xml");
            serializer.transform(new DOMSource(n), new StreamResult(sw));
            return sw.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Document neww3cDomDocument() {
        return XmlUtils.getNewDocumentBuilder().newDocument();
    }

    public static void appendXmlFragment(Document document, Node parent, String fragment) throws IOException, SAXException, ParserConfigurationException {
        Node fragmentNode = XmlUtils.getNewDocumentBuilder().parse(new InputSource(new StringReader(fragment))).getDocumentElement();
        fragmentNode = document.importNode(fragmentNode, true);
        parent.appendChild(fragmentNode);
    }

    public static JAXBResult prepareJAXBResult(JAXBContext context) throws Docx4JException {
        JAXBResult result;
        try {
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            result = new JAXBResult(unmarshaller);
        }
        catch (JAXBException e) {
            throw new Docx4JException("Error preparing empty JAXB result", (Exception)((Object)e));
        }
        return result;
    }

    public static void transform(Document doc, Templates template, Map<String, Object> transformParameters, Result result) throws Docx4JException {
        if (doc == null) {
            Throwable t = new Throwable();
            throw new Docx4JException("Null DOM Doc", t);
        }
        DOMSource domSource = new DOMSource(doc);
        XmlUtils.transform(domSource, template, transformParameters, result);
    }

    public static Templates getTransformerTemplate(Source xsltSource) throws TransformerConfigurationException {
        return transformerFactory.newTemplates(xsltSource);
    }

    public static void transform(Source source, Templates template, Map<String, Object> transformParameters, Result result) throws Docx4JException {
        Transformer xformer;
        if (source == null) {
            Throwable t = new Throwable();
            throw new Docx4JException("Null Source doc", t);
        }
        try {
            xformer = template.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new Docx4JException("The Transformer is ill-configured", e);
        }
        if (!xformer.getClass().getName().equals("org.apache.xalan.transformer.TransformerImpl")) {
            log.error("Detected " + xformer.getClass().getName() + ", but require org.apache.xalan.transformer.TransformerImpl. " + "Ensure Xalan 2.7.0 is on your classpath!");
        }
        LoggingErrorListener errorListener = new LoggingErrorListener(false);
        xformer.setErrorListener(errorListener);
        if (transformParameters != null) {
            for (Map.Entry<String, Object> pairs : transformParameters.entrySet()) {
                if (pairs.getKey() == null) {
                    log.info("Skipped null key");
                    continue;
                }
                if (pairs.getKey().equals("customXsltTemplates")) continue;
                if (pairs.getValue() == null) {
                    log.warn("parameter '" + pairs.getKey() + "' was null.");
                    continue;
                }
                xformer.setParameter(pairs.getKey(), pairs.getValue());
            }
        }
        try {
            xformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new Docx4JException("Cannot perform the transformation", e);
        }
    }

    public static List<Object> getJAXBNodesViaXPath(Binder<Node> binder, Object jaxbElement, String xpathExpr, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        List<JAXBAssociation> associations = XmlUtils.getJAXBAssociationsForXPath(binder, jaxbElement, xpathExpr, refreshXmlFirst);
        ArrayList<Object> resultList = new ArrayList<Object>();
        for (JAXBAssociation association : associations) {
            if (association.getJaxbObject() == null) {
                throw new XPathBinderAssociationIsPartialException("no object association for xpath result: " + association.getDomNode().getNodeName());
            }
            resultList.add(association.getJaxbObject());
        }
        return resultList;
    }

    public static List<JAXBAssociation> getJAXBAssociationsForXPath(Binder<Node> binder, Object jaxbElement, String xpathExpr, boolean refreshXmlFirst) throws JAXBException, XPathBinderAssociationIsPartialException {
        Node node;
        if (refreshXmlFirst) {
            Node node2 = (Node)binder.updateXML(jaxbElement);
        }
        if ((node = (Node)binder.getXMLNode(jaxbElement)) == null) {
            throw new XPathBinderAssociationIsPartialException("binder.getXMLNode returned null");
        }
        ArrayList<JAXBAssociation> resultList = new ArrayList<JAXBAssociation>();
        for (Node n : XmlUtils.xpath(node, xpathExpr)) {
            resultList.add(new JAXBAssociation(n, binder.getJAXBNode((Object)n)));
        }
        return resultList;
    }

    public static List<Node> xpath(Node node, String xpathExpression) {
        NamespacePrefixMappings nsContext = new NamespacePrefixMappings();
        return XmlUtils.xpath(node, xpathExpression, nsContext);
    }

    public static List<Node> xpath(Node node, String xpathExpression, NamespaceContext nsContext) {
        if (log.isDebugEnabled()) {
            log.debug(XmlUtils.w3CDomNodeToString(node));
        }
        XPath xpath = XPathFactoryUtil.newXPath();
        try {
            ArrayList<Node> result = new ArrayList<Node>();
            xpath.setNamespaceContext(nsContext);
            NodeList nl = (NodeList)xpath.evaluate(xpathExpression, node, XPathConstants.NODESET);
            log.info("evaluate returned " + nl.getLength());
            for (int i = 0; i < nl.getLength(); ++i) {
                result.add(nl.item(i));
            }
            return result;
        }
        catch (XPathExpressionException e) {
            log.error("Problem with '" + xpathExpression + "'", e);
            throw new RuntimeException(e);
        }
    }

    public static void treeCopy(NodeList sourceNodes, Node destParent) {
        for (int i = 0; i < sourceNodes.getLength(); ++i) {
            XmlUtils.treeCopy(sourceNodes.item(i), destParent);
        }
    }

    public static void treeCopy(Node sourceNode, Node destParent) {
        log.debug("node type" + sourceNode.getNodeType());
        switch (sourceNode.getNodeType()) {
            case 9: 
            case 11: {
                NodeList nodes = sourceNode.getChildNodes();
                if (nodes == null) break;
                for (int i = 0; i < nodes.getLength(); ++i) {
                    log.debug("child " + i + "of DOCUMENT_NODE");
                    XmlUtils.treeCopy(nodes.item(i), destParent);
                }
                break;
            }
            case 1: {
                log.debug("copying: " + sourceNode.getNodeName());
                Element newChild = destParent instanceof Document ? ((Document)destParent).createElementNS(sourceNode.getNamespaceURI(), sourceNode.getLocalName()) : (sourceNode.getNamespaceURI() != null ? destParent.getOwnerDocument().createElementNS(sourceNode.getNamespaceURI(), sourceNode.getLocalName()) : destParent.getOwnerDocument().createElement(sourceNode.getNodeName()));
                destParent.appendChild(newChild);
                NamedNodeMap atts = sourceNode.getAttributes();
                for (int i = 0; i < atts.getLength(); ++i) {
                    Attr attr = (Attr)atts.item(i);
                    if (attr.getNodeName().startsWith("xmlns:")) continue;
                    if (attr.getNamespaceURI() == null) {
                        newChild.setAttribute(attr.getName(), attr.getValue());
                        continue;
                    }
                    if (attr.getNamespaceURI().equals("http://www.w3.org/2000/xmlns/")) continue;
                    if (attr.getNodeName() != null) {
                        newChild.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getValue());
                        continue;
                    }
                    newChild.setAttributeNS(attr.getNamespaceURI(), attr.getLocalName(), attr.getValue());
                }
                NodeList children = sourceNode.getChildNodes();
                if (children == null) break;
                for (int i = 0; i < children.getLength(); ++i) {
                    XmlUtils.treeCopy(children.item(i), (Node)newChild);
                }
                break;
            }
            case 3: {
                if (destParent.getOwnerDocument() == null && destParent.getNodeName().equals("#document")) {
                    Text textNode = ((Document)destParent).createTextNode(sourceNode.getNodeValue());
                    destParent.appendChild(textNode);
                    break;
                }
                Text textNode = destParent.getOwnerDocument().createTextNode(sourceNode.getNodeValue());
                Node appended = destParent.appendChild(textNode);
            }
        }
    }

    static {
        XmlUtils.instantiateTransformerFactory();
        log.debug(System.getProperty("java.vendor"));
        log.debug(System.getProperty("java.version"));
        String sp = Docx4jProperties.getProperty("javax.xml.parsers.SAXParserFactory");
        if (sp != null) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", sp);
            log.info("Using " + sp + " (from docx4j.properties)");
        } else if (Docx4jProperties.getProperty("docx4j.javax.xml.parsers.SAXParserFactory.donotset", false)) {
            log.info("Not setting docx4j.javax.xml.parsers.SAXParserFactory");
        } else if (System.getProperty("java.version").startsWith("1.6") && System.getProperty("java.vendor").startsWith("Sun") || System.getProperty("java.version").startsWith("1.7") && System.getProperty("java.vendor").startsWith("Oracle") || System.getProperty("java.version").startsWith("1.8") && System.getProperty("java.vendor").startsWith("Oracle") || System.getProperty("java.version").startsWith("1.9") && System.getProperty("java.vendor").startsWith("Oracle") || System.getProperty("java.version").startsWith("1.7") && System.getProperty("java.vendor").startsWith("Jeroen")) {
            System.setProperty("javax.xml.parsers.SAXParserFactory", "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
            log.info("Using com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
        } else {
            log.warn("default SAXParserFactory property : " + System.getProperty("javax.xml.parsers.SAXParserFactory") + "\n Please consider using Xerces.");
        }
        String dbf = Docx4jProperties.getProperty("javax.xml.parsers.DocumentBuilderFactory");
        if (dbf != null) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", dbf);
            log.info("Using " + dbf + " (from docx4j.properties)");
        } else if (Docx4jProperties.getProperty("docx4j.javax.xml.parsers.DocumentBuilderFactory.donotset", false)) {
            log.info("Not setting docx4j.javax.xml.parsers.DocumentBuilderFactory");
        } else if (System.getProperty("java.version").startsWith("1.6") && System.getProperty("java.vendor").startsWith("Sun") || System.getProperty("java.version").startsWith("1.7") && System.getProperty("java.vendor").startsWith("Oracle") || System.getProperty("java.version").startsWith("1.8") && System.getProperty("java.vendor").startsWith("Oracle") || System.getProperty("java.version").startsWith("1.7") && System.getProperty("java.vendor").startsWith("Jeroen")) {
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
            log.info("Using com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        } else {
            log.warn("default DocumentBuilderFactory property: " + System.getProperty("javax.xml.parsers.DocumentBuilderFactory") + "\n Please consider using Xerces.");
        }
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), e);
        }
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setExpandEntityReferences(false);
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), e);
        }
        try {
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), e);
        }
    }

    static class LoggingErrorListener
    implements ErrorListener {
        boolean strict;

        public LoggingErrorListener(boolean strict) {
        }

        public void warning(TransformerException exception) {
            log.warn(exception.getMessage(), exception);
        }

        public void error(TransformerException exception) throws TransformerException {
            log.error(exception.getMessage(), exception);
            if (this.strict) {
                throw exception;
            }
        }

        public void fatalError(TransformerException exception) throws TransformerException {
            log.error(exception.getMessage(), exception);
            throw exception;
        }
    }
}

