/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBElement;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import org.docx4j.Docx4J;
import org.docx4j.TraversalUtil;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.FOSettings;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.common.ConversionSectionWrappers;
import org.docx4j.finders.SectPrFinder;
import org.docx4j.jaxb.Context;
import org.docx4j.model.structure.PageDimensions;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.packages.WordprocessingMLPackage;
import org.docx4j.wml.Document;
import org.docx4j.wml.HpsMeasure;
import org.docx4j.wml.ObjectFactory;
import org.docx4j.wml.P;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.R;
import org.docx4j.wml.RPr;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Text;
import org.plutext.jaxb.xslfo.LayoutMasterSet;
import org.plutext.jaxb.xslfo.SimplePageMaster;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FOPAreaTreeHelper {
    protected static Logger log = LoggerFactory.getLogger(FOPAreaTreeHelper.class);

    static void trimContent(WordprocessingMLPackage hfPkg) {
        SectPrFinder sf = new SectPrFinder(hfPkg.getMainDocumentPart());
        try {
            new TraversalUtil(hfPkg.getMainDocumentPart().getContents(), sf);
        }
        catch (Docx4JException e) {
            log.error(e.getMessage(), e);
        }
        List<SectPr> sectPrList = sf.getSectPrList();
        if (((Document)hfPkg.getMainDocumentPart().getJaxbElement()).getBody().getSectPr() != null) {
            sectPrList.remove(0);
        }
        P filler = FOPAreaTreeHelper.createFillerP();
        List<Object> contents = hfPkg.getMainDocumentPart().getContent();
        contents.clear();
        for (SectPr sectPr : sectPrList) {
            contents.add(filler);
            contents.add(filler);
            contents.add(filler);
            contents.add(filler);
            P p = Context.getWmlObjectFactory().createP();
            PPr ppr = Context.getWmlObjectFactory().createPPr();
            p.setPPr(ppr);
            ppr.setSectPr(sectPr);
            contents.add(p);
        }
        if (((Document)hfPkg.getMainDocumentPart().getJaxbElement()).getBody().getSectPr() != null) {
            contents.add(filler);
            contents.add(filler);
            contents.add(filler);
            contents.add(filler);
        }
    }

    private static P createFillerP() {
        ObjectFactory wmlObjectFactory = Context.getWmlObjectFactory();
        P p = wmlObjectFactory.createP();
        PPr ppr = wmlObjectFactory.createPPr();
        p.setPPr(ppr);
        ParaRPr pararpr = wmlObjectFactory.createParaRPr();
        PPrBase.Spacing pprbasespacing = wmlObjectFactory.createPPrBaseSpacing();
        ppr.setSpacing(pprbasespacing);
        pprbasespacing.setBefore(BigInteger.valueOf(800L));
        pprbasespacing.setAfter(BigInteger.valueOf(800L));
        R r = wmlObjectFactory.createR();
        p.getContent().add(r);
        RPr rpr = wmlObjectFactory.createRPr();
        r.setRPr(rpr);
        HpsMeasure hpsmeasure3 = wmlObjectFactory.createHpsMeasure();
        rpr.setSz(hpsmeasure3);
        hpsmeasure3.setVal(BigInteger.valueOf(96L));
        Text text = wmlObjectFactory.createText();
        JAXBElement<Text> textWrapped = wmlObjectFactory.createRT(text);
        r.getContent().add(textWrapped);
        text.setValue("BODY CONTENT");
        return p;
    }

    static org.w3c.dom.Document getAreaTreeViaFOP(WordprocessingMLPackage hfPkg, boolean useXSLT) throws Docx4JException, ParserConfigurationException, SAXException, IOException {
        FOSettings foSettings = Docx4J.createFOSettings();
        foSettings.setWmlPackage(hfPkg);
        foSettings.setApacheFopMime("application/X-fop-areatree");
        foSettings.setLayoutMasterSetCalculationInProgress(true);
        foSettings.getFeatures().remove("pp.common.deepcopy");
        if (log.isDebugEnabled()) {
            foSettings.setFoDumpFile(new File(System.getProperty("user.dir") + "/hf.fo"));
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        if (useXSLT) {
            Docx4J.toFO(foSettings, os, 1);
        } else {
            Docx4J.toFO(foSettings, os, 2);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
        DocumentBuilder builder = XmlUtils.getNewDocumentBuilder();
        return builder.parse(is);
    }

    static void calculateHFExtents(org.w3c.dom.Document areaTree, Map<String, Integer> headerBpda, Map<String, Integer> footerBpda) {
        if (log.isDebugEnabled()) {
            log.debug(XmlUtils.w3CDomNodeToString(areaTree));
        }
        for (int i = 0; i < areaTree.getDocumentElement().getChildNodes().getLength(); ++i) {
            Node pageSequence = areaTree.getDocumentElement().getChildNodes().item(i);
            if (!(pageSequence instanceof Element)) continue;
            if (!pageSequence.getLocalName().equals("pageSequence")) {
                log.error("Unexpected element: " + pageSequence.getLocalName());
                continue;
            }
            for (int j = 0; j < pageSequence.getChildNodes().getLength(); ++j) {
                Node pageViewport = pageSequence.getChildNodes().item(j);
                if (!(pageViewport instanceof Element)) continue;
                if (!pageViewport.getLocalName().equals("pageViewport")) {
                    log.error("Unexpected element: " + pageViewport.getLocalName());
                    continue;
                }
                String simplePageMasterName = ((Element)pageViewport).getAttribute("simple-page-master-name");
                log.debug("processing simple-page-master-name: " + simplePageMasterName);
                if (headerBpda.containsKey(simplePageMasterName)) {
                    log.debug(".. dupe .. ignore");
                    continue;
                }
                Element page = (Element)pageViewport.getFirstChild();
                for (int k = 0; k < page.getChildNodes().getLength(); ++k) {
                    Node regionViewport = page.getChildNodes().item(k);
                    if (!(regionViewport instanceof Element)) continue;
                    Element region = (Element)regionViewport.getFirstChild();
                    int bpda = 0;
                    if (region.getLocalName().equals("regionBefore") || region.getLocalName().equals("regionAfter")) {
                        for (int m = 0; m < region.getChildNodes().getLength(); ++m) {
                            Element block = (Element)region.getChildNodes().item(m);
                            if (block.getLocalName().equals("block")) {
                                try {
                                    bpda += Integer.parseInt(block.getAttribute("bpda"));
                                }
                                catch (NumberFormatException nfe) {
                                    log.error("For @bpda, \n" + XmlUtils.w3CDomNodeToString(block));
                                    log.error(nfe.getMessage(), nfe);
                                }
                                continue;
                            }
                            log.debug(simplePageMasterName + " - Unexpected element: " + block.getLocalName());
                        }
                    }
                    if (region.getLocalName().equals("regionBefore")) {
                        headerBpda.put(simplePageMasterName, bpda);
                        continue;
                    }
                    if (region.getLocalName().equals("regionAfter")) {
                        footerBpda.put(simplePageMasterName, bpda);
                        continue;
                    }
                    if (region.getLocalName().equals("regionBody")) continue;
                    log.error("unexpected region: " + region.getLocalName());
                }
            }
        }
    }

    static void adjustLayoutMasterSet(LayoutMasterSet layoutMasterSet, ConversionSectionWrappers conversionSectionWrappers, Map<String, Integer> headerBpda, Map<String, Integer> footerBpda) {
        List<ConversionSectionWrapper> sections = conversionSectionWrappers.getList();
        Object section = null;
        for (Object o : layoutMasterSet.getSimplePageMasterOrPageSequenceMaster()) {
            float required;
            float extraMargin;
            float totalHeight;
            if (!(o instanceof SimplePageMaster)) continue;
            SimplePageMaster spm = (SimplePageMaster)o;
            String simplePageMasterName = spm.getMasterName();
            int index = -1 + Integer.parseInt(simplePageMasterName.substring(1, simplePageMasterName.indexOf("-")));
            PageDimensions page = null;
            if (sections.get(index) == null) {
                log.error("Couldn't find section " + index + " from " + simplePageMasterName);
            } else {
                page = sections.get(index).getPageDimensions();
            }
            if (spm.getRegionBefore() != null) {
                Integer hBpdaMilliPts = headerBpda.get(simplePageMasterName);
                if (hBpdaMilliPts == null) {
                    log.error("No headerBpda for " + simplePageMasterName);
                } else {
                    float hBpdaPts = hBpdaMilliPts / 1000;
                    spm.getRegionBefore().setExtent(hBpdaPts + "pt");
                    spm.getRegionBody().setMarginTop(hBpdaPts + "pt");
                    totalHeight = (float)(page.getHeaderMargin() / 20) + hBpdaPts;
                    extraMargin = (float)(page.getPgMar().getTop().intValue() / 20) - totalHeight;
                    if (extraMargin > 0.0f) {
                        required = (page.getPgMar().getTop().intValue() - page.getHeaderMargin()) / 20;
                        spm.getRegionBody().setMarginTop(required + "pt");
                    }
                }
            }
            if (spm.getRegionAfter() == null) continue;
            Integer fBpdaMilliPts = footerBpda.get(simplePageMasterName);
            if (fBpdaMilliPts == null) {
                log.error("No footerBpda for " + simplePageMasterName);
                continue;
            }
            float fBpdaPts = fBpdaMilliPts / 1000;
            spm.getRegionAfter().setExtent(fBpdaPts + "pt");
            spm.getRegionBody().setMarginBottom(fBpdaPts + "pt");
            totalHeight = (float)(page.getFooterMargin() / 20) + fBpdaPts;
            extraMargin = (float)(page.getPgMar().getBottom().intValue() / 20) - totalHeight;
            if (!(extraMargin > 0.0f)) continue;
            required = (page.getPgMar().getBottom().intValue() - page.getFooterMargin()) / 20;
            spm.getRegionBody().setMarginBottom(required + "pt");
        }
    }
}

