/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import javax.xml.transform.TransformerException;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.Writer;
import org.docx4j.convert.out.common.writer.AbstractSymbolWriter;
import org.docx4j.fonts.PhysicalFont;
import org.docx4j.fonts.fop.fonts.Typeface;
import org.docx4j.wml.R;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class SymbolWriter
extends AbstractSymbolWriter {
    private static final Logger log = LoggerFactory.getLogger(SymbolWriter.class);

    public Node toNode(AbstractWmlConversionContext context, Object unmarshalledNode, Node modelContent, Writer.TransformState state, Document doc) throws TransformerException {
        R.Sym modelData = (R.Sym)unmarshalledNode;
        String fontName = modelData.getFont();
        String textValue = modelData.getChar();
        PhysicalFont pf = context.getWmlPackage().getFontMapper().get(fontName);
        char chValue = '\u0000';
        Typeface typeface = null;
        if (pf != null && (typeface = pf.getTypeface()) != null) {
            if (textValue.length() > 1) {
                try {
                    chValue = (char)Integer.parseInt(textValue, 16);
                }
                catch (NumberFormatException nfe) {
                    chValue = '\u0000';
                }
            } else {
                chValue = textValue.charAt(0);
            }
            if (chValue != '\u0000') {
                if (chValue > '\uf000') {
                    chValue = (char)(chValue - 61440);
                }
                if (typeface.mapChar(chValue) == '\u0000' && typeface.mapChar(chValue = (char)(chValue + 61440)) == '\u0000') {
                    chValue = '\u0000';
                }
                if (chValue != '\u0000') {
                    textValue = Character.toString(chValue);
                }
            }
        }
        Text theChar = doc.createTextNode(textValue);
        DocumentFragment docfrag = doc.createDocumentFragment();
        if (pf == null) {
            log.warn("No physical font present for:" + fontName);
            docfrag.appendChild(theChar);
        } else {
            Element foInline = doc.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
            docfrag.appendChild(foInline);
            foInline.setAttribute("font-family", pf.getName());
            foInline.appendChild(theChar);
        }
        return docfrag;
    }
}

