/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.convert.out.fo;

import java.util.List;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import org.docx4j.XmlUtils;
import org.docx4j.convert.out.common.AbstractWmlConversionContext;
import org.docx4j.convert.out.common.ConversionSectionWrapper;
import org.docx4j.convert.out.fo.FOConversionContext;
import org.docx4j.convert.out.fo.LayoutMasterSetBuilder;
import org.docx4j.jaxb.Context;
import org.docx4j.jaxb.JaxbValidationEventHandler;
import org.docx4j.model.PropertyResolver;
import org.docx4j.model.fields.FormattingSwitchHelper;
import org.docx4j.model.listnumbering.Emulator;
import org.docx4j.model.properties.Property;
import org.docx4j.model.properties.PropertyFactory;
import org.docx4j.model.properties.paragraph.Indent;
import org.docx4j.model.properties.paragraph.PBorderBottom;
import org.docx4j.model.properties.paragraph.PBorderTop;
import org.docx4j.model.properties.paragraph.PShading;
import org.docx4j.model.styles.StyleUtil;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.WordprocessingML.DocumentSettingsPart;
import org.docx4j.wml.CTPageNumber;
import org.docx4j.wml.CTSettings;
import org.docx4j.wml.CTTabStop;
import org.docx4j.wml.CTTwipsMeasure;
import org.docx4j.wml.JcEnumeration;
import org.docx4j.wml.PPr;
import org.docx4j.wml.PPrBase;
import org.docx4j.wml.ParaRPr;
import org.docx4j.wml.RPr;
import org.docx4j.wml.STTabJc;
import org.docx4j.wml.SectPr;
import org.docx4j.wml.Style;
import org.docx4j.wml.Tabs;
import org.docx4j.wml.TcPr;
import org.docx4j.wml.TrPr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.traversal.NodeIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltFOFunctions {
    private static Logger log = LoggerFactory.getLogger(XsltFOFunctions.class);

    public static DocumentFragment getLayoutMasterSetFragment(AbstractWmlConversionContext context) {
        return LayoutMasterSetBuilder.getLayoutMasterSetFragment(context);
    }

    public static DocumentFragment createBlockForSdt(FOConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults, String tag) {
        Node foBlock;
        DocumentFragment docfrag = XsltFOFunctions.createBlock(context, pPrNodeIt, pStyleVal, childResults, true);
        if (tag.equals("XSLT_Shd") && docfrag != null && (foBlock = docfrag.getFirstChild()) != null) {
            ((Element)foBlock).setAttribute("margin-top", "0in");
            ((Element)foBlock).setAttribute("margin-bottom", "0in");
        }
        return docfrag;
    }

    public static DocumentFragment createInlineForSdt(FOConversionContext context, NodeIterator rPrNodeIt, NodeIterator childResults, String tag) {
        DocumentFragment docfrag = XsltFOFunctions.createBlockForRPr(context, null, rPrNodeIt, childResults);
        return docfrag;
    }

    public static DocumentFragment createBlockForPPr(FOConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults) {
        DocumentFragment df = XsltFOFunctions.createBlock(context, pPrNodeIt, pStyleVal, childResults, false);
        Element block = (Element)df.getFirstChild();
        NodeList blockChildren = block.getChildNodes();
        for (int i = 0; i < blockChildren.getLength(); ++i) {
            Element inline;
            if (!(blockChildren.item(i) instanceof Element) || (inline = (Element)blockChildren.item(i)) == null || inline.getAttribute("direction") == null || !inline.getAttribute("direction").equals("rtl")) continue;
            inline.removeAttribute("direction");
            Element bidiOverride = df.getOwnerDocument().createElementNS("http://www.w3.org/1999/XSL/Format", "fo:bidi-override");
            bidiOverride.setAttribute("unicode-bidi", "embed");
            bidiOverride.setAttribute("direction", "rtl");
            block.replaceChild(bidiOverride, inline);
            bidiOverride.appendChild(inline);
        }
        if (XsltFOFunctions.foContainsElement(block, "leader")) {
            block.setAttribute("text-align-last", "justify");
        }
        return df;
    }

    private static boolean foContainsElement(Node sourceNode, String elementName) {
        switch (sourceNode.getNodeType()) {
            case 9: 
            case 11: {
                NodeList nodes = sourceNode.getChildNodes();
                if (nodes != null) {
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        if (!XsltFOFunctions.foContainsElement(nodes.item(i), elementName)) continue;
                        return true;
                    }
                }
                return false;
            }
            case 1: {
                Element el = (Element)sourceNode;
                if (el.getLocalName().equals(elementName)) {
                    System.out.println("Got " + elementName);
                    return true;
                }
                NodeList children = sourceNode.getChildNodes();
                if (children != null) {
                    for (int i = 0; i < children.getLength(); ++i) {
                        if (!XsltFOFunctions.foContainsElement(children.item(i), elementName)) continue;
                        return true;
                    }
                }
                return false;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    private static DocumentFragment createBlock(FOConversionContext context, NodeIterator pPrNodeIt, String pStyleVal, NodeIterator childResults, boolean sdt) {
        PropertyResolver propertyResolver = context.getPropertyResolver();
        Style defaultParagraphStyle = context.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false) != null ? context.getWmlPackage().getMainDocumentPart().getStyleDefinitionsPart(false).getDefaultParagraphStyle() : null;
        String defaultParagraphStyleId = defaultParagraphStyle == null ? "Normal" : defaultParagraphStyle.getStyleId();
        if (pStyleVal == null || pStyleVal.equals("")) {
            pStyleVal = defaultParagraphStyleId;
        }
        if (log.isDebugEnabled()) {
            log.debug("style '" + pStyleVal);
        }
        try {
            Node n;
            Element foBlockElement;
            PPr pPrDirect = null;
            PPr pPr = null;
            RPr rPr = null;
            RPr rPrParagraphMark = null;
            if (pPrNodeIt == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Here after all!!");
                }
                pPr = propertyResolver.getEffectivePPr(defaultParagraphStyleId);
                rPrParagraphMark = rPr = propertyResolver.getEffectiveRPr(defaultParagraphStyleId);
            } else {
                Node n2 = pPrNodeIt.nextNode();
                if (n2 == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("pPrNodeIt.nextNode() was null (ie there is no pPr in this p)");
                    }
                    pPr = propertyResolver.getEffectivePPr(defaultParagraphStyleId);
                    rPr = propertyResolver.getEffectiveRPr(defaultParagraphStyleId);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("P actual pPr: " + XmlUtils.w3CDomNodeToString(n2));
                    }
                    Unmarshaller u = Context.jc.createUnmarshaller();
                    u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
                    Object jaxb = u.unmarshal(n2);
                    pPrDirect = (PPr)jaxb;
                    pPr = propertyResolver.getEffectivePPr(pPrDirect);
                    if (pPr == null && log.isDebugEnabled()) {
                        log.debug("pPr null; obtained from: " + XmlUtils.w3CDomNodeToString(n2));
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("getting rPr for paragraph style");
                    }
                    rPr = propertyResolver.getEffectiveRPr(null, pPrDirect);
                    rPrParagraphMark = XmlUtils.deepCopy(rPr);
                    StyleUtil.apply(pPrDirect.getRPr(), rPrParagraphMark);
                }
            }
            if (log.isDebugEnabled() && pPr != null) {
                log.debug("P effective pPr: " + XmlUtils.marshaltoString((Object)pPr, true, true));
            }
            Document document = XmlUtils.getNewDocumentBuilder().newDocument();
            boolean indentHandledByNumbering = false;
            Element foListBlock = null;
            if (pPr != null && pPr.getNumPr() != null && pPr.getNumPr().getNumId() != null && pPr.getNumPr().getNumId().getVal().longValue() != 0L) {
                Emulator.ResultTriple triple;
                foListBlock = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-block");
                document.appendChild(foListBlock);
                if (pPr.getShd() != null) {
                    PShading pShading = new PShading(pPr.getShd());
                    pShading.setXslFO(foListBlock);
                }
                Element foListItem = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-item");
                foListBlock.appendChild(foListItem);
                Element foListItemLabel = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-item-label");
                foListItem.appendChild(foListItemLabel);
                Element foListItemLabelBody = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block");
                foListItemLabel.appendChild(foListItemLabelBody);
                Element foListItemBody = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:list-item-body");
                foListItem.appendChild(foListItemBody);
                foListItemBody.setAttribute("start-indent", "body-start()");
                if (pPrDirect != null && pPrDirect.getNumPr() != null) {
                    triple = Emulator.getNumber(context.getWmlPackage(), pStyleVal, pPrDirect.getNumPr().getNumId().getVal().toString(), pPrDirect.getNumPr().getIlvl().getVal().toString());
                } else {
                    PPrBase.NumPr.Ilvl ilvl = pPr.getNumPr().getIlvl();
                    String ilvlString = ilvl == null ? "0" : ilvl.getVal().toString();
                    triple = null;
                    if (pPr.getNumPr().getNumId() != null) {
                        triple = Emulator.getNumber(context.getWmlPackage(), pStyleVal, pPr.getNumPr().getNumId().getVal().toString(), ilvlString);
                    }
                }
                if (triple == null) {
                    log.warn("computed number ResultTriple was null");
                    if (log.isDebugEnabled()) {
                        foListItemLabelBody.setAttribute("color", "red");
                        foListItemLabelBody.setTextContent("null#");
                    }
                } else {
                    if (triple.getRPr() == null) {
                        if (pPr.getRPr() == null) {
                            XsltFOFunctions.setFont(context, foListItemLabelBody, pPr, rPr, triple.getNumString());
                        } else {
                            XsltFOFunctions.createFoAttributes(context.getWmlPackage(), rPrParagraphMark, foListItemLabel);
                            XsltFOFunctions.createFoAttributes(context.getWmlPackage(), rPrParagraphMark, foListItemBody);
                            XsltFOFunctions.setFont(context, foListItemLabelBody, pPr, rPrParagraphMark, triple.getNumString());
                        }
                    } else {
                        RPr actual = XmlUtils.deepCopy(triple.getRPr());
                        XsltFOFunctions.setFont(context, foListItemLabelBody, pPr, actual, triple.getNumString());
                        StyleUtil.apply(rPrParagraphMark, actual);
                        XsltFOFunctions.createFoAttributes(context.getWmlPackage(), actual, foListItemLabel);
                        XsltFOFunctions.createFoAttributes(context.getWmlPackage(), actual, foListItemBody);
                    }
                    int numChars = 1;
                    if (triple.getBullet() != null) {
                        foListItemLabelBody.setTextContent(triple.getBullet());
                    } else if (triple.getNumString() == null) {
                        log.debug("computed NumString was null!");
                        if (log.isDebugEnabled()) {
                            foListItemLabelBody.setAttribute("color", "red");
                            foListItemLabelBody.setTextContent("null#");
                        }
                        numChars = 0;
                    } else {
                        Text number = document.createTextNode(triple.getNumString());
                        foListItemLabelBody.appendChild(number);
                        numChars = triple.getNumString().length();
                    }
                    Indent indent = new Indent(pPrDirect.getInd(), triple.getIndent());
                    if (indent.isHanging()) {
                        indent.setXslFOListBlock(foListBlock, -1);
                    } else {
                        int numWidth = 90 * numChars;
                        int pdbs = XsltFOFunctions.getDistanceToNextTabStop(context, indent.getNumberPosition(), numWidth, pPrDirect.getTabs(), context.getWmlPackage().getMainDocumentPart().getDocumentSettingsPart());
                        indent.setXslFOListBlock(foListBlock, pdbs);
                    }
                    indentHandledByNumbering = true;
                }
                foBlockElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block");
                foListItemBody.appendChild(foBlockElement);
                if (log.isDebugEnabled()) {
                    log.debug("bare list result: " + XmlUtils.w3CDomNodeToString(foListBlock));
                }
            } else {
                foBlockElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:block");
                document.appendChild(foBlockElement);
            }
            if (pPr != null) {
                boolean ignoreBorders = !sdt;
                XsltFOFunctions.createFoAttributes(context.getWmlPackage(), pPr, foBlockElement, indentHandledByNumbering, ignoreBorders);
            }
            if (rPr != null) {
                if (foListBlock == null) {
                    XsltFOFunctions.createFoAttributes(context.getWmlPackage(), rPr, foBlockElement);
                } else {
                    XsltFOFunctions.createFoAttributes(context.getWmlPackage(), rPr, foListBlock);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("after createFoAttributes: " + XmlUtils.w3CDomNodeToString(foBlockElement));
            }
            if ((n = childResults.nextNode()).getChildNodes().getLength() == 0) {
                foBlockElement.setAttribute("white-space-treatment", "preserve");
                foBlockElement.setTextContent(" ");
            } else {
                XmlUtils.treeCopy(n, (Node)foBlockElement);
            }
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    protected static void setFont(FOConversionContext context, Element foListItemLabelBody, PPr pPr, RPr rPr, String text) {
        Attr attr;
        DocumentFragment result = (DocumentFragment)context.getRunFontSelector().fontSelector(pPr, rPr, text);
        System.out.println(XmlUtils.w3CDomNodeToString(result));
        if (result != null && result.getFirstChild() != null && (attr = ((Element)result.getFirstChild()).getAttributeNode("font-family")) != null) {
            foListItemLabelBody.setAttribute("font-family", attr.getValue());
        }
    }

    protected static int getDistanceToNextTabStop(FOConversionContext context, int pos, int numWidth, Tabs pprTabs, DocumentSettingsPart settings) {
        CTTwipsMeasure twips;
        boolean pdbs = false;
        int defaultTab = 360;
        if (pprTabs != null && pprTabs.getTab() != null && pprTabs.getTab().size() > 0) {
            for (CTTabStop tabStop : pprTabs.getTab()) {
                if (tabStop.getPos().intValue() <= pos + numWidth) continue;
                log.debug("tab stop: using specified");
                return tabStop.getPos().intValue() - pos;
            }
        }
        if (settings != null && ((CTSettings)settings.getJaxbElement()).getDefaultTabStop() != null && (defaultTab = (twips = ((CTSettings)settings.getJaxbElement()).getDefaultTabStop()).getVal().intValue()) > 0) {
            log.debug("tab stop: using default from docx");
            int tabNUmber = (int)Math.floor((pos + numWidth) / defaultTab);
            int nextTabPos = defaultTab * (tabNUmber + 1);
            return nextTabPos - pos;
        }
        log.debug("tab stop: assuming default tab 360");
        int tabNUmber = (int)Math.floor((pos + numWidth) / defaultTab);
        int nextTabPos = defaultTab * (tabNUmber + 1);
        return nextTabPos - pos;
    }

    private static void createFoAttributes(OpcPackage opcPackage, PPr pPr, Element foBlockElement, boolean inList, boolean ignoreBorders) {
        CTTabStop tabStop;
        List<Property> properties = PropertyFactory.createProperties(opcPackage, pPr);
        for (Property p : properties) {
            if (p == null || ignoreBorders && (p instanceof PBorderTop || p instanceof PBorderBottom)) continue;
            if (inList && !(p instanceof Indent)) {
                p.setXslFO(foBlockElement);
                continue;
            }
            if (inList) continue;
            p.setXslFO(foBlockElement);
        }
        if (pPr == null) {
            return;
        }
        if (pPr.getBidi() != null && pPr.getBidi().isVal() && pPr.getJc() != null) {
            if (pPr.getJc().getVal().equals((Object)JcEnumeration.RIGHT)) {
                foBlockElement.setAttribute("text-align", "left");
            } else if (pPr.getJc().getVal().equals((Object)JcEnumeration.LEFT)) {
                foBlockElement.setAttribute("text-align", "right");
            }
        }
        if (pPr.getTabs() != null && (tabStop = pPr.getTabs().getTab().get(0)) != null && tabStop.getVal().equals((Object)STTabJc.RIGHT)) {
            foBlockElement.setAttribute("text-align-last", "justify");
        }
    }

    public static void applyFoAttributes(List<Property> properties, Element foElement) {
        if (properties != null && !properties.isEmpty()) {
            for (int i = 0; i < properties.size(); ++i) {
                properties.get(i).setXslFO(foElement);
            }
        }
    }

    private static void createFoAttributes(TrPr trPr, Element foBlockElement) {
        if (trPr == null) {
            return;
        }
        XsltFOFunctions.applyFoAttributes(PropertyFactory.createProperties(trPr), foBlockElement);
    }

    private static void createFoAttributes(TcPr tcPr, Element foBlockElement) {
        if (tcPr == null) {
            return;
        }
        XsltFOFunctions.applyFoAttributes(PropertyFactory.createProperties(tcPr), foBlockElement);
    }

    public static DocumentFragment createBlockForRPr(FOConversionContext context, NodeIterator pPrNodeIt, NodeIterator rPrNodeIt, NodeIterator childResults) {
        PropertyResolver propertyResolver = context.getPropertyResolver();
        try {
            Node n;
            Unmarshaller u = Context.jc.createUnmarshaller();
            u.setEventHandler((ValidationEventHandler)new JaxbValidationEventHandler());
            PPr pPrDirect = null;
            if (pPrNodeIt != null && (n = pPrNodeIt.nextNode()) != null) {
                Object jaxb = u.unmarshal(n);
                try {
                    pPrDirect = (PPr)jaxb;
                }
                catch (ClassCastException e) {
                    log.error("Couldn't cast to PPr " + jaxb.getClass().getName() + " to PPr!");
                }
            }
            Object jaxbR = u.unmarshal(rPrNodeIt.nextNode());
            RPr rPr = null;
            if (jaxbR instanceof RPr) {
                rPr = propertyResolver.getEffectiveRPr((RPr)jaxbR, pPrDirect);
            } else if (jaxbR instanceof ParaRPr) {
                rPr = propertyResolver.getEffectiveRPr(null, pPrDirect);
                StyleUtil.apply((ParaRPr)jaxbR, rPr);
            } else {
                log.error("TODO handle  .." + jaxbR.getClass().getName());
            }
            Document document = XmlUtils.getNewDocumentBuilder().newDocument();
            Element foInlineElement = document.createElementNS("http://www.w3.org/1999/XSL/Format", "fo:inline");
            document.appendChild(foInlineElement);
            XsltFOFunctions.createFoAttributes(context.getWmlPackage(), rPr, foInlineElement);
            Node n2 = childResults.nextNode();
            XmlUtils.treeCopy(n2, (Node)foInlineElement);
            DocumentFragment docfrag = document.createDocumentFragment();
            docfrag.appendChild(document.getDocumentElement());
            return docfrag;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    private static void createFoAttributes(OpcPackage opcPackage, RPr rPr, Element foInlineElement) {
        List<Property> properties = PropertyFactory.createProperties(opcPackage, rPr);
        for (Property p : properties) {
            p.setXslFO(foInlineElement);
        }
    }

    public static String getPageNumberFormat(FOConversionContext context) {
        String pageFormat = context.getSections().getCurrentSection().getPageNumberInformation().getPageFormat();
        return (pageFormat = FormattingSwitchHelper.getFoPageNumberFormat(pageFormat)) == null ? "" : pageFormat;
    }

    public static String getPageNumberInitial(FOConversionContext context) {
        int ret = context.getSections().getCurrentSection().getPageNumberInformation().getPageStart();
        return ret == -1 ? "" : Integer.toString(ret);
    }

    public static String getForcePageCount(FOConversionContext context) {
        ConversionSectionWrapper wrapper = context.getSections().peekNextSection();
        if (wrapper == null) {
            return "no-force";
        }
        SectPr.Type secType = wrapper.getSectPr().getType();
        CTPageNumber pgNumType = wrapper.getSectPr().getPgNumType();
        Boolean isExplicitOdd = null;
        if (pgNumType != null && pgNumType.getStart() != null) {
            int start = pgNumType.getStart().intValue();
            isExplicitOdd = start % 2 == 0 ? Boolean.FALSE : Boolean.TRUE;
        }
        if (secType == null || secType.getVal().equals("nextPage")) {
            return "no-force";
        }
        if (isExplicitOdd == null || isExplicitOdd.booleanValue()) {
            if (secType.getVal().equals("evenPage")) {
                return "end-on-odd";
            }
            if (secType.getVal().equals("oddPage")) {
                return "end-on-even";
            }
            return "no-force";
        }
        if (secType.getVal().equals("evenPage")) {
            return "end-on-even";
        }
        if (secType.getVal().equals("oddPage")) {
            return "end-on-odd";
        }
        return "no-force";
    }

    private static boolean isOdd(SectPr sectPr) {
        CTPageNumber pgNumType = sectPr.getPgNumType();
        return true;
    }

    public static boolean hasPgNumTypeStart(FOConversionContext context) {
        return context.getSections().getCurrentSection().getPageNumberInformation().getPageStart() > -1;
    }
}

