/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.openpackaging.io3;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.HashMap;
import org.docx4j.Docx4jProperties;
import org.docx4j.docProps.core.CoreProperties;
import org.docx4j.docProps.core.dc.elements.ObjectFactory;
import org.docx4j.docProps.extended.Properties;
import org.docx4j.openpackaging.URIHelper;
import org.docx4j.openpackaging.contenttype.ContentTypeManager;
import org.docx4j.openpackaging.exceptions.Docx4JException;
import org.docx4j.openpackaging.io3.stores.PartStore;
import org.docx4j.openpackaging.io3.stores.ZipPartStore;
import org.docx4j.openpackaging.packages.OpcPackage;
import org.docx4j.openpackaging.parts.CustomXmlDataStoragePart;
import org.docx4j.openpackaging.parts.DocPropsCorePart;
import org.docx4j.openpackaging.parts.DocPropsExtendedPart;
import org.docx4j.openpackaging.parts.JaxbXmlPart;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.WordprocessingML.BinaryPart;
import org.docx4j.openpackaging.parts.XmlPart;
import org.docx4j.openpackaging.parts.relationships.RelationshipsPart;
import org.docx4j.relationships.Relationship;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Save {
    private static Logger log = LoggerFactory.getLogger(Save.class);
    public OpcPackage p;
    private HashMap<String, String> handled;

    public Save(OpcPackage p) {
        PartStore targetPartStore;
        this.p = p;
        if (p.getSourcePartStore() == null) {
            log.debug("sourcePartStore undefined");
            targetPartStore = new ZipPartStore();
        } else {
            targetPartStore = p.getSourcePartStore();
            targetPartStore.setSourcePartStore(p.getSourcePartStore());
        }
        p.setTargetPartStore(targetPartStore);
    }

    public Save(OpcPackage p, PartStore targetPartStore) {
        this.p = p;
        if (p.getSourcePartStore() == null) {
            log.debug("sourcePartStore undefined");
        } else {
            targetPartStore.setSourcePartStore(p.getSourcePartStore());
        }
        p.setTargetPartStore(targetPartStore);
    }

    public boolean save(OutputStream realOS) throws Docx4JException {
        this.handled = new HashMap();
        try {
            this.p.getTargetPartStore().setOutputStream(realOS);
            ContentTypeManager ctm = this.p.getContentTypeManager();
            this.p.getTargetPartStore().saveContentTypes(ctm);
            String partName = "_rels/.rels";
            RelationshipsPart rp = this.p.getRelationshipsPart();
            this.saveRawXmlPart(rp);
            this.addPartsFromRelationships(rp);
            this.p.getTargetPartStore().finishSave();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e instanceof Docx4JException) {
                throw (Docx4JException)e;
            }
            throw new Docx4JException("Failed to save package", e);
        }
        log.debug("...Done!");
        return true;
    }

    public void saveRawXmlPart(Part part) throws Docx4JException {
        try {
            if (part instanceof JaxbXmlPart) {
                boolean appWrite;
                Object cp;
                boolean dcWrite;
                if (part instanceof DocPropsCorePart && (dcWrite = Boolean.parseBoolean(Docx4jProperties.getProperties().getProperty("docx4j.dc.write", "false")))) {
                    cp = (CoreProperties)((DocPropsCorePart)part).getJaxbElement();
                    String creator = Docx4jProperties.getProperties().getProperty("docx4j.dc.creator.value", "docx4j");
                    if (((CoreProperties)cp).getCreator() == null) {
                        ObjectFactory of = new ObjectFactory();
                        ((CoreProperties)cp).setCreator(of.createSimpleLiteral());
                        ((CoreProperties)cp).getCreator().getContent().add(creator);
                    }
                    String modifier = Docx4jProperties.getProperties().getProperty("docx4j.dc.lastModifiedBy.value", "docx4j");
                    ((CoreProperties)cp).setLastModifiedBy(modifier);
                }
                if (part instanceof DocPropsExtendedPart && (appWrite = Boolean.parseBoolean(Docx4jProperties.getProperties().getProperty("docx4j.App.write", "false")))) {
                    cp = (Properties)((DocPropsExtendedPart)part).getJaxbElement();
                    ((Properties)cp).setApplication(Docx4jProperties.getProperties().getProperty("docx4j.Application", "docx4j"));
                    String version = Docx4jProperties.getProperties().getProperty("docx4j.AppVersion");
                    if (version != null) {
                        ((Properties)cp).setAppVersion(version);
                    }
                }
                this.p.getTargetPartStore().saveJaxbXmlPart((JaxbXmlPart)part);
            } else if (part instanceof CustomXmlDataStoragePart) {
                this.p.getTargetPartStore().saveCustomXmlDataStoragePart((CustomXmlDataStoragePart)part);
            } else if (part instanceof XmlPart) {
                this.p.getTargetPartStore().saveXmlPart((XmlPart)part);
            } else {
                log.error("PROBLEM - No suitable part found for: " + part.getPartName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage(), e);
            throw new Docx4JException("Problem saving part " + part.getPartName(), e);
        }
    }

    public void addPartsFromRelationships(RelationshipsPart rp) throws Docx4JException {
        for (Relationship r : rp.getRelationships().getRelationship()) {
            log.debug("For Relationship Id=" + r.getId() + " Source is " + rp.getSourceP().getPartName() + ", Target is " + r.getTarget());
            if (r.getType().equals("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink")) continue;
            if (r.getTargetMode() != null && r.getTargetMode().equals("External")) {
                log.debug("Encountered external resource " + r.getTarget() + " of type " + r.getType());
                continue;
            }
            try {
                String resolvedPartUri = URIHelper.resolvePartUri(rp.getSourceURI(), new URI(r.getTarget())).toString();
                resolvedPartUri = resolvedPartUri.substring(1);
                log.debug("Getting part /" + resolvedPartUri);
                Part part = rp.getPart(r);
                if (part == null) {
                    log.error("Part " + resolvedPartUri + " not found!");
                } else {
                    log.debug(part.getClass().getName());
                }
                if (part.getPackage() == null) {
                    log.warn("Part " + resolvedPartUri + " is not attached to any package");
                } else if (!part.getPackage().equals(this.p)) {
                    log.warn("Part " + resolvedPartUri + " is attached to some other package");
                }
                this.savePart(part);
            }
            catch (Exception e) {
                throw new Docx4JException("Failed to add parts from relationships of " + rp.getSourceP().getPartName(), e);
            }
        }
    }

    public void savePart(Part part) throws Docx4JException, IOException {
        String resolvedPartUri = part.getPartName().getName().substring(1);
        if (this.handled.get(resolvedPartUri) != null) {
            log.debug(".. duplicate save avoided ..");
            return;
        }
        if (part instanceof BinaryPart) {
            log.debug(".. saving binary stuff");
            this.p.getTargetPartStore().saveBinaryPart(part);
        } else {
            log.debug(".. saving ");
            this.saveRawXmlPart(part);
        }
        this.handled.put(resolvedPartUri, resolvedPartUri);
        RelationshipsPart rrp = part.getRelationshipsPart(false);
        if (rrp != null && rrp.getRelationships().getRelationship().size() > 0) {
            this.saveRawXmlPart(rrp);
            this.addPartsFromRelationships(rrp);
        }
    }
}

